/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller.jobs;

import com.excentis.products.byteblower.bear.controller.commands.BearSetCommand;
import com.excentis.products.byteblower.bear.controller.commands.BearSetScenarioStatusCommand;
import com.excentis.products.byteblower.bear.controller.commands.CreateBearScenarioForceCleanupJobCommand;
import com.excentis.products.byteblower.bear.controller.jobs.RuntimeBearJob;
import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.bear.feedback.status.EBearScenarioStatus;
import com.excentis.products.byteblower.bear.model.bear.BearPackage;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import com.excentis.products.byteblower.bear.model.bear.BearScenario;
import com.excentis.products.byteblower.bear.model.bear.EBearJobStatus;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import com.excentis.products.byteblower.run.actions.core.CancellationTriggered;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ForceCleanupScenario
extends RuntimeBearJob {
    private static final Logger LOGGER = Logger.getGlobal();
    private final BearScenario bearScenario;
    private final RuntimeScenarioRunner rtScenarioRunner;

    public ForceCleanupScenario(BearScenarioId bearScenarioId, RuntimeScenarioRunner rtScenarioRunner) {
        super("Cancel scenario " + (rtScenarioRunner == null || rtScenarioRunner.getRuntimeScenario() == null ? "No name!" : rtScenarioRunner.getRuntimeScenario().getName()));
        this.rtScenarioRunner = rtScenarioRunner;
        this.bearScenario = this.getBearReader().getBearScenario(bearScenarioId);
        BearRoot bearRoot = this.getBearRoot();
        CreateBearScenarioForceCleanupJobCommand jobCommand = new CreateBearScenarioForceCleanupJobCommand(bearRoot, this.bearScenario, this);
        this.execute(jobCommand);
        this.bearJob = jobCommand.getBearJob();
        this.setJobStatus(EBearJobStatus.INITIALIZED);
    }

    @Override
    protected void work(IProgressMonitor progressMonitor) {
        RuntimeScenario rtScenario = this.rtScenarioRunner.getRuntimeScenario();
        if (rtScenario == null) {
            LOGGER.info("Can't clean. Scenario not started, or already stopped");
            return;
        }
        progressMonitor.beginTask("Cancelling scenario", 100);
        try {
            this.setScenarioStatus(EBearScenarioStatus.CANCELED);
            if (!this.rtScenarioRunner.isCancelled()) {
                this.rtScenarioRunner.finalCleanup(progressMonitor);
            } else {
                LOGGER.info("scenario was already cancelled, doing nothing!");
            }
        }
        catch (CancellationTriggered e) {
            LOGGER.log(Level.INFO, "Canceled scenario", e);
            this.setScenarioStatus(EBearScenarioStatus.CANCELED);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Scenario did end in an error", e);
            this.setScenarioException(e);
            this.setScenarioStatus(EBearScenarioStatus.ERROR);
        }
        catch (Throwable e) {
            this.setScenarioStatus(EBearScenarioStatus.ERROR);
        }
    }

    private void setScenarioStatus(EBearScenarioStatus status) {
        BearSetScenarioStatusCommand command = new BearSetScenarioStatusCommand(this.bearScenario, status);
        this.execute(command);
    }

    private void setScenarioException(Exception e) {
        BearSetCommand cmd = new BearSetCommand((EObject)this.bearScenario, (EStructuralFeature)BearPackage.Literals.BEAR_SCENARIO__EXCEPTION, e);
        this.execute(cmd);
    }
}

