/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller.jobs;

import com.excentis.products.byteblower.bear.controller.commands.BearSetCommand;
import com.excentis.products.byteblower.bear.controller.commands.BearSetProjectStatusCommand;
import com.excentis.products.byteblower.bear.controller.commands.CreateBearProjectCommand;
import com.excentis.products.byteblower.bear.controller.commands.CreateBearProjectJobCommand;
import com.excentis.products.byteblower.bear.controller.jobs.RuntimeBearJob;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.feedback.status.EBearProjectStatus;
import com.excentis.products.byteblower.bear.model.bear.BearPackage;
import com.excentis.products.byteblower.bear.model.bear.BearProject;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import com.excentis.products.byteblower.bear.model.bear.EBearJobStatus;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.project.ByteBlowerResource;
import com.excentis.products.byteblower.project.ByteBlowerResourceController;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

abstract class OpenProjectJob
extends RuntimeBearJob {
    private final BearProject bearProject;

    OpenProjectJob(String name, BearProjectId projectId) {
        super(name);
        BearRoot bearRoot = this.getBearRoot();
        CreateBearProjectCommand command = new CreateBearProjectCommand(bearRoot, projectId);
        this.execute(command);
        this.bearProject = command.getBearProject();
        CreateBearProjectJobCommand jobCommand = new CreateBearProjectJobCommand(bearRoot, this.bearProject, this);
        this.execute(jobCommand);
        this.bearJob = jobCommand.getBearJob();
        this.setJobStatus(EBearJobStatus.INITIALIZED);
    }

    @Override
    protected void work(IProgressMonitor progressMonitor) {
        try {
            this.setProjectStatus(EBearProjectStatus.OPENING);
            ByteBlowerResourceController resourceController = ByteBlowerResourceController.getInstance();
            String resourceUriString = this.openProject(resourceController);
            ByteBlowerResource resource = resourceController.getResource(resourceUriString);
            if (resource == null) {
                throw new IllegalStateException("Failed to open project. Loaded ByteBlowerResource was null.");
            }
            ByteBlowerProject mProject = resource.getByteBlowerProject();
            if (mProject == null) {
                throw new IllegalStateException("Failed to open project. ByteBlowerProject in loaded resource was null.");
            }
            BearSetCommand uriCommand = new BearSetCommand((EObject)this.bearProject, (EStructuralFeature)BearPackage.Literals.BEAR_PROJECT__RESOURCE_URI_STRING, resourceUriString);
            this.execute(uriCommand);
            BearSetCommand projectCommand = new BearSetCommand((EObject)this.bearProject, (EStructuralFeature)BearPackage.Literals.BEAR_PROJECT__PROJECT, mProject);
            this.execute(projectCommand);
            this.setProjectStatus(EBearProjectStatus.OPENED);
        }
        catch (Exception e) {
            this.setProjectException(e);
            this.setProjectStatus(EBearProjectStatus.ERROR);
        }
    }

    private void setProjectStatus(EBearProjectStatus status) {
        BearSetProjectStatusCommand command = new BearSetProjectStatusCommand(this.bearProject, status);
        this.execute(command);
    }

    private void setProjectException(Exception e) {
        BearSetCommand cmd = new BearSetCommand((EObject)this.bearProject, (EStructuralFeature)BearPackage.Literals.BEAR_PROJECT__EXCEPTION, e);
        this.execute(cmd);
    }

    protected abstract String openProject(ByteBlowerResourceController var1);
}

