/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.impl;

import com.excentis.products.byteblower.bear.BearEvent;
import com.excentis.products.byteblower.bear.ProjectReference;
import com.excentis.products.byteblower.bear.TestReference;
import com.excentis.products.byteblower.bear.TestResultReference;
import com.excentis.products.byteblower.bear.operations.CancelableOperation;
import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.bear.operations.impl.ForceCleanupScenarioOperation;
import com.excentis.products.byteblower.bear.operations.impl.InitializeScenarioOperation;
import com.excentis.products.byteblower.bear.operations.impl.OpenProjectFileOperation;
import com.excentis.products.byteblower.bear.operations.impl.OpenProjectXmlOperation;
import com.excentis.products.byteblower.bear.operations.impl.RunScenarioOperation;

class BearOperationFactory {
    private static BearOperationFactory instance = null;

    public static synchronized BearOperationFactory getInstance() {
        if (instance == null) {
            instance = new BearOperationFactory();
        }
        return instance;
    }

    public Operation createOpenFileProjectOperation(String filename, Operation.Callback<ProjectReference> callback) {
        return new OpenProjectFileOperation(filename, callback);
    }

    public Operation createOpenXmlProjectOperation(String xmlString, Operation.Callback<ProjectReference> callback) {
        return new OpenProjectXmlOperation(xmlString, callback);
    }

    public CancelableOperation createInitializeTestOperation(ProjectReference project, String scenarioName, String runTitle, Operation.FeedbackCallback<TestReference, BearEvent> callback, CancelableOperation.Callback cancelCallback) {
        return new InitializeScenarioOperation(project, scenarioName, runTitle, callback, cancelCallback);
    }

    public CancelableOperation createRunTestOperation(TestReference test, Operation.FeedbackCallback<TestResultReference, BearEvent> callback, CancelableOperation.Callback cancelCallback) {
        return new RunScenarioOperation(test, callback, cancelCallback);
    }

    public CancelableOperation createForceCleanupOperation(TestReference test, Operation.FeedbackCallback<TestResultReference, BearEvent> callback, CancelableOperation.Callback cancelCallback) {
        return new ForceCleanupScenarioOperation(test, callback, cancelCallback);
    }
}

