/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.operations.impl;

import com.excentis.products.byteblower.bear.BearEvent;
import com.excentis.products.byteblower.bear.PersistenceReadyEvent;
import com.excentis.products.byteblower.bear.ProjectReference;
import com.excentis.products.byteblower.bear.TestReference;
import com.excentis.products.byteblower.bear.controller.BearController;
import com.excentis.products.byteblower.bear.feedback.id.BearId;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.bear.feedback.listener.IBearListener;
import com.excentis.products.byteblower.bear.feedback.status.EBearScenarioStatus;
import com.excentis.products.byteblower.bear.model.bear.BearPackage;
import com.excentis.products.byteblower.bear.model.bear.BearScenario;
import com.excentis.products.byteblower.bear.operations.CancelableOperation;
import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.bear.operations.impl.core.BaseCancelableFeedbackOperation;
import org.eclipse.emf.common.notify.Notification;

public class InitializeScenarioOperation
extends BaseCancelableFeedbackOperation<TestReference, BearEvent>
implements IBearListener {
    private BearController controller = BearController.getInstance();
    private final BearProjectId projectId;
    private final String scenarioName;
    private final String runTitle;
    private final BearScenarioId scenarioId;

    public InitializeScenarioOperation(ProjectReference project, String scenarioName, String runTitle, Operation.FeedbackCallback<TestReference, BearEvent> callback, CancelableOperation.Callback cancelCallback) {
        super(callback, cancelCallback);
        this.projectId = new BearProjectId(project.getId());
        this.scenarioName = scenarioName;
        this.runTitle = runTitle;
        this.scenarioId = new BearScenarioId();
    }

    @Override
    protected void performImpl() throws Exception {
        this.controller.addBearListener((IBearListener)this);
        this.controller.initializeScenario(this.projectId, this.scenarioId, this.scenarioName, this.runTitle);
    }

    @Override
    protected void cancelRequestImpl() throws Exception {
        this.controller.cancelJob((BearId)this.scenarioId);
    }

    public void onBearModelNotification(Notification notification) {
        BearScenario bearScenario;
        BearScenarioId bearScenarioId;
        if (notification.getEventType() == 1 && notification.getFeature() == BearPackage.Literals.BEAR_SCENARIO__STATUS && (bearScenarioId = (bearScenario = (BearScenario)notification.getNotifier()).getBearScenarioId()).equals((Object)this.scenarioId)) {
            EBearScenarioStatus oldScenarioStatus = (EBearScenarioStatus)notification.getOldValue();
            EBearScenarioStatus newScenarioStatus = (EBearScenarioStatus)notification.getNewValue();
            if (oldScenarioStatus == EBearScenarioStatus.CREATED || oldScenarioStatus == EBearScenarioStatus.PERSISTENCE_HOOKED || oldScenarioStatus == EBearScenarioStatus.INITIALIZING) {
                if (newScenarioStatus == EBearScenarioStatus.INITIALIZED) {
                    this.controller.removeBearListener((IBearListener)this);
                    this.triggerFinished(new TestReference(this.scenarioId.getId()));
                } else if (newScenarioStatus == EBearScenarioStatus.PERSISTENCE_HOOKED) {
                    Long testDataPersistenceId = bearScenario.getTestDataPersistenceId();
                    this.triggerEvent(new PersistenceReadyEvent(this.scenarioId.getId(), testDataPersistenceId));
                } else if (newScenarioStatus == EBearScenarioStatus.ERROR) {
                    Exception scenarioException = bearScenario.getException();
                    if (scenarioException == null) {
                        scenarioException = new RuntimeException("Scenario initialization failed without error information");
                    }
                    this.controller.removeBearListener((IBearListener)this);
                    this.triggerError(scenarioException);
                } else if (newScenarioStatus == EBearScenarioStatus.CANCELED) {
                    this.controller.removeBearListener((IBearListener)this);
                    this.triggerCancelHandled();
                }
            }
        }
    }
}

