/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.operations.impl;

import com.excentis.products.byteblower.bear.ProjectReference;
import com.excentis.products.byteblower.bear.controller.BearController;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.feedback.listener.IBearListener;
import com.excentis.products.byteblower.bear.feedback.status.EBearProjectStatus;
import com.excentis.products.byteblower.bear.model.bear.BearPackage;
import com.excentis.products.byteblower.bear.model.bear.BearProject;
import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.bear.operations.impl.core.BaseOperation;
import org.eclipse.emf.common.notify.Notification;

class OpenProjectOperation
extends BaseOperation<ProjectReference>
implements IBearListener {
    protected BearController controller = BearController.getInstance();
    protected final BearProjectId projectId = new BearProjectId();

    public OpenProjectOperation(Operation.Callback<ProjectReference> callback) {
        super(callback);
    }

    @Override
    protected void performImpl() throws Exception {
        this.controller.addBearListener((IBearListener)this);
    }

    public void onBearModelNotification(Notification notification) {
        if (notification.getEventType() == 1 && notification.getFeature() == BearPackage.Literals.BEAR_PROJECT__STATUS) {
            BearProject bearProject = (BearProject)notification.getNotifier();
            BearProjectId bearProjectId = bearProject.getBearProjectId();
            String bearProjectResourceUriString = bearProject.getResourceUriString();
            if (bearProjectId.equals((Object)this.projectId)) {
                EBearProjectStatus oldProjectStatus = (EBearProjectStatus)notification.getOldValue();
                EBearProjectStatus newProjectStatus = (EBearProjectStatus)notification.getNewValue();
                if (oldProjectStatus == EBearProjectStatus.CREATED || oldProjectStatus == EBearProjectStatus.OPENING) {
                    if (newProjectStatus == EBearProjectStatus.OPENED) {
                        this.controller.removeBearListener((IBearListener)this);
                        this.triggerFinished(new ProjectReference(bearProjectId.getId(), bearProjectResourceUriString));
                    } else if (newProjectStatus == EBearProjectStatus.ERROR) {
                        Exception projectException = bearProject.getException();
                        if (projectException == null) {
                            projectException = new RuntimeException("Project open failed without error information");
                        }
                        this.controller.removeBearListener((IBearListener)this);
                        this.triggerError(projectException);
                    }
                }
            }
        }
    }
}

