/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.clt;

import com.excentis.products.byteblower.clt.ByteBlowerPlugin;
import com.excentis.products.byteblower.clt.CLIException;
import com.excentis.products.byteblower.clt.CLTPrinter;
import com.excentis.products.byteblower.clt.ErrorGenerator;
import com.excentis.products.byteblower.clt.ExitCode;
import com.excentis.products.byteblower.clt.ReportGenerationJob;
import com.excentis.products.byteblower.clt.TestType;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.report.ReportGenerator;
import com.excentis.products.byteblower.report.ReportPreferences;
import com.excentis.products.byteblower.report.UploadConfig;
import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.html2.ReportManagerHtml;
import com.excentis.products.byteblower.report.generator.html2.ReportManagerHtmlV2;
import com.excentis.products.byteblower.report.generator.html2.unittest.JavascriptTests;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceController;
import com.excentis.products.byteblower.results.dataprovider.data.TestDataReferenceManager;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.runner.Runner;
import com.excentis.products.byteblower.runner.jobs.ExecuteBatchJob;
import com.excentis.products.byteblower.runner.jobs.ExecuteScenarioJob;
import com.excentis.products.byteblower.runner.jobs.ExecutionJob;
import com.excentis.products.byteblower.runner.jobs.IBatchJobListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Version;

public class ByteBlowerApplication
implements IApplication {
    protected static final Logger LOGGER = Logger.getGlobal();
    protected static final String HELPSTRING = "Runs the specified scenario or batch of the specified project and generates a report";
    protected static final String USAGESTRING = "ByteBlower-CLT [-project] <project-file> (-scenario <scenario>|-batch <batch>)";
    private Path projectFilePath;
    private Path outputDirPath;
    private String testName;
    private UploadConfig upload = new UploadConfig();
    private AtomicBoolean ready = new AtomicBoolean(false);
    private ErrorGenerator error = ErrorGenerator.correct();
    private TestStatus testRunStatus = TestStatus.ERROR;
    private CLTPrinter printer = new CLTPrinter();
    private final Options cliOptions;

    static {
        LOGGER.setLevel(Level.ALL);
        $SWITCH_TABLE$com$excentis$products$byteblower$clt$TestType = ByteBlowerApplication.$SWITCH_TABLE$com$excentis$products$byteblower$clt$TestType();
    }

    public ByteBlowerApplication() {
        String reportFormatList = String.join((CharSequence)" ", Arrays.asList(ReportOutputFormat.values()).stream().map(Enum::toString).collect(Collectors.toList()));
        String reportFormatDescription = String.format("Generates the report of the last testrun. This argument is very useful for tests stopped by CTRL-C. By default, all report formats are generated (%s). You can also supply a selection of these formats as a list (e.g. 'html pdf csv'). This argument makes the CLT ignore arguments -project, -scenario, -batch, -title", reportFormatList);
        this.cliOptions = new Options();
        OptionBuilder.withDescription((String)"show this help");
        this.cliOptions.addOption(OptionBuilder.create((String)"help"));
        OptionBuilder.withDescription((String)"show this help");
        OptionBuilder.withLongOpt((String)"help");
        this.cliOptions.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"project-file-path");
        OptionBuilder.withDescription((String)"path to project file to open");
        this.cliOptions.addOption(OptionBuilder.create((String)"project"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"scenario-name");
        OptionBuilder.withDescription((String)"name of the scenario to execute");
        this.cliOptions.addOption(OptionBuilder.create((String)"scenario"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"batch-name");
        OptionBuilder.withDescription((String)"name of the batch to execute");
        this.cliOptions.addOption(OptionBuilder.create((String)"batch"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"run-title");
        OptionBuilder.withDescription((String)"run title");
        this.cliOptions.addOption(OptionBuilder.create((String)"title"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"output-dir-path");
        OptionBuilder.withDescription((String)"path to the output directory; defaults to archive dir");
        this.cliOptions.addOption(OptionBuilder.create((String)"output"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"test-dir-path");
        OptionBuilder.withDescription((String)"path to the directory where to store the raw test data; defaults to workspace_v2/TestData dir ");
        this.cliOptions.addOption(OptionBuilder.create((String)"store"));
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)"report-formats");
        OptionBuilder.withDescription((String)reportFormatDescription);
        this.cliOptions.addOption(OptionBuilder.create((String)"regenerate"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"api-key-value");
        OptionBuilder.withDescription((String)"API key for authenticating to the Excentis Cloud.");
        this.cliOptions.addOption(OptionBuilder.create((String)"apiKey"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path-to-api-key");
        OptionBuilder.withDescription((String)"File containing the API key for authenticating to the Excentis Cloud.");
        this.cliOptions.addOption(OptionBuilder.create((String)"apiKeyFile"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)"Custom Upload URL for Excentis Cloud");
        this.cliOptions.addOption(OptionBuilder.create((String)"cloudUrl"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file-name");
        this.cliOptions.addOption(OptionBuilder.create((String)"unittests"));
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)"json-file");
        OptionBuilder.withDescription((String)reportFormatDescription);
        this.cliOptions.addOption(OptionBuilder.create((String)"htmlreport"));
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)"json-file");
        OptionBuilder.withDescription((String)reportFormatDescription);
        this.cliOptions.addOption(OptionBuilder.create((String)"htmlreport_v2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFinish() {
        this.ready.set(true);
        AtomicBoolean atomicBoolean = this.ready;
        synchronized (atomicBoolean) {
            this.ready.notifyAll();
        }
    }

    private CommandLine parseOptions() {
        String[] args = Platform.getCommandLineArgs();
        BasicParser parser = new BasicParser(){

            protected void processOption(String arg, ListIterator iter) throws ParseException {
                if (this.getOptions().hasOption(arg)) {
                    super.processOption(arg, iter);
                }
            }
        };
        try {
            return parser.parse(this.cliOptions, args, false);
        }
        catch (ParseException pe) {
            LOGGER.severe(() -> String.format("Failed to parse arguments: %s %n", pe.getMessage()));
            throw new CLIException(ExitCode.EX_USAGE);
        }
    }

    private String searchProjectArgument(CommandLine cl) {
        String stringArg;
        String projectFileString = null;
        String mulitProjectErrorMsg = "Multiple project arguments (*" + ByteBlowerPreferences.getProjectFileExtension() + ") found";
        Iterator it = cl.getArgList().iterator();
        if (cl.hasOption("project")) {
            projectFileString = this.getSingleOption("project", cl);
            mulitProjectErrorMsg = String.format("Both option '-project' and project file argument(s) (*%s) found", ByteBlowerPreferences.getProjectFileExtension());
        }
        while (projectFileString == null && it.hasNext()) {
            stringArg = (String)it.next();
            if (stringArg == null || !stringArg.endsWith(ByteBlowerPreferences.getProjectFileExtension())) continue;
            projectFileString = stringArg;
        }
        while (it.hasNext()) {
            stringArg = (String)it.next();
            if (stringArg == null || !stringArg.endsWith(ByteBlowerPreferences.getProjectFileExtension())) continue;
            this.printer.printSyntaxError(mulitProjectErrorMsg);
            throw new CLIException(ExitCode.EX_USAGE);
        }
        if (projectFileString == null) {
            this.printer.printSyntaxError("Missing mandatory project file argument or '-project' option");
            throw new CLIException(ExitCode.EX_USAGE);
        }
        return projectFileString;
    }

    private Path searchProjectPath(CommandLine cl) {
        Path projectFileLocation;
        String projectFileString = this.searchProjectArgument(cl);
        try {
            projectFileLocation = Paths.get(projectFileString, new String[0]);
            if (!Files.exists(projectFileLocation, new LinkOption[0])) {
                this.printer.printError("Project file does not exist: " + projectFileString);
                throw new CLIException(ExitCode.EX_NOINPUT);
            }
            if (!Files.isRegularFile(projectFileLocation, new LinkOption[0])) {
                this.printer.printError("Project file is not a regular file: " + projectFileString);
                throw new CLIException(ExitCode.EX_DATAERR);
            }
            if (!Files.isReadable(projectFileLocation)) {
                this.printer.printError("Project file is not readable: " + projectFileString);
                throw new CLIException(ExitCode.EX_DATAERR);
            }
        }
        catch (InvalidPathException invalidPathException) {
            this.printer.printError("Invalid project file path: " + projectFileString);
            throw new CLIException(ExitCode.EX_DATAERR);
        }
        return projectFileLocation;
    }

    private ReportPreferences searchRegenerateOptions(String[] values) {
        int n;
        ReportPreferences prefs = new ReportPreferences(this.outputDirPath.toString());
        Set<String> reportValues = new HashSet<String>();
        if (values == null) {
            ReportOutputFormat[] reportOutputFormatArray = ReportOutputFormat.values();
            n = reportOutputFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportOutputFormat aFormat = reportOutputFormatArray[n2];
                reportValues.add(aFormat.name());
                ++n2;
            }
        } else {
            reportValues.addAll(Arrays.asList(values));
        }
        reportValues = this.lowerCaseSet(reportValues);
        HashSet<ReportOutputFormat> formats = new HashSet<ReportOutputFormat>();
        ReportOutputFormat[] reportOutputFormatArray = ReportOutputFormat.values();
        int n3 = reportOutputFormatArray.length;
        n = 0;
        while (n < n3) {
            ReportOutputFormat aFormat = reportOutputFormatArray[n];
            if (reportValues.contains(aFormat.name().toLowerCase())) {
                formats.add(aFormat);
                LOGGER.info(() -> String.format("Found format '%s'%n", aFormat.name()));
            }
            ++n;
        }
        prefs.setOutputFormats(formats);
        return prefs;
    }

    private Set<String> lowerCaseSet(Set<String> reportValues) {
        reportValues = reportValues.stream().map(aString -> aString.toLowerCase()).collect(Collectors.toSet());
        return reportValues;
    }

    private String getSingleOptionOrDefault(String optionName, CommandLine cl, String defaultVal) {
        String[] values = cl.getOptionValues(optionName);
        if (values == null || values.length == 0 || values[0] == null) {
            return defaultVal;
        }
        if (values.length > 1) {
            this.printer.printSyntaxError(String.format("Option -'%s' found multiple times", optionName));
            throw new CLIException(ExitCode.EX_USAGE);
        }
        return values[0];
    }

    private String getSingleOption(String optionName, CommandLine cl) {
        String[] values = cl.getOptionValues(optionName);
        if (values == null || values.length == 0 || values[0] == null) {
            this.printer.printSyntaxError(String.format("Missing mandatory argument for option '-%s'", optionName));
            throw new CLIException(ExitCode.EX_USAGE);
        }
        if (values.length > 1) {
            this.printer.printSyntaxError(String.format("Option -'%s' found multiple times", optionName));
            throw new CLIException(ExitCode.EX_USAGE);
        }
        return values[0];
    }

    public Object start(IApplicationContext context) throws Exception {
        Integer returnStatus = IApplication.EXIT_OK;
        try {
            TestType testType;
            HelpFormatter hf = new HelpFormatter();
            CommandLine cl = this.parseOptions();
            Version thisVersion = ByteBlowerPlugin.getDefault().getBundle().getVersion();
            String startTxt = String.format("ByteBlower CLT %s is running !", thisVersion.toString());
            System.out.println(startTxt);
            if (cl.hasOption("help") || cl.hasOption("h")) {
                hf.printHelp(120, USAGESTRING, HELPSTRING, this.cliOptions, null, false);
                return IApplication.EXIT_OK;
            }
            this.outputDirPath = this.searchOutputPath(cl);
            if (cl.hasOption("unittests")) {
                String path = this.outputDirPath.toString();
                String saveName = this.getSingleOption("unittests", cl);
                Path location = Paths.get(path, saveName);
                JavascriptTests.createTestHtml((String)location.toString());
                return returnStatus;
            }
            if (cl.hasOption("htmlreport")) {
                long startMoment = System.nanoTime();
                String startPoint = this.getSingleOption("htmlreport", cl);
                int reportCount = this.iterativeReportGeneration(startPoint, ReportManagerHtml::createReportFromJson);
                long doneMoment = System.nanoTime();
                System.out.format("Reporting speed: %f reports /s %n", (double)reportCount * 1.0E9 / (double)(doneMoment - startMoment));
                return returnStatus;
            }
            if (cl.hasOption("htmlreport_v2")) {
                String startPoint = this.getSingleOption("htmlreport_v2", cl);
                this.iterativeReportGeneration(startPoint, ReportManagerHtmlV2::createReportFromJson);
                return returnStatus;
            }
            this.upload = this.parseUploadConfig(cl);
            ByteBlowerPreferences.overrideApiKeyTemporarily((String)this.upload.apiKey);
            if (cl.hasOption("regenerate")) {
                testType = TestType.GENERATE_REPORT;
            } else {
                this.projectFilePath = this.searchProjectPath(cl);
                if (cl.hasOption("regenerate")) {
                    testType = TestType.GENERATE_REPORT;
                } else {
                    if (!cl.hasOption("scenario") && !cl.hasOption("batch")) {
                        this.printer.printSyntaxError("Missing one of two mandatory options: '-scenario' or '-batch'");
                        throw new CLIException(ExitCode.EX_USAGE);
                    }
                    if (cl.hasOption("scenario") && cl.hasOption("batch")) {
                        this.printer.printSyntaxError("Mutual exclusive options found: '-scenario' and '-batch'");
                        throw new CLIException(ExitCode.EX_USAGE);
                    }
                    if (cl.hasOption("scenario")) {
                        testType = TestType.SCENARIO;
                        this.testName = this.getSingleOption("scenario", cl);
                    } else if (cl.hasOption("batch")) {
                        testType = TestType.BATCH;
                        this.testName = this.getSingleOption("batch", cl);
                    } else {
                        throw new CLIException(ExitCode.EX_USAGE);
                    }
                }
            }
            if (cl.hasOption("store")) {
                String testDataPath = cl.getOptionValue("store");
                String absolutePath = String.valueOf(new File(testDataPath).getAbsolutePath()) + File.separator;
                LOGGER.info(() -> String.format("setting to output:  %s", absolutePath));
                MetaDataPersistenceController.setDefaultPath((String)absolutePath);
                TestDataPersistenceController.setDefaultPath((String)absolutePath);
            }
            String runTitle = "";
            if (cl.hasOption("title")) {
                runTitle = cl.getOptionValue("title");
            }
            Assert.isNotNull((Object)((Object)testType));
            Assert.isNotNull((Object)this.outputDirPath);
            switch (testType) {
                case SCENARIO: {
                    this.scheduleScenario(this.projectFilePath, this.testName, runTitle, this.outputDirPath);
                    this.dofinishTests();
                    break;
                }
                case BATCH: {
                    ExecuteBatchJob g = this.scheduleBatch(this.projectFilePath, this.testName, runTitle);
                    g.join();
                    this.dofinishTests();
                    break;
                }
                case GENERATE_REPORT: {
                    ByteBlowerApplication.regenerateLastReport(this.searchRegenerateOptions(cl.getOptionValues("regenerate")));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (CLIException e) {
            LOGGER.log(Level.WARNING, "Expected error", e.getMessage());
            ByteBlowerApplication.signalNormalShutdown();
            returnStatus = e.getCode().numeric();
        }
        catch (Exception t) {
            LOGGER.log(Level.SEVERE, "Unexpected error", t);
            returnStatus = -1;
        }
        LOGGER.log(Level.INFO, "Returning with value {0}", returnStatus);
        return returnStatus;
    }

    private UploadConfig parseUploadConfig(CommandLine cl) throws CLIException {
        String noVal = null;
        String apiKeyFile = this.getSingleOptionOrDefault("apiKeyFile", cl, noVal);
        String apiKey = this.getSingleOptionOrDefault("apiKey", cl, noVal);
        String upload = this.getSingleOptionOrDefault("cloudUrl", cl, noVal);
        boolean hasApiKeyFile = apiKeyFile != noVal;
        boolean hasPlainApiKey = apiKey != noVal;
        UploadConfig config = new UploadConfig();
        ArrayList<String> keyOptions = new ArrayList<String>();
        if (hasApiKeyFile) {
            keyOptions.add("'-apiKeyFile' program argument");
        }
        if (hasPlainApiKey) {
            keyOptions.add("'-apiKey' program argument");
        }
        if (UploadConfig.hasEnvConfig()) {
            keyOptions.add("EXCENTIS_APIKEY environment variable");
        }
        if (keyOptions.size() > 1) {
            String msgFmt = "Multiple API Key configurations: %s. Using the first listed option.";
            LOGGER.warning(String.format(msgFmt, String.join((CharSequence)", ", keyOptions)));
        }
        if (apiKeyFile != null) {
            try {
                config.setKeyFile(apiKeyFile);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Unable to read API key file", ex.getMessage());
                throw new CLIException(ExitCode.EX_USAGE);
            }
        } else if (apiKey != null) {
            config.setKeyString(apiKey);
        }
        if (upload != null && !upload.isBlank() && !config.setUploadLocation(upload)) {
            LOGGER.log(Level.SEVERE, "Invalid upload location");
            throw new CLIException(ExitCode.EX_USAGE);
        }
        return config;
    }

    private int iterativeReportGeneration(String startPoint, BiConsumer<String, String> generator) {
        int reportCount = 0;
        ArrayDeque<Path> toProcess = new ArrayDeque<Path>();
        HashSet<Path> seen = new HashSet<Path>();
        toProcess.add(Paths.get(startPoint, new String[0]));
        seen.add((Path)toProcess.getFirst());
        while (!toProcess.isEmpty()) {
            Path head = (Path)toProcess.pop();
            File headFile = head.toFile();
            if (headFile.isDirectory()) {
                File[] fileArray = headFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    Path childPath = child.toPath();
                    if (!seen.contains(childPath)) {
                        seen.add(childPath);
                        toProcess.add(childPath);
                    }
                    ++n2;
                }
                continue;
            }
            String filename = head.getFileName().toString();
            if (!filename.endsWith(".json")) continue;
            ++reportCount;
            String savelocation = head.toAbsolutePath().toString().replace(".json", ".html");
            LOGGER.log(Level.INFO, "Creating report from" + filename);
            generator.accept(head.toAbsolutePath().toString(), savelocation);
        }
        return reportCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dofinishTests() throws InterruptedException {
        while (!this.ready.get()) {
            AtomicBoolean atomicBoolean = this.ready;
            synchronized (atomicBoolean) {
                this.ready.wait(1000L);
            }
        }
        this.printer.printInfo(this.testRunStatus.toString());
        this.error.signal();
    }

    private static void regenerateLastReport(ReportPreferences reportPreferences) {
        MetaDataPersistenceController mdpc = MetaDataPersistenceController.getInstance();
        mdpc.forceInitialize();
        TestDataReferenceManager testDataReferenceManager = new TestDataReferenceManager(mdpc);
        long testId = -1L;
        for (TestDataReference ref : testDataReferenceManager.getEntities()) {
            testId = Math.max(testId, ref.getId());
        }
        if (testId > 0L) {
            ReportGenerator.getInstance().generateReport(Long.valueOf(testId), (ReportPreferencesInterface)reportPreferences, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private Path searchOutputPath(CommandLine cl) {
        Path resultPath;
        String outputDirString = cl.hasOption("output") ? this.getSingleOption("output", cl) : ByteBlowerPreferences.getArchiveLocation();
        try {
            resultPath = Paths.get(outputDirString, new String[0]);
        }
        catch (InvalidPathException e) {
            LOGGER.log(Level.WARNING, "Invalid output directory path", e);
            this.printer.printError("Invalid output directory path: " + outputDirString);
            throw new CLIException(ExitCode.EX_USAGE);
        }
        this.verifyOutputPath(resultPath);
        return resultPath;
    }

    private void verifyOutputPath(Path outputDirPath) {
        String outputDirString = outputDirPath.toString();
        if (!Files.exists(outputDirPath, new LinkOption[0])) {
            try {
                Files.createDirectory(outputDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Could not create default output directory", e);
                this.printer.printError("Could not create default output directory: " + outputDirString, e);
                throw new CLIException(ExitCode.EX_DATAERR);
            }
        }
        if (!Files.isDirectory(outputDirPath, new LinkOption[0])) {
            this.printer.printError("Output directory is not a directory: " + outputDirString);
            throw new CLIException(ExitCode.EX_USAGE);
        }
        if (!Files.isWritable(outputDirPath)) {
            this.printer.printError("Output directory is not writable: " + outputDirString);
            throw new CLIException(ExitCode.EX_DATAERR);
        }
    }

    private static void signalNormalShutdown() {
        System.setProperty("eclipse.exitdata", "");
    }

    private ExecuteScenarioJob scheduleScenario(Path projectFilePath, String scenarioName, String runTitle, Path outputDir) {
        ExecuteScenarioJob scenarioJob = new ExecuteScenarioJob(projectFilePath, scenarioName, runTitle);
        scenarioJob.addJobChangeListener((IJobChangeListener)new TestRunFinished(scenarioJob, scenarioName, outputDir, projectFilePath));
        Runner.getInstance().scheduleExecutionJob((ExecutionJob)scenarioJob);
        return scenarioJob;
    }

    private ExecuteBatchJob scheduleBatch(Path projectFilePath, String batchName, String runTitle) {
        ExecuteBatchJob batchJob = new ExecuteBatchJob(projectFilePath, batchName, runTitle);
        batchJob.addBatchJobListener((IBatchJobListener)new TestRunListen());
        Runner.getInstance().scheduleExecutionJob((ExecutionJob)batchJob);
        return batchJob;
    }

    public void stop() {
    }

    private static boolean knowsScenario(ByteBlowerProject project, String scenarioName) {
        for (Scenario scenario : project.getScenario()) {
            if (!scenarioName.equals(scenario.getName())) continue;
            return true;
        }
        return false;
    }

    private ErrorGenerator searchProblem(Path projectFilePath, ByteBlowerProject project, String scenarioName) {
        ErrorGenerator fault;
        if (project == null) {
            this.printer.printError("Could not open the project at " + projectFilePath.getFileName());
            fault = ErrorGenerator.issue(ExitCode.EX_DATAERR);
        } else if (ByteBlowerApplication.knowsScenario(project, scenarioName)) {
            fault = ErrorGenerator.issue(ExitCode.EX_TEMPFAIL);
        } else {
            String format = "The scenario '%s' does not exist in project '%s'";
            this.printer.printError(String.format(format, scenarioName, project.getName()));
            fault = ErrorGenerator.issue(ExitCode.EX_NOINPUT);
        }
        return fault;
    }

    private final class PrintGeneratedReports
    extends JobChangeAdapter {
        private final long testReference;

        private PrintGeneratedReports(long testReference) {
            this.testReference = testReference;
        }

        public void running(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            IStatus result = event.getResult();
            if (!result.isOK()) {
                ByteBlowerApplication.this.printer.printError(result.getMessage(), result.getException());
                ByteBlowerApplication.this.error = ErrorGenerator.issue(ExitCode.EX_SOFTWARE);
            } else {
                for (String reportFileName : this.getReportFileNames(this.testReference)) {
                    ByteBlowerApplication.this.printer.printInfo("Report generated: " + reportFileName);
                }
            }
            ByteBlowerApplication.this.asyncFinish();
        }

        private List<String> getReportFileNames(Long testDataPersistenceId) {
            ArrayList<String> reportFileNames = new ArrayList<String>();
            MetaDataPersistenceController pc = MetaDataPersistenceController.getInstance();
            TestDataReference tdr = (TestDataReference)new TestDataReferenceManager(pc).getEntity(testDataPersistenceId);
            List reportGenerations = tdr.getReportGenerations();
            ReportGeneration lastReportGeneration = (ReportGeneration)reportGenerations.get(reportGenerations.size() - 1);
            for (Report report : lastReportGeneration.getReports()) {
                reportFileNames.add(report.getFileUrl());
            }
            return reportFileNames;
        }
    }

    private final class TestRunFinished
    extends JobChangeAdapter {
        private final ExecuteScenarioJob scenarioJob;
        private final String scenarioName;
        private final Path outputDir;
        private final Path projectFilePath;

        private TestRunFinished(ExecuteScenarioJob scenarioJob, String scenarioName, Path outputDir, Path projectFilePath) {
            this.scenarioJob = scenarioJob;
            this.scenarioName = scenarioName;
            this.outputDir = outputDir;
            this.projectFilePath = projectFilePath;
        }

        public void done(IJobChangeEvent event) {
            IStatus result = event.getResult();
            if (result.isOK()) {
                ByteBlowerApplication.this.printer.printInfo("Test finished");
            } else {
                ByteBlowerApplication.this.printer.printError(result.getMessage(), result.getException());
            }
            Long testReference = this.scenarioJob.getTestDataPersistenceId();
            ByteBlowerProject project = this.scenarioJob.getRunningModelProject();
            if (!result.isOK() || testReference == null) {
                ByteBlowerApplication.this.error = ByteBlowerApplication.this.searchProblem(this.projectFilePath, project, this.scenarioName);
                ByteBlowerApplication.this.testRunStatus = TestStatus.ERROR;
                ByteBlowerApplication.this.asyncFinish();
                return;
            }
            try {
                MetaDataPersistenceController ctrl = MetaDataPersistenceController.getInstance();
                TestDataReferenceManager testdata = new TestDataReferenceManager(ctrl);
                ByteBlowerApplication.this.testRunStatus = ((TestDataReference)testdata.getEntity(testReference)).getStatus();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not fetch scenario status", e);
                ByteBlowerApplication.this.error = ErrorGenerator.issue(ExitCode.EX_SOFTWARE);
                ByteBlowerApplication.this.testRunStatus = TestStatus.ERROR;
                ByteBlowerApplication.this.asyncFinish();
                return;
            }
            ReportGenerationJob reportGenerationJob = new ReportGenerationJob(testReference, project, this.outputDir, ByteBlowerApplication.this.upload);
            reportGenerationJob.addJobChangeListener((IJobChangeListener)new PrintGeneratedReports(testReference));
            reportGenerationJob.schedule();
        }
    }

    private final class TestRunListen
    implements IBatchJobListener {
        private TestRunListen() {
        }

        public void handleScenarioJobRunning(ExecuteScenarioJob scenarioJob) {
            ByteBlowerApplication.this.printer.printInfo("Running scenario " + scenarioJob.getScenarioName() + ".");
        }

        public void handleScenarioJobDone(ExecuteScenarioJob scenarioJob) {
            this.generateReport(scenarioJob);
        }

        private void generateReport(ExecuteScenarioJob scenarioJob) {
            ByteBlowerApplication.this.printer.printInfo("Scenario " + scenarioJob.getScenarioName() + " finished.");
            Long testReference = scenarioJob.getTestDataPersistenceId();
            ByteBlowerProject project = scenarioJob.getRunningModelProject();
            if (testReference == null) {
                ByteBlowerApplication.this.error = ByteBlowerApplication.this.searchProblem(ByteBlowerApplication.this.projectFilePath, project, ByteBlowerApplication.this.testName);
                ByteBlowerApplication.this.asyncFinish();
                return;
            }
            try {
                MetaDataPersistenceController ctrl = MetaDataPersistenceController.getInstance();
                TestDataReferenceManager testdata = new TestDataReferenceManager(ctrl);
                ByteBlowerApplication.this.testRunStatus = ((TestDataReference)testdata.getEntity(testReference)).getStatus();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not fetch scenario status", e);
                ByteBlowerApplication.this.error = ErrorGenerator.issue(ExitCode.EX_SOFTWARE);
                ByteBlowerApplication.this.asyncFinish();
                return;
            }
            ReportGenerationJob reportGenerationJob = new ReportGenerationJob(testReference, project, ByteBlowerApplication.this.outputDirPath, ByteBlowerApplication.this.upload);
            reportGenerationJob.addJobChangeListener((IJobChangeListener)new PrintGeneratedReports(testReference));
            reportGenerationJob.schedule();
            try {
                reportGenerationJob.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }

        public void handleBatchJobRunning(ExecuteBatchJob batchJob) {
        }

        public void handleBatchJobDone(ExecuteBatchJob batchJob) {
            ByteBlowerApplication.this.asyncFinish();
        }
    }
}

