/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.clt;

import com.excentis.products.byteblower.clt.ByteBlowerApplication;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.report.ReportGenerator;
import com.excentis.products.byteblower.report.ReportPreferences;
import com.excentis.products.byteblower.report.UploadConfig;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import java.nio.file.Path;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

final class ReportGenerationJob
extends Job {
    private final long testReference;
    private final ByteBlowerProject project;
    private final Path outputDir;
    private final UploadConfig cloudConfig;

    ReportGenerationJob(long testReference, ByteBlowerProject project, Path outputDir, UploadConfig cloudConfig) {
        super("Generating report");
        this.testReference = testReference;
        this.project = project;
        this.outputDir = outputDir;
        this.cloudConfig = cloudConfig;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Generating report", -1);
        try {
            ReportPreferences reportPreference = new ReportPreferences(this.project, this.outputDir.toString());
            if (this.cloudConfig.shouldUpload) {
                reportPreference.setCloudConfig(this.cloudConfig.apiKey, this.cloudConfig.uploadLocation);
            }
            ReportGenerator.getInstance().generateReport(Long.valueOf(this.testReference), (ReportPreferencesInterface)reportPreference, monitor);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            ByteBlowerApplication.LOGGER.log(Level.SEVERE, "Failed to generate report", e);
            Status status = new Status(4, "com.excentis.products.byteblower.clt", "Failed to generate report", (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

