/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datalibs;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

class ScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean autoCommit;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private PrintWriter errorLogWriter = new PrintWriter(System.err);
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    ScriptRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setErrorLogWriter(PrintWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
    }

    void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuilder command = null;
        try {
            try {
                LineNumberReader lineReader = new LineNumberReader(reader);
                String line = null;
                while ((line = lineReader.readLine()) != null) {
                    String trimmedLine;
                    if (command == null) {
                        command = new StringBuilder();
                    }
                    if ((trimmedLine = line.trim()).startsWith("--")) {
                        this.println(trimmedLine);
                        continue;
                    }
                    if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                    if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                        command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                        command.append(" ");
                        this.println(command);
                        Throwable throwable = null;
                        Object var8_11 = null;
                        try (Statement statement = conn.createStatement();){
                            if (this.stopOnError) {
                                statement.execute(command.toString());
                            } else {
                                try {
                                    statement.execute(command.toString());
                                }
                                catch (SQLException e) {
                                    e.fillInStackTrace();
                                    this.printlnError("Error executing: " + command);
                                    this.printlnError(e);
                                }
                            }
                            if (this.autoCommit && !conn.getAutoCommit()) {
                                conn.commit();
                            }
                            command = null;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        Thread.yield();
                        continue;
                    }
                    command.append(line);
                    command.append(" ");
                }
                if (!this.autoCommit) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                e.fillInStackTrace();
                this.printlnError("Error executing: " + command);
                this.printlnError(e);
                throw e;
            }
            catch (IOException e) {
                e.fillInStackTrace();
                this.printlnError("Error executing: " + command);
                this.printlnError(e);
                throw e;
            }
        }
        finally {
            conn.rollback();
            this.flush();
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }

    private void println(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
        }
    }

    private void printlnError(Object o) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(o);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }
}

