/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.actions;

import com.excentis.products.byteblower.run.actions.core.CancellationTriggered;
import com.excentis.products.byteblower.run.actions.core.Decorator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionLoggingDecorator
extends Decorator {
    private static final Level DEFAULT_ACTION_LOGLEVEL = Level.WARNING;
    private Logger logger;
    private Level logLevel = DEFAULT_ACTION_LOGLEVEL;

    public ExceptionLoggingDecorator() {
    }

    private ExceptionLoggingDecorator(Logger logger, Level logLevel) {
        this.logger = logger;
        this.logLevel = logLevel;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    protected Decorator getDecoratorCopy() {
        return new ExceptionLoggingDecorator(this.logger, this.logLevel);
    }

    protected void invokeImpl() {
        try {
            this.getDecoratedAction().invoke();
        }
        catch (CancellationTriggered e) {
            throw e;
        }
        catch (Exception t) {
            this.logger.log(this.logLevel, "exception thrown by action '" + this.getConcreteAction().toString() + "'; logged and rethrown: ", t);
            throw t;
        }
    }
}

