/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.hook.impl;

import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.datapersistence.actions.ActionLoggingDecorator;
import com.excentis.products.byteblower.datapersistence.actions.ExceptionLoggingDecorator;
import com.excentis.products.byteblower.datapersistence.hook.impl.AbstractEventHook;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import com.excentis.products.byteblower.run.actions.ConfigureFlow;
import com.excentis.products.byteblower.run.actions.ConfigureLayer2;
import com.excentis.products.byteblower.run.actions.ConfigureLayer25;
import com.excentis.products.byteblower.run.actions.ConfigureLayer3;
import com.excentis.products.byteblower.run.actions.ConfigurePort;
import com.excentis.products.byteblower.run.actions.CreateFlow;
import com.excentis.products.byteblower.run.actions.CreatePort;
import com.excentis.products.byteblower.run.actions.CreateServer;
import com.excentis.products.byteblower.run.actions.InitializeScenario;
import com.excentis.products.byteblower.run.actions.PerformDhcp;
import com.excentis.products.byteblower.run.actions.PerformStatelessAutoconfiguration;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeEthernetIIConfiguration;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeIPv4Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer2Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeVlanConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class RuntimeConsoleLoggingHook
extends AbstractEventHook {
    private static Logger defaultLogger = Logger.getLogger("com.excentis.products.byteblower.datagathering.runtimelogger.scenario.null");
    private Logger logger;
    private LogLevel logLevel;

    static {
        defaultLogger.setLevel(Level.INFO);
        $SWITCH_TABLE$com$excentis$products$byteblower$datapersistence$hook$impl$RuntimeConsoleLoggingHook$LogLevel = RuntimeConsoleLoggingHook.$SWITCH_TABLE$com$excentis$products$byteblower$datapersistence$hook$impl$RuntimeConsoleLoggingHook$LogLevel();
    }

    public RuntimeConsoleLoggingHook(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.logger = defaultLogger;
    }

    public RuntimeConsoleLoggingHook() {
        this(LogLevel.DEBUG);
    }

    @Override
    public void attach(BearScenarioId scenarioId, RuntimeScenarioRunner scenarioRunner) {
        this.logger = Logger.getLogger("com.excentis.products.byteblower.datagathering.runtimelogger.scenario." + scenarioId);
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(this.levelMapping(this.logLevel));
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        handler.setLevel(this.levelMapping(this.logLevel));
        this.logger.addHandler(handler);
        Context context = scenarioRunner.getContext();
        ActionLoggingDecorator actionLogger = (ActionLoggingDecorator)context.addGlobalDecorator(ActionLoggingDecorator.class);
        actionLogger.setLogger(this.logger);
        ExceptionLoggingDecorator exceptionLogger = (ExceptionLoggingDecorator)context.addTypeDecorator(InitializeScenario.class, ExceptionLoggingDecorator.class);
        exceptionLogger.setLogger(this.logger);
        context.listen(InitializeScenario.Listener.class, (Object)new InitializeScenario.Listener(){

            public void onScenarioInitializeStarting(RuntimeScenario rtScenario) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario initialization starting!");
            }

            public void onScenarioInitializeFinished(RuntimeScenario rtScenario) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario initialized!");
                RuntimeConsoleLoggingHook.this.logger.finest("debug: full scenario description:\n" + rtScenario.getRuntimeScenarioRunner().getRuntimeByteBlower().getDescription());
            }

            public void onScenarioInitializeCancelled(RuntimeScenario rtScenario) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario initialization cancelled!");
                RuntimeConsoleLoggingHook.this.logger.finest("debug: partial scenario description:\n" + rtScenario.getRuntimeScenarioRunner().getRuntimeByteBlower().getDescription());
            }

            public void onScenarioInitializeFailed(RuntimeScenario rtScenario, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario initialization failed due to error:\n" + errorMessage);
                RuntimeConsoleLoggingHook.this.logger.finest("debug: partial scenario description:\n" + rtScenario.getRuntimeScenarioRunner().getRuntimeByteBlower().getDescription());
            }
        });
        context.listen(CreateServer.Listener.class, (Object)new CreateServer.Listener(){

            public void onServerCreated(RuntimeBBServer rtServer) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: server '" + rtServer.getName() + "' created (version " + rtServer.getVersion() + ")");
            }

            public void onServerCreationFailed(String serverUrl, CreateServer.Listener.ErrorType errorType, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: server at '" + serverUrl + "' creation failed due to error:\n" + errorType + "-" + errorMessage);
            }
        });
        context.listen(CreatePort.Listener.class, (Object)new CreatePort.Listener(){

            public void onPortCreated(RuntimePort rtPort) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: port '" + rtPort.getName() + "' created on interface '" + rtPort.getInterfaceName() + "'");
            }

            public void onPortCreationFailed(RuntimePort rtPort, String errorMessage) {
                String name = rtPort == null ? "Unkown" : rtPort.getName();
                RuntimeConsoleLoggingHook.this.logger.info("action callback: port '" + name + "' creation failed due to error:\n" + errorMessage);
            }
        });
        context.listen(ConfigureLayer2.Listener.class, (Object)new ConfigureLayer2.Listener(){

            public void onLayer2Configured(RuntimeLayer2Configuration rtL2Config) {
                String layer2ConfigString = rtL2Config instanceof RuntimeEthernetIIConfiguration ? "ethiimac=" + ((RuntimeEthernetIIConfiguration)rtL2Config).getMacAddressString() : "<" + rtL2Config.getClass().getSimpleName() + ">";
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: layer2 configured on port '" + rtL2Config.getRuntimePort().getName() + "' (config " + layer2ConfigString + ")");
            }
        });
        context.listen(ConfigureLayer25.Listener.class, (Object)new ConfigureLayer25.Listener(){

            public void onLayer25Configured(List<RuntimeLayer25Configuration> rtL25ConfigList) {
                ArrayList<String> descriptionStrings = new ArrayList<String>();
                for (RuntimeLayer25Configuration rtL25Config : rtL25ConfigList) {
                    String desc = rtL25Config instanceof RuntimeVlanConfiguration ? String.format("vlandid=%d", ((RuntimeVlanConfiguration)rtL25Config).getVlanId()) : String.format("<%s>", rtL25Config.getClass().getSimpleName());
                    descriptionStrings.add(desc);
                }
                if (rtL25ConfigList.size() > 0) {
                    String layer25ConfigString = String.join((CharSequence)",", descriptionStrings);
                    RuntimeConsoleLoggingHook.this.logger.finer("action callback: layer2.5 configured on port '" + rtL25ConfigList.get(0).getRuntimePort().getName() + "' (config " + layer25ConfigString + ")");
                }
            }
        });
        context.listen(PerformDhcp.Listener.class, (Object)new PerformDhcp.Listener(){

            public void onDHCPPerformed(RuntimeLayer3Configuration rtL3Config) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: dhcp on port '" + rtL3Config.getRuntimePort().getName() + "' resulted in IP address " + rtL3Config.getIPAddress());
            }

            public void onDHCPPerformFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: dhcp on port '" + rtL3Config.getRuntimePort().getName() + "' failed due to error:\n" + errorMessage);
            }
        });
        context.listen(PerformStatelessAutoconfiguration.Listener.class, (Object)new PerformStatelessAutoconfiguration.Listener(){

            public void onStatelessAutoconfigurationPerformed(RuntimeLayer3Configuration rtL3Config) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: slaac on port '" + rtL3Config.getRuntimePort().getName() + "' resulted in IP address " + rtL3Config.getIPAddress());
            }

            public void onStatelessAutoconfigurationFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: slaac on port '" + rtL3Config.getRuntimePort().getName() + "' failed due to error:\n" + errorMessage);
            }
        });
        context.listen(ConfigureLayer3.Listener.class, (Object)new ConfigureLayer3.Listener(){

            public void onLayer3Configuring(RuntimePort rtPort) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: layer3 configurating on port '" + rtPort.getName() + "'");
            }

            public void onLayer3Configured(RuntimeLayer3Configuration rtL3Config) {
                String layer3ConfigString;
                if (rtL3Config instanceof RuntimeIPv4Configuration) {
                    layer3ConfigString = "ip=" + rtL3Config.getIPAddress();
                } else if (rtL3Config instanceof RuntimeIPv6Configuration) {
                    RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
                    layer3ConfigString = "linklocalip=" + rtIpv6Config.getLinkLocalAddress() + ",publicip=" + rtIpv6Config.getIPAddress();
                } else {
                    layer3ConfigString = "<" + rtL3Config.getClass().getSimpleName() + ">";
                }
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: layer3 configured on port '" + rtL3Config.getRuntimePort().getName() + "' (config " + layer3ConfigString + ")");
            }
        });
        context.listen(ConfigurePort.Listener.class, (Object)new ConfigurePort.Listener(){

            public void onPortConfiguring(RuntimePort rtPort) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: port '" + rtPort.getName() + "' configuration starting");
            }

            public void onPortConfigured(RuntimePort rtPort) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: port '" + rtPort.getName() + "' configured");
            }

            public void onPortConfigurationFailed(RuntimePort rtPort, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.info("failed to configure port '" + rtPort.getName() + "' due to error:\n" + errorMessage);
            }
        });
        context.listen(CreateFlow.Listener.class, (Object)new CreateFlow.Listener(){

            public void onFlowCreated(RuntimeFlow rtFlow) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: flow '" + rtFlow.name() + "' created");
            }

            public void onFlowCreationFailed(FlowMeasurement mFlowInstance, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: flow '" + mFlowInstance.getFlow().getName() + "' creation failed due to error:\n" + errorMessage);
            }
        });
        context.listen(ConfigureFlow.Listener.class, (Object)new ConfigureFlow.Listener(){

            public void onFlowConfigured(RuntimeFlow rtFlow) {
                RuntimeConsoleLoggingHook.this.logger.finer("action callback: flow '" + rtFlow.name() + "' configured");
            }

            public void onFlowConfigurationFailed(RuntimeFlow rtFlow, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.info("failed to configure flow '" + rtFlow.name() + "' due to error:\n" + errorMessage);
            }
        });
        context.listen(RunScenario.Listener.class, (Object)new RunScenario.Listener(){

            public void onScenarioRunStarting(RuntimeScenario rtScenario) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario run starting!");
            }

            public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario run update!");
            }

            public void onScenarioRunFinished(RuntimeScenario rtScenario) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario run finished!");
            }

            public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario run cancelled!");
            }

            public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
                RuntimeConsoleLoggingHook.this.logger.info("action callback: scenario run failed due to error:\n" + errorMessage);
            }
        });
    }

    @Override
    public void detach() {
    }

    private Level levelMapping(LogLevel logLevel) {
        switch (logLevel) {
            case DEBUG: {
                return Level.ALL;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARNING;
            }
        }
        return null;
    }

    public static enum LogLevel {
        WARNING,
        INFO,
        DEBUG;

    }
}

