/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.WiFiSample;
import com.excentis.products.byteblower.run.actions.CreatePorts;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalNetworkInfoResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class GatherWifiStats
extends BaseHandle
implements RunScenario.Listener,
CreatePorts.Listener {
    private static Logger LOGGER = Logger.getGlobal();
    private final TestDataPersistenceController pc;

    private static Optional<Port> getPort(String name, TestDataPersistenceController pc) {
        for (Port aPort : new PortManager(pc).getEntities()) {
            if (!name.equals(aPort.getName())) continue;
            return Optional.of(aPort);
        }
        return Optional.empty();
    }

    public GatherWifiStats(TestDataPersistenceController pc) {
        super(pc);
        this.pc = pc;
    }

    @Override
    public void register(Context context) {
        context.listen(RunScenario.Listener.class, (Object)this);
        context.listen(CreatePorts.Listener.class, (Object)this);
    }

    private void collectStats(RuntimeScenario rtScenario) {
        for (RuntimePort port : rtScenario.getRuntimePorts()) {
            WiFiVisitor fetch = new WiFiVisitor(port, this.pc);
            port.visit((RuntimePort.PortVisit)fetch);
        }
    }

    public void onPortsCreated(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        this.collectStats(rtScenario);
    }

    private static final class WiFiVisitor
    implements RuntimePort.PortVisit {
        private final RuntimePort port;
        private final TestDataPersistenceController pc;

        private WiFiVisitor(RuntimePort port, TestDataPersistenceController pc) {
            this.port = port;
            this.pc = pc;
        }

        private String humanInterfaceName(LocalNetworkInfoResult.LocalNetworkInterface netIf) {
            int max_length = 128;
            String ifName = netIf.name;
            return ifName.substring(0, Math.min(ifName.length(), 128));
        }

        public void visitWifi(List<LocalNetworkInfoResult> results) {
            ArrayList<WiFiSample> samples = new ArrayList<WiFiSample>();
            Optional<Port> databasePort = GatherWifiStats.getPort(this.port.getName(), this.pc);
            boolean hasRealtimeWiFiResults = false;
            for (LocalNetworkInfoResult result : results) {
                long timestamp = result.TimestampGet();
                databasePort.ifPresent(port -> {
                    port.lastSeen = Math.max(timestamp, port.lastSeen);
                });
                if (result.InterfaceGet().size() == 0) {
                    LOGGER.warning(String.format("- Snapshot %d does not have any interfaces!", (int)((double)result.TimestampGet() / 1.0E9)));
                }
                for (LocalNetworkInfoResult.LocalNetworkInterface netIf : result.InterfaceGet()) {
                    if (netIf.type != LocalNetworkInfoResult.NetIfType.WiFi) continue;
                    if (!result.untimedResults()) {
                        String ifName = this.humanInterfaceName(netIf);
                        WiFiSample aSample = new WiFiSample(timestamp, netIf.rssi, netIf.bssid, netIf.ssid, this.port.getName(), ifName);
                        samples.add(aSample);
                    }
                    databasePort.ifPresent(port -> {
                        if (!localNetworkInterface.ssid.isEmpty()) {
                            port.rssi = localNetworkInterface.rssi;
                            port.ssid = localNetworkInterface.ssid;
                            port.bssid = localNetworkInterface.bssid;
                        }
                    });
                    boolean bl = hasRealtimeWiFiResults = hasRealtimeWiFiResults || !netIf.ssid.isEmpty();
                }
            }
            if (!hasRealtimeWiFiResults) {
                databasePort.ifPresent(Port::resetWiFi);
            }
            WiFiSample.addSamples((TestDataPersistenceController)this.pc, samples);
        }
    }
}

