/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.communication.api.DomainError;
import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.communication.api.HTTPRequestStatus;
import com.excentis.products.byteblower.communication.api.HTTPResultData;
import com.excentis.products.byteblower.communication.api.HTTPResultDataList;
import com.excentis.products.byteblower.communication.api.HTTPResultHistory;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.communication.api.TCPConnectionState;
import com.excentis.products.byteblower.communication.api.TCPResultData;
import com.excentis.products.byteblower.communication.api.TCPResultDataList;
import com.excentis.products.byteblower.communication.api.TCPResultHistory;
import com.excentis.products.byteblower.communication.api.TCPSessionInfo;
import com.excentis.products.byteblower.communication.api.TechnicalError;
import com.excentis.products.byteblower.communication.api.UnsupportedFeature;
import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.datapersistence.util.DirtySet;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.HTTPMethod;
import com.excentis.products.byteblower.model.TCPCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.CumulativeSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.FlowManager;
import com.excentis.products.byteblower.results.testdata.data.HttpApplicationManager;
import com.excentis.products.byteblower.results.testdata.data.HttpFlowTemplateManager;
import com.excentis.products.byteblower.results.testdata.data.IntervalHttpSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.IntervalSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TCPSnapshotChild;
import com.excentis.products.byteblower.results.testdata.data.TCPSnapshotChilderen;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Flow;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpApplication;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.ServerEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotFinReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotFinSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotTxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.FlowInstanceStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpApplicationType;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethod;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethodConfig;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.TcpCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.results.testdata.data.enums.TcpState;
import com.excentis.products.byteblower.run.actions.ConfigureFlow;
import com.excentis.products.byteblower.run.actions.CreateFlow;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeGroupHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.Addable;
import com.excentis.products.byteblower.run.utils.LocalHttpResultData;
import com.excentis.products.byteblower.run.utils.LocalTcpResultData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class HttpFlowHandle
extends BaseHandle
implements CreateFlow.Listener,
ConfigureFlow.Listener,
RunScenario.Listener {
    private static Logger LOGGER = Logger.getGlobal();
    private EventManager eventManager;
    private boolean shouldStoreInterval = false;
    private final ScenarioManager scenarioManager;
    private final PortManager portManager;
    private final FlowManager flowManager;
    private final HttpFlowTemplateManager httpFlowTemplateManager;
    private final FlowInstanceManager flowInstanceManager;
    private final HttpApplicationManager httpApplicationManager;
    private final BaseEntityManager<HttpSession> httpSessionManager;
    private final BaseEntityManager<TcpSession> tcpSessionManager;
    private DirtySet<RuntimeHttpFlow> dirtyHttpFlows = new DirtySet(3);
    private final IntervalHttpSnapshotManager intervalHttpSnapshotManager;
    private final CumulativeSnapshotManager cumulativeSnapshotManager;
    private final IntervalSnapshotManager intervalSnapshotManager;
    private final Map<RuntimeFlow, HttpFlowInstance> httpFlowInstanceCache = new HashMap<RuntimeFlow, HttpFlowInstance>();
    private Set<String> hasWarnedNoAverageRTT = new HashSet<String>();

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$model$HTTPMethod = HttpFlowHandle.$SWITCH_TABLE$com$excentis$products$byteblower$model$HTTPMethod();
        $SWITCH_TABLE$com$excentis$products$byteblower$run$objects$RuntimeHttpFlow$RuntimeHttpMethod = HttpFlowHandle.$SWITCH_TABLE$com$excentis$products$byteblower$run$objects$RuntimeHttpFlow$RuntimeHttpMethod();
        $SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$enums$HttpRequestStatus = HttpFlowHandle.$SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$enums$HttpRequestStatus();
        $SWITCH_TABLE$com$excentis$products$byteblower$model$TCPCongestionAvoidanceAlgorithm = HttpFlowHandle.$SWITCH_TABLE$com$excentis$products$byteblower$model$TCPCongestionAvoidanceAlgorithm();
    }

    public HttpFlowHandle(TestDataPersistenceController pc) {
        super(pc);
        this.eventManager = new EventManager(pc);
        this.scenarioManager = new ScenarioManager(pc);
        this.portManager = new PortManager(pc);
        this.flowManager = new FlowManager(pc);
        this.httpFlowTemplateManager = new HttpFlowTemplateManager(pc);
        this.flowInstanceManager = new FlowInstanceManager(pc);
        this.httpApplicationManager = new HttpApplicationManager(pc);
        this.httpSessionManager = new BaseEntityManager(HttpSession.class, pc);
        this.intervalHttpSnapshotManager = new IntervalHttpSnapshotManager(pc);
        this.tcpSessionManager = new BaseEntityManager(TcpSession.class, pc);
        this.cumulativeSnapshotManager = new CumulativeSnapshotManager(pc);
        this.intervalSnapshotManager = new IntervalSnapshotManager(pc);
    }

    @Override
    public void register(Context context) {
        context.listen(CreateFlow.Listener.class, (Object)this);
        context.listen(ConfigureFlow.Listener.class, (Object)this);
        context.listen(RunScenario.Listener.class, (Object)this);
    }

    public void onFlowCreated(RuntimeFlow rtFlow) {
        if (!(rtFlow instanceof RuntimeHttpFlow) && !(rtFlow instanceof RuntimeGroupHttpFlow)) {
            return;
        }
        HttpFlowInstance httpFlowInstance = this.generatePersistedHttpFlowInstance(rtFlow.getModelFlowInstanceReader());
        this.httpFlowInstanceCache.put(rtFlow, httpFlowInstance);
    }

    public void onFlowCreationFailed(FlowMeasurement mFlowInstance, String errorMessage) {
        Date time = new Date();
        if (!(mFlowInstance.getFlow().getFlowTemplate() instanceof TcpFlow)) {
            return;
        }
        HttpFlowInstance httpFlowInstance = this.generatePersistedHttpFlowInstance(ReaderFactory.create((FlowMeasurement)mFlowInstance));
        httpFlowInstance.setStatus(FlowInstanceStatus.CONFIGURATION_ERROR);
        this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
        String flowName = mFlowInstance.getFlow().getName();
        String message = "Failed to create flow instance '" + flowName + "' due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        FlowInstanceEvent event = new FlowInstanceEvent(time, message, severity, (FlowInstance)httpFlowInstance);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private HttpFlowInstance generatePersistedHttpFlowInstance(FlowMeasurementReader flowMeasurementReader) {
        String scenarioName = flowMeasurementReader.getScenario().getName();
        Scenario scenario = this.scenarioManager.find(scenarioName);
        Flow flow = this.flowManager.findOrCreate(flowMeasurementReader.getFlow().getName());
        HttpFlowTemplate flowTemplate = this.httpFlowTemplateManager.find(flowMeasurementReader.getFlowReader().getFlowTemplateName());
        if (flowTemplate == null) {
            FlowTemplate mFlowTemplate = flowMeasurementReader.getFlow().getFlowTemplate();
            if (!(mFlowTemplate instanceof TcpFlow)) {
                throw new IllegalStateException("Unexpected RuntimeHttpFlow flow template type " + mFlowTemplate.getClass().getSimpleName());
            }
            TcpFlowReader mHttpFlowTemplateReader = ReaderFactory.create((TcpFlow)((TcpFlow)mFlowTemplate));
            flowTemplate = this.generatePersistedFlowTemplate(mHttpFlowTemplateReader);
        }
        Integer positionInScenario = flowMeasurementReader.getPositionInScenario();
        Long startTime = flowMeasurementReader.getStartTimeInNanoseconds();
        Long duration = flowMeasurementReader.getFlowReader().getTcpFlowReader().isTimeBased() ? flowMeasurementReader.getDurationInNanoseconds() : null;
        String tos = flowMeasurementReader.getTos();
        HttpFlowInstance httpFlowInstance = new HttpFlowInstance(scenario, flow, positionInScenario, startTime, duration, tos, flowTemplate);
        this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
        return httpFlowInstance;
    }

    private HttpFlowTemplate generatePersistedFlowTemplate(TcpFlowReader mHttpFlowTemplateReader) {
        TcpFlow mHttpFlowTemplate = (TcpFlow)mHttpFlowTemplateReader.getObject();
        String name = mHttpFlowTemplateReader.getName();
        HttpRequestMethodConfig requestMethod = this.convertHttpRequestMethodConfig(mHttpFlowTemplate.getHTTPMethod());
        Long httpDataSize = mHttpFlowTemplateReader.isTimeBased() ? null : Long.valueOf((long)mHttpFlowTemplateReader.getPayloadSizeInBytes());
        Long rateLimitation = mHttpFlowTemplateReader.isRateLimited() ? Long.valueOf(mHttpFlowTemplateReader.getRateLimitInBitsps()) : null;
        Integer clientPort = mHttpFlowTemplateReader.hasAutomaticClientPort() ? null : mHttpFlowTemplateReader.getClientPortNumber();
        Integer serverPort = mHttpFlowTemplateReader.hasAutomaticServerPort() ? null : mHttpFlowTemplateReader.getServerPortNumber();
        TcpCongestionAvoidanceAlgorithm congestionAvoidanceAlgorithm = this.convertModelTcpCAAConfig(mHttpFlowTemplateReader.getTCPCongestionAvoidanceAlgorithm());
        Integer rxWindowInitialUnscaledSize = mHttpFlowTemplateReader.getInitialReceiveWindowSizeNumber();
        Integer rxWindowScaleValue = mHttpFlowTemplate.isWindowScaling() ? new Integer(mHttpFlowTemplateReader.getReceiveWindowScalingValueNumber()) : null;
        boolean isL4sEnabled = mHttpFlowTemplate.isL4s();
        HttpFlowTemplate httpFlowTemplate = new HttpFlowTemplate(name, requestMethod, httpDataSize, rateLimitation, clientPort, serverPort, congestionAvoidanceAlgorithm, rxWindowInitialUnscaledSize, rxWindowScaleValue, isL4sEnabled);
        this.httpFlowTemplateManager.persistIdEntity((BaseEntity)httpFlowTemplate);
        return httpFlowTemplate;
    }

    public void onFlowConfigured(RuntimeFlow rtFlow) {
        if (!(rtFlow instanceof RuntimeHttpFlow) && !(rtFlow instanceof RuntimeGroupHttpFlow)) {
            return;
        }
        Date time = new Date();
        HttpFlowInstance httpFlowInstance = rtFlow instanceof RuntimeHttpFlow ? this.handleRuntimeHttpFlow((RuntimeHttpFlow)rtFlow) : this.handleRuntimeHttpFlow((RuntimeGroupHttpFlow)rtFlow);
        httpFlowInstance.setStatus(FlowInstanceStatus.CONFIGURED);
        this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
        String message = "HTTP flow '" + rtFlow.name() + "' configured";
        EventSeverity severity = EventSeverity.TEST_LOG;
        FlowInstanceEvent event = new FlowInstanceEvent(time, message, severity, (FlowInstance)httpFlowInstance);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onFlowConfigurationFailed(RuntimeFlow rtFlow, String errorMessage) {
        if (!(rtFlow instanceof RuntimeHttpFlow)) {
            return;
        }
        Date time = new Date();
        RuntimeHttpFlow rtHttpFlow = (RuntimeHttpFlow)rtFlow;
        HttpFlowInstance httpFlowInstance = this.handleRuntimeHttpFlow(rtHttpFlow);
        httpFlowInstance.setStatus(FlowInstanceStatus.CONFIGURATION_ERROR);
        this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
        String message = "Failed to configure HTTP flow '" + rtHttpFlow.name() + "' due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        FlowInstanceEvent event = new FlowInstanceEvent(time, message, severity, (FlowInstance)httpFlowInstance);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private HttpFlowInstance handleRuntimeHttpFlow(RuntimeGroupHttpFlow rtGroupHttpFlow) {
        HttpFlowInstance httpFlowInstance = this.getCachedHttpFlowInstance((RuntimeFlow)rtGroupHttpFlow);
        Scenario scenario = httpFlowInstance.getScenario();
        for (RuntimeHttpFlow child : rtGroupHttpFlow.getChilderen()) {
            HttpFlowInstance childInstance = this.getCachedHttpFlowInstance((RuntimeFlow)child);
            childInstance.setParent((FlowInstance)childInstance);
            this.flowInstanceManager.persistIdEntity((BaseEntity)childInstance);
        }
        RuntimeHttpClient rtHttpClient = rtGroupHttpFlow.getRuntimeHttpClient();
        HttpSession clientHttpSession = null;
        if (rtHttpClient != null) {
            String clientPortName = rtHttpClient.portName();
            Integer protocolPortNumber = rtHttpClient.getApiLocalPortNumber();
            Port clientPort = this.portManager.find(clientPortName);
            HttpApplication clientApplication = this.httpApplicationManager.find(scenario, clientPort, protocolPortNumber);
            if (clientApplication == null) {
                clientApplication = new HttpApplication(scenario, clientPort, HttpApplicationType.CLIENT, protocolPortNumber);
                this.httpApplicationManager.persistIdEntity((BaseEntity)clientApplication);
            }
            TcpSession clientTcpSession = new TcpSession();
            this.tcpSessionManager.persistIdEntity((BaseEntity)clientTcpSession);
            clientHttpSession = new HttpSession(clientApplication, clientTcpSession);
            this.httpSessionManager.persistIdEntity((BaseEntity)clientHttpSession);
            httpFlowInstance.setClientHttpSession(clientHttpSession);
            httpFlowInstance.setRequestMethod(this.convertHttpRequestMethod(rtHttpClient.getRequestedMethod()));
        }
        RuntimeHttpServer rtHttpServer = rtGroupHttpFlow.getRuntimeHttpServer();
        HttpSession serverHttpSession = null;
        if (rtHttpServer != null) {
            String serverPortName = rtHttpServer.portName();
            Integer protocolPortNumber = rtHttpServer.getApiPortNumber();
            Port serverPort = this.portManager.find(serverPortName);
            HttpApplication serverApplication = this.httpApplicationManager.find(scenario, serverPort, protocolPortNumber);
            if (serverApplication == null) {
                serverApplication = new HttpApplication(scenario, serverPort, HttpApplicationType.SERVER, protocolPortNumber);
                this.httpApplicationManager.persistIdEntity((BaseEntity)serverApplication);
            }
            TcpSession serverTcpSession = new TcpSession();
            this.tcpSessionManager.persistIdEntity((BaseEntity)serverTcpSession);
            serverHttpSession = new HttpSession(serverApplication, serverTcpSession);
            this.httpSessionManager.persistIdEntity((BaseEntity)serverHttpSession);
            httpFlowInstance.setServerHttpSession(serverHttpSession);
        }
        if (httpFlowInstance.getRequestMethod() == null) {
            httpFlowInstance.setRequestMethod(this.convertHttpRequestMethod(rtGroupHttpFlow.getRuntimeHttpMethod()));
        }
        return httpFlowInstance;
    }

    private HttpFlowInstance handleRuntimeHttpFlow(RuntimeHttpFlow rtHttpFlow) {
        HttpFlowInstance httpFlowInstance = this.getCachedHttpFlowInstance((RuntimeFlow)rtHttpFlow);
        Scenario scenario = httpFlowInstance.getScenario();
        RuntimeHttpClient rtHttpClient = rtHttpFlow.getRuntimeHttpClient();
        HttpSession clientHttpSession = null;
        if (rtHttpClient != null) {
            String clientPortName = rtHttpClient.portName();
            Integer protocolPortNumber = rtHttpClient.getApiLocalPortNumber();
            Port clientPort = this.portManager.find(clientPortName);
            HttpApplication clientApplication = this.httpApplicationManager.find(scenario, clientPort, protocolPortNumber);
            if (clientApplication == null) {
                clientApplication = new HttpApplication(scenario, clientPort, HttpApplicationType.CLIENT, protocolPortNumber);
                this.httpApplicationManager.persistIdEntity((BaseEntity)clientApplication);
            }
            TcpSession clientTcpSession = new TcpSession();
            this.tcpSessionManager.persistIdEntity((BaseEntity)clientTcpSession);
            clientHttpSession = new HttpSession(clientApplication, clientTcpSession);
            this.httpSessionManager.persistIdEntity((BaseEntity)clientHttpSession);
            httpFlowInstance.setClientHttpSession(clientHttpSession);
            httpFlowInstance.setRequestMethod(this.convertHttpRequestMethod(rtHttpClient.getRequestedMethod()));
        }
        RuntimeHttpServer rtHttpServer = rtHttpFlow.getRuntimeHttpServer();
        HttpSession serverHttpSession = null;
        if (rtHttpServer != null) {
            String serverPortName = rtHttpServer.portName();
            Integer protocolPortNumber = rtHttpServer.getApiPortNumber();
            Port serverPort = this.portManager.find(serverPortName);
            HttpApplication serverApplication = this.httpApplicationManager.find(scenario, serverPort, protocolPortNumber);
            if (serverApplication == null) {
                serverApplication = new HttpApplication(scenario, serverPort, HttpApplicationType.SERVER, protocolPortNumber);
                this.httpApplicationManager.persistIdEntity((BaseEntity)serverApplication);
            }
            TcpSession serverTcpSession = new TcpSession();
            this.tcpSessionManager.persistIdEntity((BaseEntity)serverTcpSession);
            serverHttpSession = new HttpSession(serverApplication, serverTcpSession);
            this.httpSessionManager.persistIdEntity((BaseEntity)serverHttpSession);
            httpFlowInstance.setServerHttpSession(serverHttpSession);
        }
        if (httpFlowInstance.getRequestMethod() == null) {
            httpFlowInstance.setRequestMethod(this.convertHttpRequestMethod(rtHttpFlow.getRuntimeHttpMethod()));
        }
        return httpFlowInstance;
    }

    private HttpRequestMethodConfig convertHttpRequestMethodConfig(HTTPMethod mHttpMethodConfig) {
        switch (mHttpMethodConfig) {
            case AUTOMATIC: {
                return HttpRequestMethodConfig.AUTO;
            }
            case GET: {
                return HttpRequestMethodConfig.GET;
            }
            case PUT: {
                return HttpRequestMethodConfig.PUT;
            }
        }
        return null;
    }

    private HttpRequestMethod convertHttpRequestMethod(HTTPRequestMethod apiHttpMethod) {
        if (apiHttpMethod == HTTPRequestMethod.Get) {
            return HttpRequestMethod.GET;
        }
        if (apiHttpMethod == HTTPRequestMethod.Put) {
            return HttpRequestMethod.PUT;
        }
        throw new IllegalStateException("Unexpected HTTP Request Method " + apiHttpMethod.toString());
    }

    private HttpRequestMethod convertHttpRequestMethod(RuntimeHttpFlow.RuntimeHttpMethod rtHttpMethod) {
        switch (rtHttpMethod) {
            case GET: {
                return HttpRequestMethod.GET;
            }
            case PUT: {
                return HttpRequestMethod.PUT;
            }
        }
        throw new IllegalStateException("Unexpected HTTP Request Method " + rtHttpMethod.toString());
    }

    private void logFlowEvent(HttpFlowInstance httpFlowInstance, String message, EventSeverity severity) {
        Date time = new Date();
        FlowInstanceEvent event = new FlowInstanceEvent(time, message, severity, (FlowInstance)httpFlowInstance);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
        HttpFlowInstance httpFlowInstance;
        for (RuntimeFlow rtHttpFlow : rtScenario.getRuntimeFlows()) {
            String msg;
            String msgFormat;
            if (!(rtHttpFlow instanceof RuntimeGroupHttpFlow)) continue;
            httpFlowInstance = this.getCachedHttpFlowInstance(rtHttpFlow);
            FlowInstanceStatus status = FlowInstanceStatus.ACTIVE;
            int badCount = 0;
            int goodCount = 0;
            RuntimeGroupHttpFlow group = (RuntimeGroupHttpFlow)rtHttpFlow;
            for (RuntimeHttpFlow child : group.getChilderen()) {
                HttpFlowInstance childInstance = this.getCachedHttpFlowInstance((RuntimeFlow)child);
                FlowInstanceStatus childStatus = childInstance.getStatus();
                if (childStatus == FlowInstanceStatus.STOPPED_ERROR || childStatus == FlowInstanceStatus.CONFIGURATION_ERROR) {
                    ++badCount;
                    continue;
                }
                ++goodCount;
            }
            if (badCount > 0 && goodCount > 0) {
                status = FlowInstanceStatus.ACTIVE_WARNING;
                msgFormat = "Not all subflows were properly intialized (%d out of %d).\n Only partial results are available.";
                msg = String.format(msgFormat, badCount, badCount + goodCount);
                this.logFlowEvent(httpFlowInstance, msg, EventSeverity.TEST_WARNING);
            } else if (goodCount == 0) {
                status = FlowInstanceStatus.STOPPED_ERROR;
                msgFormat = "No flow was initialized. No results are available on this flow.";
                msg = String.format(msgFormat, badCount, badCount + goodCount);
                this.logFlowEvent(httpFlowInstance, msg, EventSeverity.TEST_ERROR);
            }
            httpFlowInstance.setStatus(status);
            this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
        }
        for (RuntimeFlow rtHttpFlow : rtScenario.getRuntimeFlowsConfiguredHttp()) {
            httpFlowInstance = this.getCachedHttpFlowInstance(rtHttpFlow);
            if (httpFlowInstance.getStatus() == FlowInstanceStatus.CONFIGURED) {
                httpFlowInstance.setStatus(FlowInstanceStatus.ACTIVE);
            } else if (httpFlowInstance.getStatus() == FlowInstanceStatus.CONFIGURED_WARNING) {
                httpFlowInstance.setStatus(FlowInstanceStatus.ACTIVE_WARNING);
            } else {
                throw new IllegalStateException("Unexpected flow status");
            }
            this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
        }
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        this.shouldStoreInterval = rtScenario.allowResultsOverTime();
        this.handleResultsOverTime(rtScenario);
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        boolean isScenarioFinished = true;
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario, isScenarioFinished);
        for (RuntimeHttpFlow rtHttpFlow : rtScenario.getRuntimeFlowsConfiguredHttp()) {
            HttpFlowInstance httpFlowInstance = this.getCachedHttpFlowInstance((RuntimeFlow)rtHttpFlow);
            if (httpFlowInstance.getStatus() == FlowInstanceStatus.ACTIVE) {
                httpFlowInstance.setStatus(FlowInstanceStatus.STOPPED);
            } else if (httpFlowInstance.getStatus() == FlowInstanceStatus.ACTIVE_WARNING) {
                httpFlowInstance.setStatus(FlowInstanceStatus.STOPPED_WARNING);
            } else if (httpFlowInstance.getStatus() != FlowInstanceStatus.STOPPED_ERROR) {
                throw new IllegalStateException("Unexpected flow status");
            }
            this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
        }
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        boolean isScenarioFinished = false;
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario, isScenarioFinished);
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        boolean isScenarioFinished = false;
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario, isScenarioFinished);
    }

    private void handleResultsOverTime(RuntimeScenario rtScenario) {
        for (RuntimeHttpFlow rtHttpFlow : rtScenario.getRuntimeFlowsConfiguredHttp()) {
            this.handleResultsOverTime(rtHttpFlow);
        }
        for (RuntimeFlow rtFlow : rtScenario.getRuntimeFlowsConfigured()) {
            if (!(rtFlow instanceof RuntimeGroupHttpFlow)) continue;
            this.handleResultsOverTime((RuntimeGroupHttpFlow)rtFlow);
        }
    }

    private void handleResultsOverTime(RuntimeGroupHttpFlow groupedFlow) {
        TcpSessionSnapshot newSnapshot;
        HttpSessionSnapshot newSnapshot2;
        TcpCongestionAvoidanceAlgorithm congestionAlgo = TcpCongestionAvoidanceAlgorithm.SACK;
        int maxSegmentSize = 1500;
        Collection children = groupedFlow.children();
        boolean hasUpdate = false;
        LocalHttpResultData httpClientCumulData = new LocalHttpResultData();
        LocalHttpResultData httpServerCumulData = new LocalHttpResultData();
        LocalTcpResultData tcpClientCumulData = new LocalTcpResultData();
        LocalTcpResultData tcpServerCumulData = new LocalTcpResultData();
        int childCount = children.size();
        ItemMerge<LocalHttpResultData> httpClientIntervalTimed = new ItemMerge<LocalHttpResultData>(childCount, 3000000000L);
        ItemMerge<LocalHttpResultData> httpServerIntervalTimed = new ItemMerge<LocalHttpResultData>(childCount, 3000000000L);
        ItemMerge<LocalTcpResultData> tcpClientIntervalTimed = new ItemMerge<LocalTcpResultData>(childCount, 3000000000L);
        ItemMerge<LocalTcpResultData> tcpServerIntervalTimed = new ItemMerge<LocalTcpResultData>(childCount, 3000000000L);
        for (RuntimeHttpFlow flow : groupedFlow.children()) {
            LocalHttpResultData current;
            RuntimeHttpClient client = flow.getRuntimeHttpClient();
            RuntimeHttpServer server = flow.getRuntimeHttpServer();
            if (client != null && client.hasSession()) {
                httpClientCumulData = httpClientCumulData.add(client.getCumulativeHTTPResultData());
                HTTPSessionInfo clientSession = client.getHTTPSessionInfo();
                HTTPResultDataList ggInterval = clientSession.ResultHistoryGet().IntervalGet();
                int ctr = 0;
                while (ctr < ggInterval.size() - 1) {
                    LocalHttpResultData current2 = new LocalHttpResultData(ggInterval.get(ctr));
                    httpClientIntervalTimed.add(current2.TimestampGet(), current2, new LocalHttpResultData());
                    hasUpdate = true;
                    ++ctr;
                }
                congestionAlgo = this.convertApiTcpCAA(clientSession.TcpSessionInfoGet().CongestionAvoidanceAlgorithmGet());
                maxSegmentSize = clientSession.TcpSessionInfoGet().MaximumSegmentSizeGet();
                tcpClientCumulData = tcpClientCumulData.add(client.getCumulativeTcpResultData());
                TCPResultDataList ggTcpInterval = clientSession.TcpSessionInfoGet().ResultHistoryGet().IntervalGet();
                int ctr2 = 0;
                while (ctr2 < ggTcpInterval.size() - 1) {
                    current = new LocalTcpResultData(ggTcpInterval.get(ctr2));
                    tcpClientIntervalTimed.add(current.TimestampGet(), (LocalTcpResultData)current, new LocalTcpResultData());
                    hasUpdate = true;
                    ++ctr2;
                }
            }
            if (server == null || client == null || !server.getApiHttpServer().HasSession(client.getServerClientId())) continue;
            HTTPSessionInfo serverSession = server.getApiHttpServer().HttpSessionInfoGet(client.getServerClientId());
            HTTPResultDataList gg = serverSession.ResultHistoryGet().CumulativeGet();
            if (gg.size() > 1) {
                httpServerCumulData = httpServerCumulData.add(new LocalHttpResultData(gg.get(0)));
                hasUpdate = true;
            }
            HTTPResultDataList ggInterval = serverSession.ResultHistoryGet().IntervalGet();
            int ctr = 0;
            while (ctr < ggInterval.size() - 1) {
                current = new LocalHttpResultData(ggInterval.get(ctr));
                httpServerIntervalTimed.add(current.TimestampGet(), current, new LocalHttpResultData());
                hasUpdate = true;
                ++ctr;
            }
            TCPResultDataList ggTcpCumul = serverSession.TcpSessionInfoGet().ResultHistoryGet().CumulativeGet();
            TCPResultDataList ggTcpInterval = serverSession.TcpSessionInfoGet().ResultHistoryGet().IntervalGet();
            if (ggTcpCumul.size() > 1) {
                tcpServerCumulData = tcpServerCumulData.add(new LocalTcpResultData(ggTcpCumul.get(0)));
            }
            int ctr3 = 0;
            while (ctr3 < ggTcpInterval.size() - 1) {
                LocalTcpResultData current3 = new LocalTcpResultData(ggTcpInterval.get(ctr3));
                tcpServerIntervalTimed.add(current3.TimestampGet(), current3, new LocalTcpResultData());
                hasUpdate = true;
                ++ctr3;
            }
        }
        if (!hasUpdate) {
            return;
        }
        HttpFlowInstance httpFlowInstance = this.getCachedHttpFlowInstance((RuntimeFlow)groupedFlow);
        HttpSession httpSession = httpFlowInstance.getClientHttpSession();
        if (httpSession.getSnapshotResolution() == null) {
            httpSession.setSnapshotResolution(Long.valueOf(httpClientCumulData.IntervalDurationGet()));
        }
        LocalHttpResultData httpLatestAccumulated = httpClientCumulData;
        httpSession.setRxByteCountHeader(httpLatestAccumulated.RxByteCountHeaderGet());
        httpSession.setRxBytePayload(httpLatestAccumulated.RxByteCountPayloadGet());
        httpSession.setRxByteCount(Long.valueOf(httpLatestAccumulated.RxByteCountTotalGet()));
        if (httpLatestAccumulated.RxByteCountTotalGet() > 0L) {
            httpSession.setRxFirstByteTime(Long.valueOf(httpLatestAccumulated.RxTimestampFirstGet()));
            httpSession.setRxLastByteTime(Long.valueOf(httpLatestAccumulated.RxTimestampLastGet()));
        } else {
            httpSession.setRxFirstByteTime(Long.valueOf(0L));
            httpSession.setRxLastByteTime(Long.valueOf(0L));
        }
        httpSession.setTxByteCountHeader(httpLatestAccumulated.TxByteCountHeaderGet());
        httpSession.setTxByteCountPayload(httpLatestAccumulated.TxByteCountPayloadGet());
        httpSession.setTxByteCount(Long.valueOf(httpLatestAccumulated.TxByteCountTotalGet()));
        if (httpLatestAccumulated.TxByteCountTotalGet() > 0L) {
            httpSession.setTxFirstByteTime(Long.valueOf(httpLatestAccumulated.TxTimestampFirstGet()));
            httpSession.setTxLastByteTime(Long.valueOf(httpLatestAccumulated.TxTimestampLastGet()));
        } else {
            httpSession.setTxFirstByteTime(Long.valueOf(0L));
            httpSession.setTxLastByteTime(Long.valueOf(0L));
        }
        for (LocalHttpResultData interval : httpClientIntervalTimed.getVals()) {
            newSnapshot2 = new HttpSessionSnapshot(httpSession, Long.valueOf(interval.TimestampGet()), Long.valueOf(interval.IntervalDurationGet()), Long.valueOf(interval.TxByteCountTotalGet()), Long.valueOf(interval.RxByteCountTotalGet()));
            httpSession.setLatestSnapshot(newSnapshot2);
            this.intervalHttpSnapshotManager.intervalSnapshot(newSnapshot2);
        }
        TcpSession tcpSession = httpSession.getTcpSession();
        tcpSession.setState(TcpState.ESTABLISHED);
        tcpSession.setCongestionAvoidanceAlgorithm(congestionAlgo);
        tcpSession.setMaximumSegmentSize(Integer.valueOf(maxSegmentSize));
        TcpSessionSnapshot newSnapshot3 = new TcpSessionSnapshot(tcpSession, Long.valueOf(tcpClientCumulData.TimestampGet()), Long.valueOf(tcpClientCumulData.IntervalDurationGet()));
        newSnapshot3.setCongestionWindowCurrent(tcpClientCumulData.CongestionWindowCurrentGet());
        newSnapshot3.setCongestionWindowMaximum(tcpClientCumulData.CongestionWindowMaximumGet());
        newSnapshot3.setCongestionWindowMinimum(tcpClientCumulData.CongestionWindowMinimumGet());
        newSnapshot3.setReceiverWindowCurrent(tcpClientCumulData.ReceiverWindowCurrentGet());
        newSnapshot3.setReceiverWindowMaximum(tcpClientCumulData.ReceiverWindowMaximumGet());
        newSnapshot3.setReceiverWindowMinimum(tcpClientCumulData.ReceiverWindowMinimumGet());
        newSnapshot3.setRoundTripTimeCurrent(tcpClientCumulData.RoundTripTimeAverageGet());
        newSnapshot3.setRoundTripTimeMaximum(tcpClientCumulData.RoundTripTimeMaximumGet());
        newSnapshot3.setRoundTripTimeMinimum(tcpClientCumulData.RoundTripTimeMinimumGet());
        newSnapshot3.setSlowStartThresholdCurrent(tcpClientCumulData.SlowStartThresholdCurrentGet());
        newSnapshot3.setLocalECNMarkings(tcpClientCumulData.RxLocalCongestionNotificationCountGet());
        newSnapshot3.setRemoteECNMarkings(tcpClientCumulData.RxRemoteCongestionNotificationCountGet());
        Object fix = this.cumulativeSnapshotManager.cumulativeSnapshot(newSnapshot3);
        this.storeTcpSnapshot((TCPSnapshotChilderen)fix, tcpClientCumulData, newSnapshot3);
        tcpSession = httpSession.getTcpSession();
        for (Object interval : tcpClientIntervalTimed.getVals()) {
            newSnapshot = new TcpSessionSnapshot(tcpSession, Long.valueOf(interval.TimestampGet()), Long.valueOf(interval.IntervalDurationGet()));
            newSnapshot.setCongestionWindowCurrent(interval.CongestionWindowCurrentGet());
            newSnapshot.setCongestionWindowMaximum(interval.CongestionWindowMaximumGet());
            newSnapshot.setCongestionWindowMinimum(interval.CongestionWindowMinimumGet());
            newSnapshot.setReceiverWindowCurrent(interval.ReceiverWindowCurrentGet());
            newSnapshot.setReceiverWindowMaximum(interval.ReceiverWindowMaximumGet());
            newSnapshot.setReceiverWindowMinimum(interval.ReceiverWindowMinimumGet());
            newSnapshot.setRoundTripTimeCurrent(interval.RoundTripTimeAverageGet());
            newSnapshot.setRoundTripTimeMaximum(interval.RoundTripTimeMaximumGet());
            newSnapshot.setRoundTripTimeMinimum(interval.RoundTripTimeMinimumGet());
            newSnapshot.setSlowStartThresholdCurrent(interval.SlowStartThresholdCurrentGet());
            newSnapshot.setLocalECNMarkings(interval.RxLocalCongestionNotificationCountGet());
            newSnapshot.setRemoteECNMarkings(interval.RxRemoteCongestionNotificationCountGet());
            TCPSnapshotChild fix2 = this.intervalSnapshotManager.intervalSnapshot(newSnapshot);
            this.storeTcpSnapshot(fix2, (LocalTcpResultData)interval, newSnapshot);
        }
        this.httpSessionManager.lightUpdate((BaseEntity)httpSession);
        httpSession = httpFlowInstance.getServerHttpSession();
        if (httpSession.getSnapshotResolution() == null) {
            httpSession.setSnapshotResolution(Long.valueOf(httpServerCumulData.IntervalDurationGet()));
        }
        httpLatestAccumulated = httpServerCumulData;
        httpSession.setRxByteCountHeader(httpLatestAccumulated.RxByteCountHeaderGet());
        httpSession.setRxBytePayload(httpLatestAccumulated.RxByteCountPayloadGet());
        httpSession.setRxByteCount(Long.valueOf(httpLatestAccumulated.RxByteCountTotalGet()));
        if (httpLatestAccumulated.RxByteCountTotalGet() > 0L) {
            httpSession.setRxFirstByteTime(Long.valueOf(httpLatestAccumulated.RxTimestampFirstGet()));
            httpSession.setRxLastByteTime(Long.valueOf(httpLatestAccumulated.RxTimestampLastGet()));
        } else {
            httpSession.setRxFirstByteTime(Long.valueOf(0L));
            httpSession.setRxLastByteTime(Long.valueOf(0L));
        }
        httpSession.setTxByteCountHeader(httpLatestAccumulated.TxByteCountHeaderGet());
        httpSession.setTxByteCountPayload(httpLatestAccumulated.TxByteCountPayloadGet());
        httpSession.setTxByteCount(Long.valueOf(httpLatestAccumulated.TxByteCountTotalGet()));
        if (httpLatestAccumulated.TxByteCountTotalGet() > 0L) {
            httpSession.setTxFirstByteTime(Long.valueOf(httpLatestAccumulated.TxTimestampFirstGet()));
            httpSession.setTxLastByteTime(Long.valueOf(httpLatestAccumulated.TxTimestampLastGet()));
        } else {
            httpSession.setTxFirstByteTime(Long.valueOf(0L));
            httpSession.setTxLastByteTime(Long.valueOf(0L));
        }
        for (LocalHttpResultData interval : httpServerIntervalTimed.getVals()) {
            newSnapshot2 = new HttpSessionSnapshot(httpSession, Long.valueOf(interval.TimestampGet()), Long.valueOf(interval.IntervalDurationGet()), Long.valueOf(interval.TxByteCountTotalGet()), Long.valueOf(interval.RxByteCountTotalGet()));
            httpSession.setLatestSnapshot(newSnapshot2);
            this.intervalHttpSnapshotManager.intervalSnapshot(newSnapshot2);
        }
        tcpSession = httpSession.getTcpSession();
        tcpSession.setState(TcpState.ESTABLISHED);
        tcpSession.setCongestionAvoidanceAlgorithm(congestionAlgo);
        tcpSession.setMaximumSegmentSize(Integer.valueOf(maxSegmentSize));
        newSnapshot3 = new TcpSessionSnapshot(tcpSession, Long.valueOf(tcpServerCumulData.TimestampGet()), Long.valueOf(tcpServerCumulData.IntervalDurationGet()));
        newSnapshot3.setCongestionWindowCurrent(tcpServerCumulData.CongestionWindowCurrentGet());
        newSnapshot3.setCongestionWindowMaximum(tcpServerCumulData.CongestionWindowMaximumGet());
        newSnapshot3.setCongestionWindowMinimum(tcpServerCumulData.CongestionWindowMinimumGet());
        newSnapshot3.setReceiverWindowCurrent(tcpServerCumulData.ReceiverWindowCurrentGet());
        newSnapshot3.setReceiverWindowMaximum(tcpServerCumulData.ReceiverWindowMaximumGet());
        newSnapshot3.setReceiverWindowMinimum(tcpServerCumulData.ReceiverWindowMinimumGet());
        newSnapshot3.setRoundTripTimeCurrent(tcpServerCumulData.RoundTripTimeAverageGet());
        newSnapshot3.setRoundTripTimeMaximum(tcpServerCumulData.RoundTripTimeMaximumGet());
        newSnapshot3.setRoundTripTimeMinimum(tcpServerCumulData.RoundTripTimeMinimumGet());
        newSnapshot3.setSlowStartThresholdCurrent(tcpServerCumulData.SlowStartThresholdCurrentGet());
        newSnapshot3.setLocalECNMarkings(tcpServerCumulData.RxLocalCongestionNotificationCountGet());
        newSnapshot3.setRemoteECNMarkings(tcpServerCumulData.RxRemoteCongestionNotificationCountGet());
        fix = this.cumulativeSnapshotManager.cumulativeSnapshot(newSnapshot3);
        this.storeTcpSnapshot((TCPSnapshotChilderen)fix, tcpServerCumulData, newSnapshot3);
        tcpSession = httpSession.getTcpSession();
        for (Object interval : tcpServerIntervalTimed.getVals()) {
            newSnapshot = new TcpSessionSnapshot(tcpSession, Long.valueOf(interval.TimestampGet()), Long.valueOf(interval.IntervalDurationGet()));
            newSnapshot.setCongestionWindowCurrent(interval.CongestionWindowCurrentGet());
            newSnapshot.setCongestionWindowMaximum(interval.CongestionWindowMaximumGet());
            newSnapshot.setCongestionWindowMinimum(interval.CongestionWindowMinimumGet());
            newSnapshot.setReceiverWindowCurrent(interval.ReceiverWindowCurrentGet());
            newSnapshot.setReceiverWindowMaximum(interval.ReceiverWindowMaximumGet());
            newSnapshot.setReceiverWindowMinimum(interval.ReceiverWindowMinimumGet());
            newSnapshot.setRoundTripTimeCurrent(interval.RoundTripTimeAverageGet());
            newSnapshot.setRoundTripTimeMaximum(interval.RoundTripTimeMaximumGet());
            newSnapshot.setRoundTripTimeMinimum(interval.RoundTripTimeMinimumGet());
            newSnapshot.setSlowStartThresholdCurrent(interval.SlowStartThresholdCurrentGet());
            newSnapshot.setLocalECNMarkings(interval.RxLocalCongestionNotificationCountGet());
            newSnapshot.setRemoteECNMarkings(interval.RxRemoteCongestionNotificationCountGet());
            TCPSnapshotChild fix3 = this.intervalSnapshotManager.intervalSnapshot(newSnapshot);
            this.storeTcpSnapshot(fix3, (LocalTcpResultData)interval, newSnapshot);
        }
        this.httpSessionManager.lightUpdate((BaseEntity)httpSession);
        httpFlowInstance.setRequestStatus(this.convertHttpRequestStatus(groupedFlow.getRuntimeHttpClient().RequestStatusGet()));
        this.flowInstanceManager.persistIdEntity((BaseEntity)httpFlowInstance);
    }

    private void storeTcpSnapshot(TCPSnapshotChild fix, LocalTcpResultData snapshot, TcpSessionSnapshot newSnapshot) {
        long txData;
        long rxData;
        long totalRetrans = snapshot.RetransmissionCountTotalGet();
        if (totalRetrans > 0L) {
            long slowRetrans = snapshot.RetransmissionCountSlowGet();
            long fastRetrans = snapshot.RetransmissionCountFastGet();
            TcpSessionSnapshotRetransmissionCounters retransmission = new TcpSessionSnapshotRetransmissionCounters(newSnapshot, slowRetrans, fastRetrans, totalRetrans);
            fix.add(retransmission);
        }
        if ((rxData = snapshot.RxByteCountTotalGet()) > 0L) {
            long rxHeader = snapshot.RxByteCountHeaderGet();
            long rxPayload = snapshot.RxByteCountPayloadGet();
            long rxSegments = snapshot.RxSegmentCountTotalGet();
            long rxTimestamp = snapshot.RxTimestampLastGet();
            long rxSegmentsOO = snapshot.RxSegmentCountOutOfOrderGet();
            TcpSessionSnapshotRxCounters rxCounters = new TcpSessionSnapshotRxCounters(newSnapshot, rxHeader, rxPayload, rxData, rxSegments, rxTimestamp, rxSegmentsOO);
            fix.add(rxCounters);
        }
        if ((txData = snapshot.TxByteCountTotalGet()) > 0L) {
            long txHeader = snapshot.TxByteCountHeaderGet();
            long txPayload = snapshot.TxByteCountPayloadGet();
            long txSegments = snapshot.TxSegmentCountTotalGet();
            long txTimestamp = snapshot.TxTimestampLastGet();
            TcpSessionSnapshotTxCounters counters = new TcpSessionSnapshotTxCounters(newSnapshot, txHeader, txPayload, txData, txSegments, txTimestamp);
            fix.add(counters);
        }
        try {
            long numSynRecv = snapshot.NumberOfSynReceivedGet();
            if (numSynRecv > 0L) {
                long lastSynRx = snapshot.TimestampSynReceivedGet();
                TcpSessionSnapshotSynReceived synData = new TcpSessionSnapshotSynReceived(newSnapshot, numSynRecv, lastSynRx);
                fix.add(synData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of received syn messages is not supported");
        }
        try {
            long numSynSent = snapshot.NumberOfSynSentGet();
            if (numSynSent > 0L) {
                long lastSynTx = snapshot.TimestampSynSentGet();
                TcpSessionSnapshotSynSent synTxData = new TcpSessionSnapshotSynSent(newSnapshot, numSynSent, lastSynTx);
                fix.add(synTxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of transmitted syn messages is not supported");
        }
        try {
            long numFinSent = snapshot.NumberOfFinSentGet();
            if (numFinSent > 0L) {
                long lastFinTx = snapshot.TimestampFinSentGet();
                TcpSessionSnapshotFinSent finTxData = new TcpSessionSnapshotFinSent(newSnapshot, numFinSent, lastFinTx);
                fix.add(finTxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of transmitted FIN messages is not supported");
        }
        try {
            long numFinRecv = snapshot.NumberOfFinReceivedGet();
            if (numFinRecv > 0L) {
                long lastFinRx = snapshot.TimestampFinReceivedGet();
                TcpSessionSnapshotFinReceived finRxData = new TcpSessionSnapshotFinReceived(newSnapshot, numFinRecv, lastFinRx);
                fix.add(finRxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of received FIN messages is not supported");
        }
        fix.done();
    }

    private void storeTcpSnapshot(TCPSnapshotChilderen fix, LocalTcpResultData snapshot, TcpSessionSnapshot newSnapshot) {
        long txData;
        long rxData;
        long totalRetrans = snapshot.RetransmissionCountTotalGet();
        if (totalRetrans > 0L) {
            long slowRetrans = snapshot.RetransmissionCountSlowGet();
            long fastRetrans = snapshot.RetransmissionCountFastGet();
            TcpSessionSnapshotRetransmissionCounters retransmission = new TcpSessionSnapshotRetransmissionCounters(newSnapshot, slowRetrans, fastRetrans, totalRetrans);
            fix.add(retransmission);
        }
        if ((rxData = snapshot.RxByteCountTotalGet()) > 0L) {
            long rxHeader = snapshot.RxByteCountHeaderGet();
            long rxPayload = snapshot.RxByteCountPayloadGet();
            long rxSegments = snapshot.RxSegmentCountTotalGet();
            long rxTimestamp = snapshot.RxTimestampLastGet();
            long rxSegmentsOO = snapshot.RxSegmentCountOutOfOrderGet();
            TcpSessionSnapshotRxCounters rxCounters = new TcpSessionSnapshotRxCounters(newSnapshot, rxHeader, rxPayload, rxData, rxSegments, rxTimestamp, rxSegmentsOO);
            fix.add(rxCounters);
        }
        if ((txData = snapshot.TxByteCountTotalGet()) > 0L) {
            long txHeader = snapshot.TxByteCountHeaderGet();
            long txPayload = snapshot.TxByteCountPayloadGet();
            long txSegments = snapshot.TxSegmentCountTotalGet();
            long txTimestamp = snapshot.TxTimestampLastGet();
            TcpSessionSnapshotTxCounters counters = new TcpSessionSnapshotTxCounters(newSnapshot, txHeader, txPayload, txData, txSegments, txTimestamp);
            fix.add(counters);
        }
        try {
            long numSynRecv = snapshot.NumberOfSynReceivedGet();
            if (numSynRecv > 0L) {
                long lastSynRx = snapshot.TimestampSynReceivedGet();
                TcpSessionSnapshotSynReceived synData = new TcpSessionSnapshotSynReceived(newSnapshot, numSynRecv, lastSynRx);
                fix.add(synData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of received syn messages is not supported");
        }
        try {
            long numSynSent = snapshot.NumberOfSynSentGet();
            if (numSynSent > 0L) {
                long lastSynTx = snapshot.TimestampSynSentGet();
                TcpSessionSnapshotSynSent synTxData = new TcpSessionSnapshotSynSent(newSnapshot, numSynSent, lastSynTx);
                fix.add(synTxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of transmitted syn messages is not supported");
        }
        try {
            long numFinSent = snapshot.NumberOfFinSentGet();
            if (numFinSent > 0L) {
                long lastFinTx = snapshot.TimestampFinSentGet();
                TcpSessionSnapshotFinSent finTxData = new TcpSessionSnapshotFinSent(newSnapshot, numFinSent, lastFinTx);
                fix.add(finTxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of transmitted FIN messages is not supported");
        }
        try {
            long numFinRecv = snapshot.NumberOfFinReceivedGet();
            if (numFinRecv > 0L) {
                long lastFinRx = snapshot.TimestampFinReceivedGet();
                TcpSessionSnapshotFinReceived finRxData = new TcpSessionSnapshotFinReceived(newSnapshot, numFinRecv, lastFinRx);
                fix.add(finRxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of received FIN messages is not supported");
        }
        fix.done();
    }

    private void handleResultsOverTime(RuntimeHttpFlow runtimeHttpFlow) {
        HTTPSessionInfo serverSession;
        if (this.dirtyHttpFlows.isDirty(runtimeHttpFlow)) {
            return;
        }
        HttpFlowInstance httpFlowInstance = this.getCachedHttpFlowInstance((RuntimeFlow)runtimeHttpFlow);
        List restarts = runtimeHttpFlow.restarts();
        httpFlowInstance.addRestarts(restarts.size());
        for (RuntimeHttpClient.RestartEvent restartEvent : restarts) {
            String msg = restartEvent.bytes > 262144L ? String.format("%s Restarted after %.01f sec and %.01f Mbyte of traffic", restartEvent.reason, (double)restartEvent.uptime / 1.0E9, (double)restartEvent.bytes / 1000000.0) : (restartEvent.uptime > 0L || restartEvent.bytes > 0L ? String.format("%s Restarted after %f sec and %d bytes of traffic", restartEvent.reason, (double)restartEvent.uptime / 1.0E9, restartEvent.bytes) : restartEvent.reason);
            this.logFlowEvent(httpFlowInstance, msg, EventSeverity.TEST_WARNING);
            httpFlowInstance.setStatus(FlowInstanceStatus.ACTIVE_WARNING);
        }
        httpFlowInstance.setRequestStatus(this.convertHttpRequestStatus(runtimeHttpFlow.getRequestStatus()));
        RuntimeHttpClient runtimeHttpClient = runtimeHttpFlow.getRuntimeHttpClient();
        if (runtimeHttpClient.hasSession()) {
            HTTPSessionInfo clientSession = runtimeHttpClient.getHTTPSessionInfo();
            this.updateHttpResult(httpFlowInstance.getClientHttpSession(), clientSession, runtimeHttpClient.getCumulativeHTTPResultData(), runtimeHttpClient.getCumulativeTcpResultData());
        }
        if ((serverSession = runtimeHttpFlow.getServerSessionInfo()) != null) {
            this.updateHttpResult(httpFlowInstance.getServerHttpSession(), serverSession, runtimeHttpFlow.getServerCumulHTTP(), runtimeHttpFlow.getServerCumulTcp());
            try {
                TCPSessionInfo tcpInfo = serverSession.TcpSessionInfoGet();
                boolean negotiatedL4S = tcpInfo.PragueIsEnabled();
                boolean expectedL4s = runtimeHttpFlow.getModelHttpFlowTemplateReader().isL4S();
                if (expectedL4s && !negotiatedL4S) {
                    String warningL4SOff = "L4S negotiation failed.";
                    String sourceDestinationInfo = " Source: " + runtimeHttpFlow.getSourceRuntimePort().getName() + ". Destination: " + runtimeHttpFlow.getRuntimeDestinationPort().getName();
                    String logMessage = "L4S negotiation failed." + sourceDestinationInfo;
                    List events = this.eventManager.getAllFlowInstanceEvents((FlowInstance)httpFlowInstance);
                    boolean logWarning = true;
                    for (FlowInstanceEvent event : events) {
                        if (!event.getDescription().equals(logMessage)) continue;
                        logWarning = false;
                        break;
                    }
                    if (logWarning) {
                        this.logFlowEvent(httpFlowInstance, logMessage, EventSeverity.TEST_WARNING);
                        httpFlowInstance.setStatus(FlowInstanceStatus.ACTIVE_WARNING);
                    }
                }
            }
            catch (TechnicalError | UnsupportedFeature tcpInfo) {
                // empty catch block
            }
        }
        switch (httpFlowInstance.getRequestStatus()) {
            case CONFIGURING: 
            case SCHEDULED: 
            case CONNECTING: 
            case ERROR: {
                long now = runtimeHttpFlow.BBTimestamp();
                if (!runtimeHttpClient.hasSession()) {
                    this.nullSnapshot(httpFlowInstance.getClientHttpSession(), now);
                }
                if (serverSession != null) break;
                this.nullSnapshot(httpFlowInstance.getServerHttpSession(), now);
                break;
            }
            case FINISHED: 
            case STOPPED: {
                this.dirtyHttpFlows.dirty(runtimeHttpFlow);
            }
        }
        this.flowInstanceManager.lightUpdate((BaseEntity)httpFlowInstance);
    }

    private void nullSnapshot(HttpSession httpSession, long now) {
        if (httpSession.getSnapshotResolution() == null) {
            long DEFAULT_SNAPSHOT_RESOLUTION = 1000000000L;
            httpSession.setSnapshotResolution(Long.valueOf(1000000000L));
        }
        long snapshotresolution = httpSession.getSnapshotResolution();
        now -= now % snapshotresolution;
        HttpSessionSnapshot newHttpSnapshot = new HttpSessionSnapshot(httpSession, Long.valueOf(now -= snapshotresolution), httpSession.getSnapshotResolution(), Long.valueOf(0L), Long.valueOf(0L));
        httpSession.setLatestSnapshot(newHttpSnapshot);
        this.intervalHttpSnapshotManager.intervalSnapshot(newHttpSnapshot);
        TcpSessionSnapshot newTcpSnapshot = new TcpSessionSnapshot(httpSession.getTcpSession(), Long.valueOf(now), httpSession.getSnapshotResolution());
        TCPSnapshotChild fix = this.intervalSnapshotManager.intervalSnapshot(newTcpSnapshot);
        fix.done();
    }

    private void updateHttpResult(HttpSession databaseHttpSession, HTTPSessionInfo apiHttpSessionInfo, LocalHttpResultData httpLatestAccumulated, LocalTcpResultData tcpLatestAccumulated) {
        HTTPResultHistory apiHttpResultHistory = apiHttpSessionInfo.ResultHistoryGet();
        long httpIntervalDuration = apiHttpResultHistory.SamplingIntervalDurationGet();
        if (databaseHttpSession.getSnapshotResolution() == null) {
            databaseHttpSession.setSnapshotResolution(Long.valueOf(httpIntervalDuration));
        }
        TCPSessionInfo apiTcpSessionInfo = apiHttpSessionInfo.TcpSessionInfoGet();
        TCPResultHistory apiTcpResultHistory = apiTcpSessionInfo.ResultHistoryGet();
        TcpSession tcpSession = databaseHttpSession.getTcpSession();
        int httpHistorySize = (int)apiHttpResultHistory.CumulativeLengthGet();
        if (httpHistorySize > 0) {
            databaseHttpSession.setRxByteCountHeader(httpLatestAccumulated.RxByteCountHeaderGet());
            databaseHttpSession.setRxBytePayload(httpLatestAccumulated.RxByteCountPayloadGet());
            databaseHttpSession.setRxByteCount(Long.valueOf(httpLatestAccumulated.RxByteCountTotalGet()));
            if (httpLatestAccumulated.RxByteCountTotalGet() > 0L) {
                databaseHttpSession.setRxFirstByteTime(Long.valueOf(httpLatestAccumulated.RxTimestampFirstGet()));
                databaseHttpSession.setRxLastByteTime(Long.valueOf(httpLatestAccumulated.RxTimestampLastGet()));
            } else {
                databaseHttpSession.setRxFirstByteTime(Long.valueOf(0L));
                databaseHttpSession.setRxLastByteTime(Long.valueOf(0L));
            }
            databaseHttpSession.setTxByteCountHeader(httpLatestAccumulated.TxByteCountHeaderGet());
            databaseHttpSession.setTxByteCountPayload(httpLatestAccumulated.TxByteCountPayloadGet());
            databaseHttpSession.setTxByteCount(Long.valueOf(httpLatestAccumulated.TxByteCountTotalGet()));
            if (httpLatestAccumulated.TxByteCountTotalGet() > 0L) {
                databaseHttpSession.setTxFirstByteTime(Long.valueOf(httpLatestAccumulated.TxTimestampFirstGet()));
                databaseHttpSession.setTxLastByteTime(Long.valueOf(httpLatestAccumulated.TxTimestampLastGet()));
            } else {
                databaseHttpSession.setTxFirstByteTime(Long.valueOf(0L));
                databaseHttpSession.setTxLastByteTime(Long.valueOf(0L));
            }
        }
        this.httpSessionManager.lightUpdate((BaseEntity)databaseHttpSession);
        int tcpHistorySize = (int)apiTcpResultHistory.CumulativeLengthGet();
        if (tcpHistorySize > 0) {
            tcpSession.setState(this.convertApiTcpState(tcpLatestAccumulated.ConnectionStateGet()));
            tcpSession.setCongestionAvoidanceAlgorithm(this.convertApiTcpCAA(apiTcpSessionInfo.CongestionAvoidanceAlgorithmGet()));
            tcpSession.setMaximumSegmentSize(Integer.valueOf(apiTcpSessionInfo.MaximumSegmentSizeGet()));
            TcpSessionSnapshot newSnapshot = new TcpSessionSnapshot(tcpSession, Long.valueOf(tcpLatestAccumulated.TimestampGet()), Long.valueOf(tcpLatestAccumulated.IntervalDurationGet()));
            newSnapshot.setCongestionWindowCurrent(tcpLatestAccumulated.CongestionWindowCurrentGet());
            newSnapshot.setCongestionWindowMaximum(tcpLatestAccumulated.CongestionWindowMaximumGet());
            newSnapshot.setCongestionWindowMinimum(tcpLatestAccumulated.CongestionWindowMinimumGet());
            newSnapshot.setReceiverWindowCurrent(tcpLatestAccumulated.ReceiverWindowCurrentGet());
            newSnapshot.setReceiverWindowMaximum(tcpLatestAccumulated.ReceiverWindowMaximumGet());
            newSnapshot.setReceiverWindowMinimum(tcpLatestAccumulated.ReceiverWindowMinimumGet());
            newSnapshot.setRoundTripTimeCurrent(tcpLatestAccumulated.RoundTripTimeAverageGet());
            newSnapshot.setRoundTripTimeMaximum(tcpLatestAccumulated.RoundTripTimeMaximumGet());
            newSnapshot.setRoundTripTimeMinimum(tcpLatestAccumulated.RoundTripTimeMinimumGet());
            newSnapshot.setSlowStartThresholdCurrent(tcpLatestAccumulated.SlowStartThresholdCurrentGet());
            newSnapshot.setLocalECNMarkings(tcpLatestAccumulated.RxLocalCongestionNotificationCountGet());
            newSnapshot.setRemoteECNMarkings(tcpLatestAccumulated.RxRemoteCongestionNotificationCountGet());
            TCPSnapshotChilderen fix = this.cumulativeSnapshotManager.cumulativeSnapshot(newSnapshot);
            this.storeTcpSnapshot(fix, tcpLatestAccumulated, newSnapshot);
        }
        HTTPResultDataList httpResultData = apiHttpResultHistory.IntervalGet();
        int i = 0;
        while (i < httpResultData.size() - 1) {
            HTTPResultData apiIntervalData = httpResultData.get(i);
            long txByteCountTotal = apiIntervalData.TxByteCountTotalGet();
            long rxByteCountTotal = apiIntervalData.RxByteCountTotalGet();
            HttpSessionSnapshot newSnapshot = new HttpSessionSnapshot(databaseHttpSession, Long.valueOf(apiIntervalData.TimestampGet()), Long.valueOf(httpIntervalDuration), Long.valueOf(txByteCountTotal), Long.valueOf(rxByteCountTotal));
            databaseHttpSession.setLatestSnapshot(newSnapshot);
            if (this.shouldStoreInterval) {
                this.intervalHttpSnapshotManager.intervalSnapshot(newSnapshot);
            }
            ++i;
        }
        TCPResultDataList tcpResultData = apiTcpResultHistory.IntervalGet();
        int i2 = 0;
        while (this.shouldStoreInterval && i2 < tcpResultData.size() - 1) {
            TCPResultData apiIntervalData = tcpResultData.get(i2);
            TcpSessionSnapshot newSnapshot = new TcpSessionSnapshot(tcpSession, Long.valueOf(apiIntervalData.TimestampGet()), Long.valueOf(apiIntervalData.IntervalDurationGet()));
            newSnapshot.setCongestionWindowCurrent(apiIntervalData.CongestionWindowCurrentGet());
            newSnapshot.setCongestionWindowMaximum(apiIntervalData.CongestionWindowMaximumGet());
            newSnapshot.setCongestionWindowMinimum(apiIntervalData.CongestionWindowMinimumGet());
            newSnapshot.setReceiverWindowCurrent(apiIntervalData.ReceiverWindowCurrentGet());
            newSnapshot.setReceiverWindowMaximum(apiIntervalData.ReceiverWindowMaximumGet());
            newSnapshot.setReceiverWindowMinimum(apiIntervalData.ReceiverWindowMinimumGet());
            try {
                newSnapshot.setRoundTripTimeCurrent(apiIntervalData.RoundTripTimeAverageGet());
            }
            catch (DomainError e) {
                this.noticeRttOnlyCurrent(databaseHttpSession);
                newSnapshot.setRoundTripTimeCurrent(apiIntervalData.RoundTripTimeCurrentGet());
            }
            newSnapshot.setRoundTripTimeMaximum(apiIntervalData.RoundTripTimeMaximumGet());
            newSnapshot.setRoundTripTimeMinimum(apiIntervalData.RoundTripTimeMinimumGet());
            newSnapshot.setSlowStartThresholdCurrent(apiIntervalData.SlowStartThresholdCurrentGet());
            try {
                newSnapshot.setLocalECNMarkings(apiIntervalData.RxLocalCongestionNotificationCountGet());
                newSnapshot.setRemoteECNMarkings(apiIntervalData.RxRemoteCongestionNotificationCountGet());
            }
            catch (DomainError e) {
                newSnapshot.setLocalECNMarkings(0L);
                newSnapshot.setRemoteECNMarkings(0L);
            }
            TCPSnapshotChild fix = this.intervalSnapshotManager.intervalSnapshot(newSnapshot);
            this.storeTcpSnapshot(fix, apiIntervalData, newSnapshot);
            ++i2;
        }
    }

    private void noticeRttOnlyCurrent(HttpSession session) {
        Server server = session.getHttpApplication().getPort().getInterface().getServer();
        String uuid = server.getUuid();
        if (this.hasWarnedNoAverageRTT.contains(uuid)) {
            return;
        }
        String message = "Average TCP round-trip time is not yet available on this ByteBlower Server. An approximate value is used. \n Update the server to at least version 2.19.";
        Date time = new Date();
        ServerEvent event = new ServerEvent(time, message, EventSeverity.TEST_WARNING, server);
        event.setKnowledgebaseLink("https://support.excentis.com/index.php?/Knowledgebase/Article/View/byteblower-server-219-changelog");
        this.eventManager.persistIdEntity((BaseEntity)event);
        this.hasWarnedNoAverageRTT.add(uuid);
    }

    private void storeTcpSnapshot(TCPSnapshotChild fix, TCPResultData snapshot, TcpSessionSnapshot newSnapshot) {
        long txData;
        long rxData;
        long totalRetrans = snapshot.RetransmissionCountTotalGet();
        if (totalRetrans > 0L) {
            long slowRetrans = snapshot.RetransmissionCountSlowGet();
            long fastRetrans = snapshot.RetransmissionCountFastGet();
            TcpSessionSnapshotRetransmissionCounters retransmission = new TcpSessionSnapshotRetransmissionCounters(newSnapshot, slowRetrans, fastRetrans, totalRetrans);
            fix.add(retransmission);
        }
        if ((rxData = snapshot.RxByteCountTotalGet()) > 0L) {
            long rxHeader = snapshot.RxByteCountHeaderGet();
            long rxPayload = snapshot.RxByteCountPayloadGet();
            long rxSegments = snapshot.RxSegmentCountTotalGet();
            long rxTimestamp = snapshot.RxTimestampLastGet();
            long rxSegmentsOO = snapshot.RxSegmentCountOutOfOrderGet();
            TcpSessionSnapshotRxCounters rxCounters = new TcpSessionSnapshotRxCounters(newSnapshot, rxHeader, rxPayload, rxData, rxSegments, rxTimestamp, rxSegmentsOO);
            fix.add(rxCounters);
        }
        if ((txData = snapshot.TxByteCountTotalGet()) > 0L) {
            long txHeader = snapshot.TxByteCountHeaderGet();
            long txPayload = snapshot.TxByteCountPayloadGet();
            long txSegments = snapshot.TxSegmentCountTotalGet();
            long txTimestamp = snapshot.TxTimestampLastGet();
            TcpSessionSnapshotTxCounters counters = new TcpSessionSnapshotTxCounters(newSnapshot, txHeader, txPayload, txData, txSegments, txTimestamp);
            fix.add(counters);
        }
        try {
            long numSynRecv = snapshot.NumberOfSynReceivedGet();
            if (numSynRecv > 0L) {
                long lastSynRx = snapshot.TimestampSynReceivedGet();
                TcpSessionSnapshotSynReceived synData = new TcpSessionSnapshotSynReceived(newSnapshot, numSynRecv, lastSynRx);
                fix.add(synData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of received syn messages is not supported");
        }
        try {
            long numSynSent = snapshot.NumberOfSynSentGet();
            if (numSynSent > 0L) {
                long lastSynTx = snapshot.TimestampSynSentGet();
                TcpSessionSnapshotSynSent synTxData = new TcpSessionSnapshotSynSent(newSnapshot, numSynSent, lastSynTx);
                fix.add(synTxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of transmitted syn messages is not supported");
        }
        try {
            long numFinSent = snapshot.NumberOfFinSentGet();
            if (numFinSent > 0L) {
                long lastFinTx = snapshot.TimestampFinSentGet();
                TcpSessionSnapshotFinSent finTxData = new TcpSessionSnapshotFinSent(newSnapshot, numFinSent, lastFinTx);
                fix.add(finTxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of transmitted FIN messages is not supported");
        }
        try {
            long numFinRecv = snapshot.NumberOfFinReceivedGet();
            if (numFinRecv > 0L) {
                long lastFinRx = snapshot.TimestampFinReceivedGet();
                TcpSessionSnapshotFinReceived finRxData = new TcpSessionSnapshotFinReceived(newSnapshot, numFinRecv, lastFinRx);
                fix.add(finRxData);
            }
        }
        catch (DomainError ex) {
            LOGGER.info("Collecting number of received FIN messages is not supported");
        }
        fix.done();
    }

    private void handleGlobalResults(RuntimeScenario rtScenario, boolean isFinished) {
    }

    private HttpRequestStatus convertHttpRequestStatus(HTTPRequestStatus apiHttpRequestStatus) {
        if (apiHttpRequestStatus.equals(HTTPRequestStatus.Configuration)) {
            return HttpRequestStatus.CONFIGURING;
        }
        if (apiHttpRequestStatus.equals(HTTPRequestStatus.Scheduled)) {
            return HttpRequestStatus.SCHEDULED;
        }
        if (apiHttpRequestStatus.equals(HTTPRequestStatus.Connecting)) {
            return HttpRequestStatus.CONNECTING;
        }
        if (apiHttpRequestStatus.equals(HTTPRequestStatus.Running)) {
            return HttpRequestStatus.RUNNING;
        }
        if (apiHttpRequestStatus.equals(HTTPRequestStatus.Stopped)) {
            return HttpRequestStatus.STOPPED;
        }
        if (apiHttpRequestStatus.equals(HTTPRequestStatus.Finished)) {
            return HttpRequestStatus.FINISHED;
        }
        if (apiHttpRequestStatus.equals(HTTPRequestStatus.Error)) {
            return HttpRequestStatus.ERROR;
        }
        throw new IllegalStateException("Unexpected TCP State " + apiHttpRequestStatus);
    }

    private TcpState convertApiTcpState(TCPConnectionState apiTcpState) {
        if (apiTcpState.equals(TCPConnectionState.CLOSED)) {
            return TcpState.CLOSED;
        }
        if (apiTcpState.equals(TCPConnectionState.LISTEN)) {
            return TcpState.LISTEN;
        }
        if (apiTcpState.equals(TCPConnectionState.SYN_RECEIVED)) {
            return TcpState.SYN_RECEIVED;
        }
        if (apiTcpState.equals(TCPConnectionState.SYN_SENT)) {
            return TcpState.SYN_SENT;
        }
        if (apiTcpState.equals(TCPConnectionState.ESTABLISHED)) {
            return TcpState.ESTABLISHED;
        }
        if (apiTcpState.equals(TCPConnectionState.FIN_WAIT_1)) {
            return TcpState.FIN_WAIT_1;
        }
        if (apiTcpState.equals(TCPConnectionState.FIN_WAIT_2)) {
            return TcpState.FIN_WAIT_2;
        }
        if (apiTcpState.equals(TCPConnectionState.CLOSING)) {
            return TcpState.CLOSING;
        }
        if (apiTcpState.equals(TCPConnectionState.CLOSE_WAIT)) {
            return TcpState.CLOSE_WAIT;
        }
        if (apiTcpState.equals(TCPConnectionState.LAST_ACK)) {
            return TcpState.LAST_ACK;
        }
        if (apiTcpState.equals(TCPConnectionState.TIME_WAIT)) {
            return TcpState.TIME_WAIT;
        }
        throw new IllegalStateException("Unexpected TCP State " + apiTcpState);
    }

    private TcpCongestionAvoidanceAlgorithm convertApiTcpCAA(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm apiTcpCAA) {
        if (apiTcpCAA.equals(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.Sack)) {
            return TcpCongestionAvoidanceAlgorithm.SACK;
        }
        if (apiTcpCAA.equals(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.SackWithCubic)) {
            return TcpCongestionAvoidanceAlgorithm.SACK_WITH_CUBIC;
        }
        if (apiTcpCAA.equals(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.NewReno)) {
            return TcpCongestionAvoidanceAlgorithm.NEWRENO;
        }
        if (apiTcpCAA.equals(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.NewRenoWithCubic)) {
            return TcpCongestionAvoidanceAlgorithm.NEWRENO_WITH_CUBIC;
        }
        if (apiTcpCAA.equals(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.None)) {
            return TcpCongestionAvoidanceAlgorithm.NONE;
        }
        throw new IllegalStateException("Unexpected TCP congestion avoidance algorithm " + apiTcpCAA);
    }

    private TcpCongestionAvoidanceAlgorithm convertModelTcpCAAConfig(TCPCongestionAvoidanceAlgorithm mTcpCAAConfig) {
        switch (mTcpCAAConfig) {
            case NEW_RENO: {
                return TcpCongestionAvoidanceAlgorithm.NEWRENO;
            }
            case NEW_RENO_WITH_CUBIC: {
                return TcpCongestionAvoidanceAlgorithm.NEWRENO_WITH_CUBIC;
            }
            case SACK: {
                return TcpCongestionAvoidanceAlgorithm.SACK;
            }
            case NONE: {
                return TcpCongestionAvoidanceAlgorithm.NONE;
            }
            case SERVER_DEFAULT: 
            case SACK_WITH_CUBIC: {
                return TcpCongestionAvoidanceAlgorithm.SACK_WITH_CUBIC;
            }
        }
        throw new IllegalStateException("Unexpected TCP congestion avoidance algorithm configuration " + mTcpCAAConfig);
    }

    private HttpFlowInstance getCachedHttpFlowInstance(RuntimeFlow rtHttpFlow) {
        HttpFlowInstance entity = this.httpFlowInstanceCache.get(rtHttpFlow);
        if (entity == null) {
            throw new IllegalStateException("HttpFlowInstance entity should be cached when created");
        }
        return entity;
    }

    private static class ItemMerge<T extends Addable<T>> {
        private SortedMap<Long, CountVal<T>> timed = new TreeMap<Long, CountVal<T>>();
        final int expectedCount;
        final long range;
        long now;

        public ItemMerge(int expectedCount, long range) {
            this.expectedCount = expectedCount;
            this.range = range;
            this.now = 0L;
        }

        void add(long when, T val, T defaultVal) {
            this.now = Math.max(when, this.now);
            if (when + this.range < this.now) {
                return;
            }
            CountVal<T> past = this.timed.getOrDefault(when, new CountVal<T>(defaultVal, 0));
            this.timed.put(when, new CountVal<Addable>((Addable)val.add((Object)((Addable)past.val)), past.count + 1));
        }

        List<T> getVals() {
            ArrayList<Addable> results = new ArrayList<Addable>();
            while (!this.timed.isEmpty() && this.timed.firstKey() + this.range < this.now) {
                long current = this.timed.firstKey();
                CountVal first = (CountVal)this.timed.get(this.timed.firstKey());
                results.add((Addable)first.val);
                this.timed.remove(current);
            }
            while (!this.timed.isEmpty()) {
                Long currentKey = this.timed.firstKey();
                CountVal first = (CountVal)this.timed.get(this.timed.firstKey());
                if (first.count != this.expectedCount) break;
                results.add((Addable)first.val);
                this.timed.remove(currentKey);
            }
            return results;
        }

        private static class CountVal<T> {
            T val;
            int count;

            CountVal(T val, int count) {
                this.val = val;
                this.count = count;
            }
        }
    }
}

