/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.datapersistence.util.CloudUpload;
import com.excentis.products.byteblower.datapersistence.util.UploadJournal;
import com.excentis.products.byteblower.report.json.JsonScenario;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.run.actions.ConfigurePorts;
import com.excentis.products.byteblower.run.actions.InitializeScenario;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayDeque;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JSONGathering
extends BaseHandle
implements ConfigurePorts.Listener,
InitializeScenario.Listener,
RunScenario.Listener,
NatDiscovery.Listener {
    private static final int SAVE_INTERVAL = 10;
    private static final TemporalUnit SAVE_UNIT = ChronoUnit.SECONDS;
    private static final Logger LOGGER = Logger.getGlobal();
    private static final Executor pool = Executors.newSingleThreadExecutor();
    private static Job cleaner = new Job("Delayed upload"){

        protected IStatus run(IProgressMonitor arg0) {
            LOGGER.info("Checking for unupload parts");
            UploadJournal journal = new UploadJournal();
            ArrayDeque<UploadJournal.RedoUpload> workToDo = new ArrayDeque<UploadJournal.RedoUpload>(journal.searchNotFinished());
            boolean uploadStillWorks = true;
            while (uploadStillWorks && workToDo.size() > 0) {
                UploadJournal.RedoUpload someWork = (UploadJournal.RedoUpload)workToDo.poll();
                LOGGER.info(String.format("Found something not finished: %s", workToDo));
                BooleanSupplier work = JSONGathering.tryUpload(someWork.filename, someWork.testRun, someWork.sequenceCtr);
                uploadStillWorks = work.getAsBoolean();
                if (!workToDo.isEmpty()) continue;
                workToDo.addAll(journal.searchNotFinished());
            }
            LOGGER.info("Tried to upload all the remaining work");
            this.schedule(10000L);
            return Status.OK_STATUS;
        }
    };
    private final String currentTestRun = UUID.randomUUID().toString();
    private final JsonScenario scenario;
    private Path savePath;
    private Instant lastSave = Instant.EPOCH;
    private int uploadCtr = 0;

    public JSONGathering(TestDataPersistenceController pc) {
        super(pc);
        this.scenario = new JsonScenario();
    }

    private Path createJsonFileName() {
        try {
            Path pp = UploadJournal.baseSaveLocation();
            String baseName = String.format("report-%s-%d-", this.currentTestRun, this.uploadCtr);
            return Files.createTempFile(pp, baseName, ".json", new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Not able to create for JSON report", e);
            return this.savePath;
        }
    }

    @Override
    public void register(Context context) {
        context.listen(ConfigurePorts.Listener.class, (Object)this);
        context.listen(InitializeScenario.Listener.class, (Object)this);
        context.listen(RunScenario.Listener.class, (Object)this);
        context.listen(NatDiscovery.Listener.class, (Object)this);
    }

    public void onPortsConfigured(RuntimeScenario rtScenario) {
        for (RuntimePort port : rtScenario.getRuntimePorts()) {
            this.scenario.addPort(port);
        }
    }

    public void onScenarioInitializeStarting(RuntimeScenario rtScenario) {
        this.scenario.details(rtScenario);
    }

    private void saveLastResult() {
        this.savePath = this.createJsonFileName();
        this.saveResult(this.savePath, this.uploadCtr);
        this.scenario.dropRealtimeResults();
        this.lastSave = Instant.now();
        UploadJournal journal = new UploadJournal();
        journal.addFinish(this.currentTestRun, this.uploadCtr);
    }

    private void savetoNewResult() {
        this.savePath = this.createJsonFileName();
        this.saveResult(this.savePath, this.uploadCtr);
        this.scenario.dropRealtimeResults();
        this.lastSave = Instant.now();
        ++this.uploadCtr;
    }

    private void saveResult(Path dest, int sequence) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter fileOut = new FileWriter(dest.toString(), false);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String data = gson.toJson((Object)this.scenario);
                fileOut.write(data);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            LOGGER.log(Level.WARNING, "Can't write away the JSON report", io);
        }
        BooleanSupplier work = JSONGathering.tryUpload(dest, this.currentTestRun, sequence);
        pool.execute(work::getAsBoolean);
        this.lastSave = Instant.now();
    }

    private static BooleanSupplier tryUpload(Path dataPath, String currentTestRun, int uploadCtr) {
        String data = JSONGathering.loadData(dataPath);
        UploadJournal journal = new UploadJournal();
        journal.addTry(currentTestRun, uploadCtr, dataPath);
        BooleanSupplier uploadStep = () -> {
            String nextUpload;
            if (uploadCtr == 0) {
                CloudUpload.ReportCreated result = null;
                result = new CloudUpload().createReport(data);
                if (result.valid) {
                    journal.addReport(result.reportLink, currentTestRun);
                    nextUpload = result.moreLink;
                } else {
                    nextUpload = "";
                }
            } else {
                String previous = journal.searchUploadLink(currentTestRun, uploadCtr - 1);
                nextUpload = !previous.isBlank() ? new CloudUpload().appendReport(data, previous) : "";
            }
            if (nextUpload.isBlank()) {
                journal.addFail(dataPath, currentTestRun, uploadCtr);
            } else {
                journal.addSuccess(nextUpload, currentTestRun, uploadCtr, dataPath);
            }
            return !nextUpload.isBlank();
        };
        return uploadStep;
    }

    private static String loadData(Path dataPath) {
        String data;
        try {
            data = Files.readString(dataPath);
        }
        catch (IOException e) {
            return "";
        }
        return data;
    }

    public void onScenarioInitializeFinished(RuntimeScenario rtScenario) {
        this.scenario.frameblastingFlows(rtScenario.getRuntimeFlowsConfiguredFb());
        this.scenario.httpFlows(rtScenario.getRuntimeFlowsConfiguredHttp());
    }

    public void onScenarioInitializeCancelled(RuntimeScenario rtScenario) {
        this.savetoNewResult();
    }

    public void onScenarioInitializeFailed(RuntimeScenario rtScenario, String errorMessage) {
        this.savetoNewResult();
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        long start = System.nanoTime();
        for (RuntimeFbFlow rr : rtScenario.getRuntimeFlowsConfiguredFb()) {
            this.scenario.scenarioUpdate(rr);
        }
        for (RuntimeFbFlow rr : rtScenario.getRuntimeFlowsConfiguredHttp()) {
            this.scenario.scenarioUpdate((RuntimeHttpFlow)rr);
        }
        for (RuntimePort port : rtScenario.getRuntimePorts()) {
            this.scenario.scenarioUpdate(port);
        }
        if (Instant.now().minus(10L, SAVE_UNIT).isAfter(this.lastSave)) {
            this.savetoNewResult();
        }
        System.out.format("Direct JSON: %f s %n", (double)(System.nanoTime() - start) / 1.0E9);
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        for (RuntimeFbFlow rr : rtScenario.getRuntimeFlowsConfiguredFb()) {
            this.scenario.scenarioUpdate(rr);
        }
        for (RuntimeFbFlow rr : rtScenario.getRuntimeFlowsConfiguredHttp()) {
            this.scenario.scenarioUpdate((RuntimeHttpFlow)rr);
        }
        this.scenario.finish();
        this.saveLastResult();
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        for (RuntimeFbFlow rr : rtScenario.getRuntimeFlowsConfiguredFb()) {
            this.scenario.scenarioUpdate(rr);
        }
        for (RuntimeFbFlow rr : rtScenario.getRuntimeFlowsConfiguredHttp()) {
            this.scenario.scenarioUpdate((RuntimeHttpFlow)rr);
        }
        this.saveLastResult();
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        this.saveLastResult();
    }

    public void onNatDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.NatDiscoveryParameters natDiscovery) {
    }

    public void onNatPortDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, Integer publicL4Port, NatDiscovery.NatDiscoveryParameters natDiscovery) {
        this.scenario.addNatDiscovery(rtTargetPort, rtResolverPort, publicIpv4, l4Protocol, privateL4Port, publicL4Port, natDiscovery);
    }

    public void onNatDiscoveryFailed(RuntimePort resolver, RuntimePort target, String errorMessage) {
    }

    public void onNatPortDiscoveryFailed(RuntimePort resolver, RuntimePort target, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, String errorMessage) {
    }
}

