/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.ServerManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.ServerEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import java.util.Date;

public class MissingSnapshotsCheck
extends BaseHandle
implements RunScenario.Listener {
    private static final long MAX_MISSED_TIME = 6000L;
    private TestDataPersistenceController pc;
    private long previousMoment;
    private boolean hasLoggedWarning = false;

    public MissingSnapshotsCheck(TestDataPersistenceController pc) {
        super(pc);
        this.pc = pc;
    }

    @Override
    public void register(Context context) {
        context.listen(RunScenario.Listener.class, (Object)this);
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
        System.out.println("Scenario is being started!");
        this.previousMoment = System.currentTimeMillis();
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        long now = System.currentTimeMillis();
        if (!this.hasLoggedWarning && now - this.previousMoment > 6000L) {
            for (RuntimePort port : rtScenario.getRuntimePortsInvolved()) {
                RuntimeServer rtServer = port.getRuntimeServer();
                if (rtServer == null) continue;
                this.logMissedSnapshots(rtServer);
                break;
            }
        }
        this.previousMoment = now;
    }

    private void logMissedSnapshots(RuntimeServer rtServer) {
        String message = "The ByteBlower GUI wasn't able to keep up with the ByteBlower server. Some results over time are lost.";
        EventSeverity severity = EventSeverity.TEST_WARNING;
        Date now = new Date();
        ServerManager serverManager = new ServerManager(this.pc);
        EventManager eventManager = new EventManager(this.pc);
        Server server = serverManager.findOnUuid(rtServer.getUUID());
        ServerEvent event = new ServerEvent(now, "The ByteBlower GUI wasn't able to keep up with the ByteBlower server. Some results over time are lost.", severity, server);
        eventManager.persistIdEntity((BaseEntity)event);
        this.hasLoggedWarning = true;
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
    }
}

