/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv4AddressManager;
import com.excentis.products.byteblower.results.testdata.data.NatAddressMappingManager;
import com.excentis.products.byteblower.results.testdata.data.NatPortMappingManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMappingEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMappingEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.NatPortMappingProtocol;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.Date;
import java.util.logging.Logger;

public class NatDiscoveryHandle
extends BaseHandle
implements NatDiscovery.Listener {
    private static final Logger LOGGER = Logger.getGlobal();
    private final EventManager eventManager;
    private final Ipv4AddressManager ipv4AddressManager;
    private final ScenarioManager scenarioManager;
    private final PortManager portManager;
    private final NatAddressMappingManager natAddressMappingManager;
    private final NatPortMappingManager natPortMappingManager;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$PortType = NatDiscoveryHandle.$SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$PortType();
        $SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$IpType = NatDiscoveryHandle.$SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$IpType();
        $SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$L4Protocol = NatDiscoveryHandle.$SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$L4Protocol();
    }

    public NatDiscoveryHandle(TestDataPersistenceController pc) {
        super(pc);
        this.eventManager = new EventManager(pc);
        this.ipv4AddressManager = new Ipv4AddressManager(pc);
        this.scenarioManager = new ScenarioManager(pc);
        this.portManager = new PortManager(pc);
        this.natAddressMappingManager = new NatAddressMappingManager(pc);
        this.natPortMappingManager = new NatPortMappingManager(pc);
    }

    @Override
    public void register(Context context) {
        context.listen(NatDiscovery.Listener.class, (Object)this);
    }

    public void onNatDiscovered(RuntimePort rtPortResolver, RuntimePort rtPortTarget, String publicIpv4String, NatDiscovery.NatDiscoveryParameters natDiscovery) {
        this.handleNewAddressMapping(new Date(), rtPortResolver, rtPortTarget, publicIpv4String, natDiscovery);
    }

    public void onNatPortDiscovered(RuntimePort rtPortResolver, RuntimePort rtPortTarget, String publicIpv4String, NatDiscovery.L4Protocol portMappingType, Integer privatePort, Integer publicPort, NatDiscovery.NatDiscoveryParameters result) {
        if (rtPortResolver.isRuntimeLayer3Ipv4() && rtPortTarget.isRuntimeLayer3Ipv4()) {
            this.handleNewPortMapping(new Date(), rtPortResolver, rtPortTarget, publicIpv4String, portMappingType, privatePort, publicPort, result);
        } else {
            LOGGER.info("Not Saving NATDiscovery result: the participants are not all IPv4");
        }
    }

    public void onNatDiscoveryFailed(RuntimePort rtPortResolver, RuntimePort rtPortTarget, String errorMessage) {
    }

    public void onNatPortDiscoveryFailed(RuntimePort rtPortResolver, RuntimePort rtPortTarget, NatDiscovery.L4Protocol portMappingType, Integer privatePort, String errorMessage) {
    }

    private void handleNewAddressMapping(Date time, RuntimePort rtPortResolver, RuntimePort rtPortTarget, String publicIpv4String, NatDiscovery.NatDiscoveryParameters natDiscovery) {
        String scenarioName = rtPortResolver.getRuntimeScenario().getName();
        String resolverPortName = rtPortResolver.getName();
        String targetPortName = rtPortTarget.getName();
        NatAddressMapping addressMapping = this.persistAddressMapping(scenarioName, resolverPortName, targetPortName, publicIpv4String, natDiscovery);
        String message = "NAT Discovery from resolver '" + resolverPortName + "' to (private) target '" + targetPortName + "' obtained public IP " + publicIpv4String + ".";
        EventSeverity severity = EventSeverity.NETWORK_LOG;
        NatAddressMappingEvent event = new NatAddressMappingEvent(time, message, severity, addressMapping);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private void handleNewPortMapping(Date time, RuntimePort rtPortResolver, RuntimePort rtPortTarget, String publicIpv4String, NatDiscovery.L4Protocol portMappingType, Integer privatePort, Integer publicPort, NatDiscovery.NatDiscoveryParameters natDiscovery) {
        String discovery;
        String scenarioName = rtPortResolver.getRuntimeScenario().getName();
        String resolverPortName = rtPortResolver.getName();
        String targetPortName = rtPortTarget.getName();
        switch (natDiscovery.getPortType()) {
            case AUTOMATIC_PUBLIC_PORT_DISCOVERY: {
                discovery = "Automatic Discovery";
                break;
            }
            case MANUAL_PUBLIC_PORT: {
                discovery = "Port Mapping";
                break;
            }
            default: {
                discovery = "Unknown";
            }
        }
        NatAddressMapping addressMapping = this.persistAddressMapping(scenarioName, resolverPortName, targetPortName, publicIpv4String, natDiscovery);
        NatPortMappingProtocol protocol = this.convertNatPortMappingPortocol(portMappingType);
        NatPortMapping portMapping = this.natPortMappingManager.createOrUpdate(addressMapping, protocol, privatePort, publicPort, discovery);
        String message = "NAT Discovery from resolver '" + resolverPortName + "' to port " + privatePort + " on (private) target '" + targetPortName + "' obtained public IP and port " + publicIpv4String + ":" + publicPort + ".";
        EventSeverity severity = EventSeverity.NETWORK_LOG;
        NatPortMappingEvent event = new NatPortMappingEvent(time, message, severity, portMapping);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private NatAddressMapping persistAddressMapping(String scenarioName, String resolverPortName, String targetPortName, String publicIpv4String, NatDiscovery.NatDiscoveryParameters natDiscovery) {
        String discovery;
        Scenario scenario = this.scenarioManager.find(scenarioName);
        Port resolverPort = this.portManager.find(resolverPortName);
        Port targetPort = this.portManager.find(targetPortName);
        Ipv4Address publicIpv4Address = this.ipv4AddressManager.findOrCreate(publicIpv4String);
        switch (natDiscovery.getIpType()) {
            case AUTOMATIC_PUBLIC_IP_DISCOVERY: {
                discovery = "Automatic Discovery";
                break;
            }
            case MANUAL_PUBLIC_IP: {
                discovery = "Manual";
                break;
            }
            default: {
                discovery = "Unknown";
            }
        }
        return this.natAddressMappingManager.createOrUpdate(scenario, resolverPort, targetPort, publicIpv4Address, discovery);
    }

    private NatPortMappingProtocol convertNatPortMappingPortocol(NatDiscovery.L4Protocol portMappingType) {
        switch (portMappingType) {
            case UDP: {
                return NatPortMappingProtocol.UDP;
            }
            case TCP: {
                return NatPortMappingProtocol.TCP;
            }
        }
        return null;
    }
}

