/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.ServerManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.ServerEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.run.actions.ServerTimeSynchronization;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;

public class ServersOutOfSync
extends BaseHandle
implements ServerTimeSynchronization.Listener {
    private static final String CONFIGURING_TIME_SERVER_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/15/0/how-to-setting-the-date-and-time-on-a-byteblower-server";
    private static final long MAX_OUT_OF_SYNC_TIME = 400000000L;
    private final Map<RuntimeServer, Long> serverTimeOffset;
    private TestDataPersistenceController pc;

    public ServersOutOfSync(TestDataPersistenceController pc) {
        super(pc);
        this.pc = pc;
        this.serverTimeOffset = new IdentityHashMap<RuntimeServer, Long>();
    }

    @Override
    public void register(Context context) {
        context.listen(ServerTimeSynchronization.Listener.class, (Object)this);
    }

    public void onServerTimeOffset(RuntimeServer rtServer, long timeDifference) {
        for (Map.Entry<RuntimeServer, Long> otherMeasurement : this.serverTimeOffset.entrySet()) {
            long otherOffset = otherMeasurement.getValue();
            RuntimeServer otherServer = otherMeasurement.getKey();
            long syncDifference = otherOffset - timeDifference;
            if (Math.abs(syncDifference) <= 400000000L) continue;
            this.logWarning(rtServer, otherServer, syncDifference);
        }
        this.serverTimeOffset.put(rtServer, timeDifference);
    }

    private void logWarning(RuntimeServer rtServer, RuntimeServer otherServer, long syncDifference) {
        EventManager eventManager = new EventManager(this.pc);
        ServerManager serverManager = new ServerManager(this.pc);
        Date now = new Date();
        String messageFormat = "Server '%s' is out of sync with '%s'; Server '%s' runs %.1f seconds %s. \nSynchronize both servers to get aligned results over time.";
        String direction = syncDifference > 0L ? "ahead" : "behind";
        String message = String.format(messageFormat, rtServer.getName(), otherServer.getName(), rtServer.getName(), Math.abs((double)syncDifference / 1.0E9), direction);
        EventSeverity severity = EventSeverity.TEST_WARNING;
        Server server = serverManager.findOnUuid(rtServer.getUUID());
        ServerEvent event = new ServerEvent(now, message, severity, server);
        event.setKnowledgebaseLink(CONFIGURING_TIME_SERVER_ARTICLE);
        eventManager.persistIdEntity((BaseEntity)event);
    }
}

