/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import com.excentis.products.byteblower.datapersistence.util.CloudUploadResponse;
import com.excentis.products.byteblower.datapersistence.util.EclipseUtil;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public final class CloudUpload {
    private static Logger LOGGER = Logger.getGlobal();
    private static Executor ex = Executors.newCachedThreadPool();
    private final String baseUrl = ByteBlowerPreferences.getExcentisCloudUrl();
    private HttpClient client;

    public CloudUpload() {
        ProxySelector defaultProxy = ProxySelector.getDefault();
        this.client = HttpClient.newBuilder().proxy(defaultProxy).executor(ex).build();
    }

    public String appendReport(String data, String previousLink) {
        try {
            Uploader uploader = new Uploader(previousLink);
            boolean isGood = uploader.upload(data, ByteBlowerPreferences.getApiKey());
            LOGGER.info(String.format("Upload in %s parts", "" + isGood));
            if (isGood) {
                return uploader.moreLink();
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Unable upload Report", ex);
        }
        return "";
    }

    public ReportCreated createReport(String data) {
        try {
            Uploader uploader = new Uploader();
            boolean isGood = uploader.upload(data, ByteBlowerPreferences.getApiKey());
            LOGGER.info(String.format("Upload in %s parts", "" + isGood));
            if (isGood) {
                ReportCreated created = new ReportCreated(uploader.reportLink(), uploader.moreLink());
                return created;
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Unable upload Report", ex);
        }
        return ReportCreated.invalid();
    }

    private static byte[] compressedData(String data) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (GZIPOutputStream compressed = new GZIPOutputStream(output);){
                ((OutputStream)compressed).write(data.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Unable to compress data", ex);
        }
        return output.toByteArray();
    }

    public static class ReportCreated {
        public final boolean valid;
        public final String reportLink;
        public final String moreLink;

        static ReportCreated invalid() {
            return new ReportCreated();
        }

        ReportCreated(String reportLink, String moreLink) {
            this.valid = !reportLink.isBlank() && !moreLink.isBlank();
            this.reportLink = reportLink;
            this.moreLink = moreLink;
        }

        ReportCreated() {
            this.valid = false;
            this.reportLink = "";
            this.moreLink = "";
        }
    }

    private final class Uploader {
        private URI target;
        private CloudUploadResponse response;
        private final BiFunction<String, String, CloudUploadResponse> parser;

        Uploader() throws URISyntaxException {
            this.target = new URI(String.valueOf(CloudUpload.this.baseUrl) + "api/datasources");
            this.parser = CloudUploadResponse::parse;
        }

        Uploader(String moreAddress) throws URISyntaxException {
            this.target = new URI(moreAddress);
            this.parser = CloudUploadResponse::parseMore;
        }

        public boolean upload(String jsonData, String apiKey) {
            int code;
            block9: {
                block8: {
                    block7: {
                        if (apiKey != null && !jsonData.isBlank()) break block7;
                        return false;
                    }
                    String sanitizedKey = new String(apiKey.getBytes(StandardCharsets.US_ASCII));
                    HttpRequest.BodyPublisher uploadBody = HttpRequest.BodyPublishers.ofByteArray(CloudUpload.compressedData(jsonData));
                    HttpRequest req = HttpRequest.newBuilder().uri(this.target).header("Content-Type", "application/json").header("Authorization", "ApiKey " + sanitizedKey).header("accept", "application/json").header("Content-Encoding", "gzip").header("User-Agent", String.format("ByteBlower-RCP/%s", EclipseUtil.version())).POST(uploadBody).expectContinue(true).build();
                    CompletableFuture<HttpResponse<String>> upload = CloudUpload.this.client.sendAsync(req, HttpResponse.BodyHandlers.ofString());
                    HttpResponse<String> result = upload.get(60L, TimeUnit.MINUTES);
                    code = result.statusCode();
                    if (201 != code) break block8;
                    String body = result.body();
                    this.response = this.parser.apply(CloudUpload.this.baseUrl, body);
                    this.target = new URI(this.response.postMore);
                    return true;
                }
                if (401 != code) break block9;
                LOGGER.severe(() -> String.format("Excentis Cloud does not allow uploads with the configured API key. Please check the config or generate a new key.%n", code));
                return false;
            }
            try {
                LOGGER.severe(() -> String.format("Unexpected return code: %d %n", code));
                return false;
            }
            catch (ExecutionException | TimeoutException e) {
                LOGGER.log(Level.SEVERE, "Backend did not respond in time", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "Aborting the upload", e);
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException | URISyntaxException e) {
                LOGGER.log(Level.SEVERE, "Could not parse backend response", e);
            }
            return false;
        }

        public String reportLink() {
            if (this.response != null) {
                return this.response.report;
            }
            return CloudUpload.this.baseUrl;
        }

        public String moreLink() {
            if (this.response != null) {
                return this.response.postMore;
            }
            return "";
        }
    }
}

