/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class CloudUploadResponse {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final String INVALID = "";
    final String report;
    final String postMore;

    private CloudUploadResponse(String baseUrl, String reportFragment, String moreFragment) {
        this.report = String.valueOf(baseUrl) + reportFragment;
        this.postMore = String.valueOf(baseUrl) + moreFragment;
    }

    public boolean hasReport() {
        return !INVALID.equals(this.report);
    }

    public boolean hasMore() {
        return !INVALID.equals(this.postMore);
    }

    public static CloudUploadResponse parseMore(String baseUrl, String responseBody) {
        Gson jsonParser = new Gson();
        try {
            Map parsed = (Map)jsonParser.fromJson(responseBody, Map.class);
            String moreData = parsed.getOrDefault("postMore", INVALID).replace("/api/", "api/");
            return new CloudUploadResponse(baseUrl, INVALID, moreData);
        }
        catch (JsonSyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Did not receive a JSON reply from backend", ex);
            throw new RuntimeException("Did not receive a JSON reply from backend");
        }
    }

    public static CloudUploadResponse parse(String baseUrl, String responseBody) {
        Gson jsonParser = new Gson();
        try {
            List parsed = (List)jsonParser.fromJson(responseBody, List.class);
            if (parsed.size() > 0) {
                Map val = (Map)parsed.get(0);
                String reportFragment = val.getOrDefault("report", INVALID).replace("/api/", INVALID);
                String moreData = val.getOrDefault("postMore", INVALID).replace("/api/", "api/");
                if (!INVALID.equals(reportFragment)) {
                    return new CloudUploadResponse(baseUrl, reportFragment, moreData);
                }
            }
        }
        catch (JsonSyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Did not receive a JSON reply from backend", ex);
            throw new RuntimeException("Did not receive a JSON reply from backend");
        }
        throw new RuntimeException("Backend did not include report link");
    }
}

