/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import com.excentis.products.byteblower.datapersistence.util.CorruptJournalException;
import com.excentis.products.byteblower.datapersistence.util.SaveTestDataVisitor;
import com.excentis.products.byteblower.datapersistence.util.UploadJournal;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class ReportUploadThread
implements Iterator<UploadJournal.RedoUpload> {
    private static final Duration TRY_TIMEOUT = Duration.ofSeconds(90L);
    private final String testRunId;
    private final List<PartialReport> files;
    private boolean isFinished;

    static {
        assert (ReportUploadThread.testShortScenario()) : "A short scenario";
        assert (ReportUploadThread.testLongerScenario()) : "A longer one with retries";
        assert (ReportUploadThread.testTimedRetries()) : "Retries with a timeout";
    }

    /*
     * Unable to fully structure code
     */
    static boolean testLongerScenario() {
        aThread = new ReportUploadThread("aa");
        totalSequences = 30;
        try {
            ctr = 0;
            while (ctr < 30) {
                name = String.format("Something %d", new Object[]{ctr});
                aThread.addTryUpload(ctr, name, 0L);
                aThread.addFail(ctr, name);
                ++ctr;
            }
            if (!ReportUploadThread.$assertionsDisabled && aThread.isFinished) {
                throw new AssertionError();
            }
            aThread.addFinish(30);
            if (!ReportUploadThread.$assertionsDisabled && aThread.isFullyUploaded()) {
                throw new AssertionError();
            }
            recoverCtr = 0;
            recoverCtr = 0;
            while (recoverCtr < 15) {
                name = String.format("Something %d", new Object[]{recoverCtr});
                aThread.addTryUpload(recoverCtr, name, 0L);
                aThread.addSuccess(recoverCtr, name, name);
                ++recoverCtr;
            }
            if (ReportUploadThread.$assertionsDisabled || !aThread.isFullyUploaded()) ** GOTO lbl30
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                name = String.format("Something %d", new Object[]{recoverCtr});
                aThread.addTryUpload(recoverCtr, name, 0L);
                aThread.addSuccess(recoverCtr, name, name);
                ++recoverCtr;
lbl30:
                // 2 sources

                ** while (recoverCtr < 30)
            }
lbl31:
            // 1 sources

            if (!ReportUploadThread.$assertionsDisabled && !aThread.isFullyUploaded()) {
                throw new AssertionError();
            }
        }
        catch (CorruptJournalException e) {
            return false;
        }
        return true;
    }

    static boolean testShortScenario() {
        ReportUploadThread aThread = new ReportUploadThread("aa");
        try {
            aThread.addTryUpload(0, "Something", 0L);
            aThread.addFail(0, "Something");
            assert (!aThread.isFinished());
            assert (!aThread.isFullyUploaded());
            aThread.addSuccess(0, "Something", "Next");
            assert (!aThread.isFullyUploaded());
            assert (!aThread.isFinished());
            aThread.addFinish(1);
            assert (aThread.isFinished());
            assert (aThread.isFullyUploaded());
        }
        catch (CorruptJournalException e) {
            return false;
        }
        return true;
    }

    private static boolean testTimedRetries() {
        ReportUploadThread aThread = new ReportUploadThread("aa");
        try {
            aThread.addTryUpload(0, "some", 0L);
            assert (aThread.hasNext());
            aThread.addTryUpload(0, "some", Instant.now().toEpochMilli() / 1000L);
            assert (!aThread.hasNext());
        }
        catch (CorruptJournalException e) {
            return false;
        }
        return true;
    }

    public ReportUploadThread(String testRunId) {
        this.testRunId = testRunId;
        this.files = new ArrayList<PartialReport>();
    }

    public void addFinish(int ctr) throws CorruptJournalException {
        this.files.size();
        this.isFinished = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isFullyUploaded() {
        if (!this.isFinished) {
            return false;
        }
        for (PartialReport rr : this.files) {
            if (rr.onExcentisCloud()) continue;
            return false;
        }
        return true;
    }

    public List<String> fileNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (PartialReport aPart : this.files) {
            result.add(aPart.fileName);
        }
        return result;
    }

    public void addSuccess(int sequence, String filename, String nextUpload) throws CorruptJournalException {
        if (sequence >= this.files.size() || sequence < 0) {
            throw new CorruptJournalException();
        }
        PartialReport previous = this.files.get(sequence);
        this.files.set(sequence, previous.merge(true, filename, nextUpload));
    }

    public void addStillTrying(int sequence) throws CorruptJournalException {
        PartialReport result = new PartialReport(true, "", "");
        if (sequence > this.files.size() || sequence < 0) {
            throw new CorruptJournalException("Unexpected sequence number: " + sequence);
        }
        if (sequence == this.files.size()) {
            this.files.add(result);
        } else {
            this.files.set(sequence, result);
        }
    }

    public void addFail(int sequence, String filename) throws CorruptJournalException {
        PartialReport result = new PartialReport(false, filename, "");
        if (sequence > this.files.size() || sequence < 0) {
            throw new CorruptJournalException();
        }
        if (sequence == this.files.size()) {
            this.files.add(result);
        } else {
            this.files.set(sequence, result);
        }
    }

    @Override
    public boolean hasNext() {
        for (PartialReport partial : this.files) {
            boolean stillBusyUploading;
            boolean bl = stillBusyUploading = partial.isUpload && partial.nextUpload.isBlank();
            if (stillBusyUploading) {
                return false;
            }
            if (partial.isUpload) continue;
            return true;
        }
        return false;
    }

    @Override
    public UploadJournal.RedoUpload next() {
        int seqCtr = 0;
        while (seqCtr < this.files.size()) {
            boolean stillBusy;
            PartialReport partial = this.files.get(seqCtr);
            boolean bl = stillBusy = partial.isUpload && partial.nextUpload.isBlank();
            if (stillBusy) {
                throw new NoSuchElementException();
            }
            if (!partial.isUpload) {
                return new UploadJournal.RedoUpload(this.testRunId, seqCtr, partial.fileName);
            }
            ++seqCtr;
        }
        throw new NoSuchElementException();
    }

    public void addTryUpload(int uploadCtr, String fileName, long when) throws CorruptJournalException {
        Instant timedOutAt = Instant.ofEpochSecond(when).plus(TRY_TIMEOUT);
        if (Instant.now().isBefore(timedOutAt)) {
            this.addStillTrying(uploadCtr);
        } else {
            this.addFail(uploadCtr, fileName);
        }
    }

    public void visitNotFinished(SaveTestDataVisitor visitor, String base) {
        visitor.newTestRun(this.testRunId);
        int ctr = 0;
        while (ctr < this.files.size()) {
            String name = this.files.get((int)ctr).fileName;
            visitor.partialReport(Path.of(base, name), ctr);
            ++ctr;
        }
    }

    private static class PartialReport {
        final boolean isUpload;
        final String fileName;
        final String nextUpload;

        public PartialReport(boolean isUploaded, String fileName, String nextUpload) {
            assert (fileName != null);
            assert (nextUpload != null);
            this.isUpload = isUploaded;
            this.fileName = fileName;
            this.nextUpload = nextUpload;
        }

        public PartialReport merge(boolean isUpload, String otherFilename, String otherNextUpload) {
            String mergedFilename = this.fileName.isEmpty() ? otherFilename : this.fileName;
            String mergedNext = !otherNextUpload.isEmpty() ? otherNextUpload : this.nextUpload;
            return new PartialReport(isUpload || this.isUpload, mergedFilename, mergedNext);
        }

        public boolean onExcentisCloud() {
            return !this.nextUpload.isBlank();
        }
    }
}

