/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.report.json.FBFlowConfig;
import com.excentis.products.byteblower.report.json.JsonDestination;
import com.excentis.products.byteblower.report.json.JsonSource;
import com.excentis.products.byteblower.report.json.LatencyTrigger;
import com.excentis.products.byteblower.report.json.OutOfSequenceTrigger;
import com.excentis.products.byteblower.report.json.Trigger;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.LocalOutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class JsonFbFlow {
    protected FBFlowConfig config;
    protected List<JsonDestination> destinations;
    private transient HashMap<String, JsonDestination> mapped;
    protected JsonSource source;

    public JsonFbFlow(RuntimeFbFlow frameblasting) {
        this.source = new JsonSource(frameblasting.getSourceRuntimePort().getName());
        this.destinations = new ArrayList<JsonDestination>();
        this.mapped = new HashMap();
        this.config = new FBFlowConfig(frameblasting);
        for (RuntimePort destination : frameblasting.getDestinationAndEavesdropperRuntimePortsConfigured()) {
            String destName = destination.getName();
            JsonDestination dest = new JsonDestination(destName);
            this.destinations.add(dest);
            this.mapped.put(destName, dest);
        }
    }

    public void runUpdate(RuntimeFbFlow rtFlow) {
        rtFlow.visitSnapshots((RuntimeRx.SnapshotVisitor)new OverTimeUpdate());
        rtFlow.visitCumulativeSnapshots((RuntimeRx.SnapshotVisitor)new CumulativeUpdate());
        this.source.sent.cumulative(rtFlow.txCumulativeSnapshot());
        for (LocalTriggerResultData txInterval : rtFlow.txIntervalSnapshots()) {
            this.source.sent.addOvertime(txInterval);
        }
    }

    public void dropRealtimeResults() {
        this.source.sent.overTimeResults.clear();
        for (JsonDestination dest : this.destinations) {
            dest.dropRealtimeResults();
        }
    }

    private final class CumulativeUpdate
    implements RuntimeRx.SnapshotVisitor {
        private CumulativeUpdate() {
        }

        public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
            JsonDestination selected = JsonFbFlow.this.mapped.get(port.getName());
            if (selected == null) {
                return;
            }
            OutOfSequenceTrigger oos = selected.ensureOOS();
            LocalOutOfSequenceResultData[] localOutOfSequenceResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalOutOfSequenceResultData data = localOutOfSequenceResultDataArray[n2];
                oos.cumulative(data);
                ++n2;
            }
        }

        public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
            JsonDestination selected = JsonFbFlow.this.mapped.get(port.getName());
            if (selected == null) {
                return;
            }
            LatencyTrigger latency = selected.ensureLatency();
            latency.cumulative(trigger);
        }

        public void visit(RuntimePort port, LocalTriggerResultData[] trigger) {
            JsonDestination selected = JsonFbFlow.this.mapped.get(port.getName());
            if (selected == null) {
                return;
            }
            Trigger jsonTrigger = selected.ensureBasicTrigger();
            LocalTriggerResultData[] localTriggerResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalTriggerResultData data = localTriggerResultDataArray[n2];
                jsonTrigger.cumulative(data);
                ++n2;
            }
        }

        public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
            JsonDestination gg = JsonFbFlow.this.mapped.get(port.getName());
            if (gg == null) {
                return;
            }
            LatencyTrigger latency = gg.ensureLatency();
            LocalLatencyResultData[] localLatencyResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalLatencyResultData data = localLatencyResultDataArray[n2];
                latency.cumulative(data);
                ++n2;
            }
        }
    }

    private final class OverTimeUpdate
    implements RuntimeRx.SnapshotVisitor {
        private OverTimeUpdate() {
        }

        public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
            JsonDestination selected = JsonFbFlow.this.mapped.get(port.getName());
            if (selected == null) {
                return;
            }
            OutOfSequenceTrigger oos = selected.ensureOOS();
            LocalOutOfSequenceResultData[] localOutOfSequenceResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalOutOfSequenceResultData data = localOutOfSequenceResultDataArray[n2];
                oos.addOvertime(data);
                ++n2;
            }
        }

        public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
        }

        public void visit(RuntimePort port, LocalTriggerResultData[] trigger) {
            JsonDestination selected = JsonFbFlow.this.mapped.get(port.getName());
            if (selected == null) {
                return;
            }
            Trigger jsonTrigger = selected.ensureBasicTrigger();
            LocalTriggerResultData[] localTriggerResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalTriggerResultData data = localTriggerResultDataArray[n2];
                jsonTrigger.addOvertime(data);
                ++n2;
            }
        }

        public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
            JsonDestination selected = JsonFbFlow.this.mapped.get(port.getName());
            if (selected == null) {
                return;
            }
            LatencyTrigger latency = selected.ensureLatency();
            LocalLatencyResultData[] localLatencyResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalLatencyResultData data = localLatencyResultDataArray[n2];
                latency.addOvertime(data);
                ++n2;
            }
        }
    }
}

