/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.report.json.JsonByteBlowerPort;
import com.excentis.products.byteblower.report.json.NatDiscovery;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.ArrayList;
import java.util.List;

public class JsonIpv4Port
extends JsonByteBlowerPort {
    private String ipAddress;
    private String gateway;
    private String netmask;
    private String nat;
    private List<NatDiscovery> natDiscoveries;

    public JsonIpv4Port(RuntimePort port) {
        super(port);
        if (port.isMobile()) {
            this.gateway = null;
            this.netmask = null;
            this.macAddress = "Layer 2 Address Unknown";
        } else {
            this.ipAddress = port.getIPAddress();
            this.gateway = port.getGateway();
            this.netmask = port.getPrefix();
        }
        this.nat = !port.isNatted() ? "No" : "Yes";
        this.natDiscoveries = new ArrayList<NatDiscovery>();
    }

    public void addNAT(RuntimePort rtResolverPort, String ipAddress, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, Integer publicL4Port, NatDiscovery.NatDiscoveryParameters natDiscovery) {
        NatDiscovery discovery = new NatDiscovery(this.name, rtResolverPort.getName(), this.ipAddress, ipAddress, "Automatic Discovery", l4Protocol.toString(), privateL4Port, publicL4Port, "Automatic Discovery");
        for (NatDiscovery existing : this.natDiscoveries) {
            if (!existing.equals(discovery)) continue;
            return;
        }
        this.natDiscoveries.add(discovery);
    }
}

