/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.report.json.JsonByteBlowerPort;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.List;
import java.util.logging.Logger;

public class JsonIpv6Port
extends JsonByteBlowerPort {
    private String linkLocalAddress;
    private List<String> ipAddresses;
    private List<Integer> prefixLengths;
    private List<String> routers;

    public JsonIpv6Port(RuntimePort port) {
        super(port);
        RuntimeIPv6Configuration rr = (RuntimeIPv6Configuration)port.getRuntimeLayer3Configuration();
        this.linkLocalAddress = rr.getLinkLocalAddress();
        this.ipAddresses = List.of(port.getIPAddress());
        this.routers = List.of(port.getGateway());
        try {
            int iPrefix = Integer.parseInt(port.getPrefix());
            this.prefixLengths = List.of(Integer.valueOf(iPrefix));
        }
        catch (NumberFormatException e) {
            Logger.getGlobal().severe("Unknown IPv6 prefix " + port.getPrefix());
        }
    }
}

