/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplateFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeFixed;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowResult;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import java.util.ArrayList;
import java.util.Collections;

public class JsonRFC2544Flow {
    private String source;
    private String destination;
    private String flow;
    private long iterationDuration;
    private long packetSize;
    private double receivedByteRate;
    private double receivedFrameRate;
    private double acceptableLoss;
    private double actualLoss;

    public JsonRFC2544Flow(ThroughputFlowTest test) {
        for (FbFlowTemplateFrame templateFrames : test.getFlowTemplate().getFrames()) {
            FbFrame frame = templateFrames.getFrame();
            if (!(frame instanceof FbFrameSizeFixed)) continue;
            this.packetSize = ((FbFrameSizeFixed)frame).getSize().intValue();
        }
        this.acceptableLoss = test.getAcceptableLoss();
        this.source = test.getSource().getName();
        this.destination = test.getDestination().getName();
        this.flow = test.getName();
        this.iterationDuration = test.getIterationSize();
        ArrayList tmpResults = new ArrayList(test.getResults());
        Collections.sort(tmpResults, (a, b) -> (int)(a.getRxPackets() - b.getRxPackets()));
        for (ThroughputFlowResult result : test.getResults()) {
            if (!result.success()) continue;
            long receivedFrames = result.getRxPackets();
            long transmitFrames = result.getTxPackets();
            this.receivedByteRate = result.rxByteRate(EthernetThroughputType.FRAME_FULL_LAYER1_INCL_IFG);
            this.receivedFrameRate = result.rxFrameRate();
            this.actualLoss = 1.0 - (double)receivedFrames / (double)Math.max(transmitFrames, 1L);
            break;
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public double getAcceptableLoss() {
        return this.acceptableLoss;
    }

    public long getIterationDuration() {
        return this.iterationDuration;
    }

    public String getFlow() {
        return this.flow;
    }

    public double getActualLoss() {
        return this.actualLoss;
    }

    public double getReceivedFrameRate() {
        return this.receivedFrameRate;
    }

    public double getReceivedByteRate() {
        return this.receivedByteRate;
    }
}

