/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.report.json.FBLatencySnapshot;
import com.excentis.products.byteblower.report.json.LatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class LatencyTrigger {
    long jitter;
    long packetsValid;
    long packetsInvalid;
    long average = 0L;
    long minimum = Long.MAX_VALUE;
    long maximum = Long.MIN_VALUE;
    List<FBLatencySnapshot> overTimeResults = new ArrayList<FBLatencySnapshot>();
    List<LatencyDistributionSnapshot> distribution = new ArrayList<LatencyDistributionSnapshot>();
    public long packetsBelowRange = 0L;
    public long packetsAboveRange = 0L;
    private transient long iTime;

    LatencyTrigger() {
    }

    public void addOvertime(LocalLatencyResultData data) {
        long current = data.TimestampGet();
        int ctr = this.overTimeResults.size() - 1;
        while (ctr >= 0) {
            FBLatencySnapshot rr = this.overTimeResults.get(ctr);
            if (rr.iTime == current) {
                this.overTimeResults.set(ctr, new FBLatencySnapshot(data));
                return;
            }
            if (rr.iTime < current) break;
            --ctr;
        }
        this.overTimeResults.add(new FBLatencySnapshot(data));
    }

    public void cumulative(LocalLatencyResultData data) {
        if (data.TimestampGet() >= this.iTime) {
            this.iTime = data.TimestampGet();
            this.packetsValid = data.PacketCountValidGet();
            this.packetsInvalid = data.PacketCountInvalidGet();
            if (this.packetsValid > 0L) {
                this.jitter = data.JitterGet();
                this.average = data.LatencyAverageGet();
                this.minimum = data.LatencyMinimumGet();
                this.maximum = data.LatencyMaximumGet();
            }
        }
    }

    public void cumulative(LocalLatencyDistributionSnapshot data) {
        this.packetsAboveRange = data.PacketCountAboveMaximumGet();
        this.packetsBelowRange = data.PacketCountBelowMinimumGet();
        this.distribution.clear();
        long currentStart = data.RangeMinimumGet();
        long step = data.BucketWidthGet();
        Iterator iterator = data.PacketCountBucketsGet().iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            this.distribution.add(new LatencyDistributionSnapshot(currentStart, currentStart + step, val));
            currentStart += step;
        }
    }
}

