/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.report.json.FBSnapshot;
import com.excentis.products.byteblower.report.json.ISO8601;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import java.util.ArrayList;

class Trigger {
    transient long iTime;
    long bytes = 0L;
    long packets = 0L;
    String firstPacketTime;
    String lastPacketTime;
    ArrayList<FBSnapshot> overTimeResults = new ArrayList();

    Trigger() {
    }

    public void addOvertime(LocalTriggerResultData data) {
        long current = data.TimestampGet();
        int ctr = this.overTimeResults.size() - 1;
        while (ctr >= 0) {
            FBSnapshot rr = this.overTimeResults.get(ctr);
            if (rr.iTime == current) {
                this.overTimeResults.set(ctr, new FBSnapshot(data));
                return;
            }
            if (rr.iTime < current) break;
            --ctr;
        }
        this.overTimeResults.add(new FBSnapshot(data));
    }

    public void cumulative(LocalTriggerResultData data) {
        if (data.TimestampGet() >= this.iTime) {
            this.iTime = data.TimestampGet();
            this.bytes = data.ByteCountGet();
            this.packets = data.PacketCountGet();
            this.firstPacketTime = ISO8601.instantString(data.TimestampFirstGet());
            this.lastPacketTime = ISO8601.instantString(data.TimestampLastGet());
        }
    }
}

