/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.report.json.ISO8601;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.utils.LocalNetworkInfoResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WirelessEndpointData {
    protected String networkInterface = "unknown";
    protected String wirelessEndpoint = "unknown";
    protected List<Sample> overTimeResults = new ArrayList<Sample>();

    public WirelessEndpointData(String currentNetIF, String currentWep, Sample ... initialData) {
        this.overTimeResults = new ArrayList<Sample>(Arrays.asList(initialData));
    }

    public static void merge(List<WirelessEndpointData> wifiStatistics, LocalNetworkInfoResult res, RuntimePort port) {
        String currentWep = port.getName();
        if (res.untimedResults()) {
            return;
        }
        for (LocalNetworkInfoResult.LocalNetworkInterface aNetIf : res.InterfaceGet()) {
            if (!LocalNetworkInfoResult.NetIfType.WiFi.equals((Object)aNetIf.type)) continue;
            String currentNetIF = aNetIf.name;
            boolean found = false;
            Sample freshData = new Sample(res.TimestampGet(), aNetIf.bssid, aNetIf.ssid, aNetIf.rssi);
            for (WirelessEndpointData aStat : wifiStatistics) {
                boolean bl = found = aStat.networkInterface.equals(currentNetIF) && aStat.wirelessEndpoint.equals(currentWep);
                if (!found) continue;
                aStat.overTimeResults.add(freshData);
                break;
            }
            if (found) continue;
            WirelessEndpointData newNet = new WirelessEndpointData(currentNetIF, currentWep, freshData);
            wifiStatistics.add(newNet);
        }
    }

    static class Sample {
        protected String timestamp;
        protected String bssid;
        protected String ssid;
        protected long rssi;

        public Sample(long timestamp, String bssid, String ssid, long rssi) {
            this.timestamp = ISO8601.instantString(timestamp);
            this.bssid = bssid;
            this.ssid = ssid;
            this.rssi = rssi;
        }
    }
}

