/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.MacAddressField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

public class EthernetPacket
extends ProtocolLayer {
    public static final int TYPE_Ipv4 = 2048;
    public static final int TYPE_ARP = 2054;
    public static final int TYPE_Ipv6 = 34525;
    private static final int DA = 0;
    private static final int SA = 1;
    private static final int TYPE = 2;
    private static final int DATA = 3;
    private static final String[] FIELD_NAMES = new String[]{"Destination Address", "Source Address", "Type", "Data"};
    public static final int minByteSize = 60;
    public static final int minSize = 480;
    public static final int maxByteSizeJumbo = 8192;
    public static final int maxSize = 65536;
    private boolean isInvalid = false;

    public boolean isInvalid() {
        return this.isInvalid;
    }

    private EthernetPacket(EthernetPacket clone) {
        for (ProtocolField protoField : clone.fields) {
            this.fields.add(protoField.clone(this));
        }
        this.calcSize();
    }

    public EthernetPacket() {
        super(0);
        this.fields.add(new MacAddressField(48));
        this.fields.add(new MacAddressField(48));
        this.fields.add(new IntegerField(16));
        this.fields.add(new RawField(368));
        this.calcSize();
    }

    public void do_default() {
        this.setDA("00-00-00-00-00-00");
        this.setSA("00-00-00-00-00-00");
        this.setType(2048);
    }

    public EthernetPacket(int bufsize, byte[] buffer) {
        this();
        this.set(bufsize, buffer, 0);
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        this.isInvalid = false;
        this.size = 0;
        int initialOffset = offset;
        int used = 0;
        int i = 0;
        while (i <= 3) {
            offset = ((ProtocolField)this.fields.get(i)).set(bufsize - used, buffer, offset);
            used = offset - initialOffset;
            if (offset == -1 || used > bufsize) {
                this.isInvalid = true;
                return -1;
            }
            ++i;
        }
        if (bufsize < 480 || bufsize > 65536) {
            this.isInvalid = true;
            return -1;
        }
        this.size = bufsize;
        return -1;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        return sb.toString();
    }

    public Object getValue() {
        System.err.println("EthernetPacket::getValue() missing!");
        return new Object();
    }

    public ProtocolField getData() {
        return (ProtocolField)this.fields.get(3);
    }

    public int getType() {
        return ((IntegerField)this.fields.get(2)).getIntValue();
    }

    public void setDA(String s) {
        ((MacAddressField)this.fields.get(0)).set(s);
    }

    public void setSA(String s) {
        ((MacAddressField)this.fields.get(1)).set(s);
    }

    public void setType(int i) {
        ((IntegerField)this.fields.get(2)).set(i);
    }

    @Override
    public void setPayload(ProtocolField pf) {
        this.fields.set(3, pf);
        this.calcSize();
    }

    public String getSA() {
        return ((ProtocolField)this.fields.get(1)).toString();
    }

    public String getDA() {
        return ((ProtocolField)this.fields.get(0)).toString();
    }

    @Override
    public ProtocolField getField(int i) {
        return (ProtocolField)this.fields.get(i);
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSA());
        sb.append("->");
        sb.append(this.getDA());
        sb.append(" ");
        return sb.toString();
    }

    @Override
    public ProtocolField getPayload() {
        return (ProtocolField)this.fields.get(3);
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        return new EthernetPacket(this);
    }
}

