/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.Ipv6AddressField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

public class Ipv6Packet
extends ProtocolLayer {
    public static final int PROTO_TCP = 6;
    public static final int PROTO_UDP = 17;
    private static final int VERSION = 0;
    private static final int TRAFFIC_CLASS = 1;
    private static final int FLOW_LABEL = 2;
    private static final int PAYLOAD_LENGTH = 3;
    private static final int NEXT_HEADER = 4;
    private static final int HOP_LIMIT = 5;
    private static final int SOURCE_ADDRESS = 6;
    private static final int DESTINATION_ADDRESS = 7;
    private static final int PAYLOAD = 8;
    private static final String[] FIELD_NAMES = new String[]{"VERSION", "TRAFFIC_CLASS", "FLOW_LABEL", "PAYLOAD_LENGTH", "NEXT_HEADER", "HOP_LIMIT", "SOURCE_ADDRESS", "DESTINATION_ADDRESS", "PAYLOAD"};

    public Ipv6Packet() {
        super(0);
        this.fields.add(new IntegerField(4));
        this.fields.add(new IntegerField(8));
        this.fields.add(new IntegerField(20));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(8));
        this.fields.add(new IntegerField(8));
        this.fields.add(new Ipv6AddressField(128));
        this.fields.add(new Ipv6AddressField(128));
        this.fields.add(new RawField(0));
        this.calcSize();
    }

    public Ipv6Packet(ProtocolLayer parent) {
        this();
        this.setParent(parent);
    }

    public void do_default() {
        this.setVersion(6);
        this.setTrafficClass(0);
        this.setFlowLabel(0);
        this.setPayloadLength(0);
        this.setNextHeader(0);
        this.setHopLimit(0);
        this.setSourceAddress("0000:0000:0000:0000:0000:0000:0000:0000");
        this.setDestinationAddress("0000:0000:0000:0000:0000:0000:0000:0000");
    }

    public Ipv6Packet(ProtocolField protocolField) {
        this();
        int bitsize = protocolField.getSize();
        int bytesize = bitsize / 8;
        if (bytesize > 9999) {
            System.out.println("ERROR in IPPacket constructor : buffer size");
            return;
        }
        byte[] buffer = new byte[bytesize];
        protocolField.dump(buffer, 0);
        this.set(bitsize, buffer, 0);
    }

    public Ipv6Packet(int bufsize, byte[] buffer) {
        this();
        this.set(bufsize, buffer, 0);
    }

    public Ipv6Packet(int bufsize, byte[] buffer, int o) {
        this();
        this.set(bufsize, buffer, o);
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        int initialOffset = offset;
        int used = 0;
        int i = 0;
        while (i <= 8) {
            offset = ((ProtocolField)this.fields.get(i)).set(bufsize - used, buffer, offset);
            used = offset - initialOffset;
            if (offset == -1 || used > bufsize) {
                return -1;
            }
            ++i;
        }
        this.calcSize();
        return initialOffset + used;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        return sb.toString();
    }

    public int getVersion() {
        return ((IntegerField)this.fields.get(0)).getIntValue();
    }

    public int getTrafficClass() {
        return ((IntegerField)this.fields.get(1)).getIntValue();
    }

    public int getFlowLabel() {
        return ((IntegerField)this.fields.get(2)).getIntValue();
    }

    public int getPayloadLength() {
        return ((IntegerField)this.fields.get(3)).getIntValue();
    }

    public int getNextHeader() {
        return ((IntegerField)this.fields.get(4)).getIntValue();
    }

    public int getHopLimit() {
        return ((IntegerField)this.fields.get(5)).getIntValue();
    }

    public String getSourceAddress() {
        return ((Ipv6AddressField)this.fields.get(6)).toString();
    }

    public String getDestinationAddress() {
        return ((Ipv6AddressField)this.fields.get(7)).toString();
    }

    @Override
    public ProtocolField getPayload() {
        return (ProtocolField)this.fields.get(8);
    }

    public void setVersion(int i) {
        ((IntegerField)this.fields.get(0)).set(i);
    }

    public void setTrafficClass(int i) {
        ((IntegerField)this.fields.get(1)).set(i);
    }

    public void setFlowLabel(int i) {
        ((IntegerField)this.fields.get(2)).set(i);
    }

    public void setPayloadLength(int i) {
        ((IntegerField)this.fields.get(3)).set(i);
    }

    public void setNextHeader(int i) {
        ((IntegerField)this.fields.get(4)).set(i);
    }

    public void setHopLimit(int i) {
        ((IntegerField)this.fields.get(5)).set(i);
    }

    public void setSourceAddress(String s) {
        ((Ipv6AddressField)this.fields.get(6)).set(s);
    }

    public void setDestinationAddress(String s) {
        ((Ipv6AddressField)this.fields.get(7)).set(s);
    }

    @Override
    public void setPayload(ProtocolField pf) {
        this.fields.set(8, pf);
        this.calcSize();
    }

    @Override
    public ProtocolField getField(int i) {
        return (ProtocolField)this.fields.get(i);
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSourceAddress());
        sb.append("->");
        sb.append(this.getDestinationAddress());
        return sb.toString();
    }

    public void autoSetPayloadLength() {
        this.setPayloadLength(this.size / 8 - 40);
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        Ipv6Packet ipv6 = new Ipv6Packet((ProtocolLayer)parent);
        ipv6.fields.clear();
        for (ProtocolField protoField : this.fields) {
            ipv6.fields.add(protoField.clone(ipv6));
        }
        return ipv6;
    }
}

