/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.frame.ProtocolField;

class LongField
extends ProtocolField {
    private long value = 0L;

    public LongField(int s) {
        super(s);
    }

    public Object getValue() {
        return new Long(this.value);
    }

    @Override
    public int dump(byte[] buffer, int offset) {
        long tempvalue = this.value;
        if (offset % 8 != 0 || this.size % 8 != 0) {
            int i = this.size;
            while (i > 0) {
                if ((tempvalue & 1L) == 1L) {
                    FrameUtil.setBit(buffer, offset + i - 1);
                } else {
                    FrameUtil.resetBit(buffer, offset + i - 1);
                }
                tempvalue >>= 1;
                --i;
            }
        } else {
            int i = this.size / 8 + offset / 8;
            while (i > offset / 8) {
                buffer[i - 1] = (byte)(tempvalue % 256L);
                tempvalue >>= 8;
                --i;
            }
        }
        return offset + this.size;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    void set(long l) {
        this.value = l;
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        this.value = 0L;
        if (this.size % 8 != 0 || offset % 8 != 0) {
            int i = 0;
            while (i < this.size) {
                this.value <<= 1;
                if (FrameUtil.getBit(buffer, offset + i) > 0) {
                    ++this.value;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size / 8) {
                this.value *= 256L;
                this.value += (long)(0xFF & buffer[offset / 8 + i]);
                ++i;
            }
        }
        return offset + this.size;
    }

    public long getLongValue() {
        return this.value;
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        LongField longField = new LongField(this.getSize());
        longField.value = this.value;
        return longField;
    }
}

