/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.ProtocolField;
import java.util.ArrayList;
import java.util.List;

public abstract class ProtocolLayer
extends ProtocolField {
    List<ProtocolField> fields = new ArrayList<ProtocolField>();
    protected ProtocolLayer parent = null;

    ProtocolLayer() {
        this(-1);
    }

    ProtocolLayer(int s) {
        super(s);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        this.size = 0;
        int i = 0;
        while (i < this.fields.size()) {
            offset = this.fields.get(i).set(bufsize, buffer, offset);
            if (offset > bufsize) {
                return -1;
            }
            ++i;
        }
        this.size = bufsize - offset;
        return offset;
    }

    @Override
    public int dump(byte[] buffer, int offset) {
        int fieldsize = this.fields.size();
        int i = 0;
        while (i < fieldsize) {
            ProtocolField field = this.fields.get(i);
            offset = field.dump(buffer, offset);
            ++i;
        }
        return offset;
    }

    public void calcSize() {
        this.size = 0;
        int nofFields = this.fields.size();
        int i = 0;
        while (i < nofFields) {
            this.size += this.fields.get(i).getSize();
            ++i;
        }
        if (this.parent != null) {
            this.parent.calcSize();
        }
    }

    public List<ProtocolField> getFields() {
        return this.fields;
    }

    public ProtocolField getField(int i) {
        return this.fields.get(i);
    }

    public abstract void setPayload(ProtocolField var1);

    public abstract ProtocolField getPayload();

    public abstract List<String> getFieldsNames();

    public abstract String getShortDesc();

    public void setParent(ProtocolLayer new_parent) {
        this.parent = new_parent;
    }
}

