/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public abstract class ByteBlowerWorkbenchAction
extends Action
implements ActionFactory.IWorkbenchAction,
IOpenCloseListener {
    protected IWorkbenchWindow window;

    protected abstract String getActionId();

    protected abstract String getImageEnabled();

    protected abstract String getImageDisabled();

    public ByteBlowerWorkbenchAction(IWorkbenchWindow window) {
        this.window = window;
        String actionId = this.getActionId();
        String enabled = this.getImageEnabled();
        String disabled = this.getImageEnabled();
        this.setId(actionId);
        if (enabled != null) {
            this.setImageDescriptor(this.getImageDescriptor(enabled));
        }
        if (disabled != null) {
            this.setDisabledImageDescriptor(this.getImageDescriptor(disabled));
        }
        ProjectSwitchNotifier.getInstance().addOpenCloseListener((IOpenCloseListener)this);
        this.updateState();
    }

    private ImageDescriptor getImageDescriptor(String image) {
        return ImageCache.getImageDescriptor((String)image);
    }

    public void dispose() {
        ProjectSwitchNotifier.getInstance().removeOpenCloseListener((IOpenCloseListener)this);
    }

    protected abstract void updateState();

    public void projectOpenedOrClosed(ByteBlowerProject project) {
        this.updateState();
    }
}

