/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions;

import com.excentis.products.byteblower.gui.actions.advisor.ByteBlowerActionBarAdvisor;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.update.AutoUpdater;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ByteBlowerWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static String autoOpenProjectFile = null;
    private static ActionBarAdvisor actionBarAdvisor;

    public ByteBlowerWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public static void setAutoOpenProjectFile(String openProjectFile) {
        autoOpenProjectFile = openProjectFile;
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        actionBarAdvisor = new ByteBlowerActionBarAdvisor(configurer);
        return actionBarAdvisor;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowProgressIndicator(true);
        ByteBlowerGuiResourceController.setConfigurer((IWorkbenchWindowConfigurer)configurer);
        PreferenceManager pm = configurer.getWindow().getWorkbench().getPreferenceManager();
        pm.remove("org.eclipse.help.ui.browsersPreferencePage");
        pm.remove("com.example.intro.introCustomization");
    }

    private void closeAllEditors() {
        IWorkbenchPage page = this.getActivePage();
        if (page.getEditorReferences().length > 0) {
            page.closeAllEditors(false);
        }
    }

    private IWorkbenchPage getActivePage() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = wb.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        return activePage;
    }

    public void postWindowOpen() {
        this.closeAllEditorsNowAndOnShutdown();
        if (autoOpenProjectFile != null) {
            ByteBlowerGuiResourceController.getInstance().openProject(autoOpenProjectFile);
        }
        try {
            AutoUpdater.getInstance().performAutoUpdate();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("AutoUpdater is not active.");
        }
        IWorkbenchPage page = this.getActivePage();
        page.hideActionSet("org.eclipse.ui.actionSet.openFiles");
        super.postWindowOpen();
    }

    private void closeAllEditorsNowAndOnShutdown() {
        this.closeAllEditors();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                ByteBlowerWorkbenchWindowAdvisor.this.closeAllEditors();
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }
}

