/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.runner.GuiRunner;
import com.excentis.products.byteblower.utils.RunTitleUtility;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class RunTitleText
extends ControlContribution
implements ModifyListener {
    private Text txt;
    private static final String RUN_TITLE_HINT = "Run Title";
    private static final String RUN_TITLE_TOOLTIP = "Run Title\nThe text entered here will be attached to each executed Scenario.\nReports will also be created in the a subfolder with this name.\nFor example, \"DEVICE 123 ISSUE 456\".\nYou can filter on Run Titles in the Archive View.";
    private static final int PIXEL_WIDTH = 300;

    public RunTitleText(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        this.txt = new Text(parent, 2432);
        this.txt.setToolTipText(RUN_TITLE_TOOLTIP);
        this.txt.addModifyListener((ModifyListener)this);
        this.txt.setMessage(RUN_TITLE_HINT);
        this.txt.setTextLimit(200);
        this.initializeRunTitle();
        return this.txt;
    }

    private void initializeRunTitle() {
        String recentRunTitle = ByteBlowerPreferences.getRecentRunTitle();
        this.txt.setText(recentRunTitle);
        this.updateRunTitle();
    }

    protected int computeWidth(Control control) {
        return 300;
    }

    public void modifyText(ModifyEvent e) {
        this.updateRunTitle();
    }

    private void updateRunTitle() {
        String runTitle = this.getRunTitle();
        if (RunTitleUtility.isValidRunTitle((String)runTitle)) {
            GuiRunner.getInstance().setRunTitle(runTitle);
            ByteBlowerPreferences.setRecentRunTitle((String)runTitle);
        } else {
            runTitle = GuiRunner.getInstance().getRunTitle();
            int caretPos = this.txt.getCaretPosition();
            this.txt.setText(runTitle);
            this.txt.setSelection(caretPos, caretPos);
        }
    }

    private String getRunTitle() {
        String runTitle = this.txt.getText();
        if (runTitle.equals(RUN_TITLE_HINT)) {
            runTitle = "";
        }
        return runTitle.trim();
    }
}

