/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.operations;

import com.excentis.products.byteblower.gui.history.actions.ByteBlowerModelHistory;
import com.excentis.products.byteblower.gui.history.operations.IUndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerProjectReaderImpl;
import org.eclipse.core.commands.operations.IUndoContext;

public abstract class UndoableByteBlowerProjectOperation
extends UndoableByteBlowerOperation
implements IUndoableByteBlowerProjectOperation {
    private String label = "No label";
    protected final EByteBlowerObject object;
    protected ByteBlowerProject project = null;
    private static ByteBlowerProject currentProject = null;

    public static void setCurrentProject(ByteBlowerProject project) {
        if (currentProject != project) {
            if (currentProject != null) {
                IUndoContext oldUndoContext = UndoableByteBlowerProjectOperation.getUndoContext((EByteBlowerObject)currentProject);
                ByteBlowerModelHistory.history.dispose(oldUndoContext, true, true, true);
            }
            currentProject = project;
        }
    }

    protected UndoableByteBlowerProjectOperation(String label, EByteBlowerObject object) {
        super(UndoableByteBlowerProjectOperation.getUndoContext(object));
        this.label = label;
        this.object = object;
        this.project = UndoableByteBlowerProjectOperation.getByteBlowerProject(object);
    }

    private static IUndoContext getUndoContext(EByteBlowerObject parentObject) {
        ByteBlowerProject project = UndoableByteBlowerProjectOperation.getByteBlowerProject(parentObject);
        IUndoContext context = ByteBlowerProjectController.getUndoContext((ByteBlowerProject)project);
        return context;
    }

    private static ByteBlowerProject getByteBlowerProject(EByteBlowerObject parentObject) {
        EByteBlowerObjectReader reader = ReaderFactory.create((EByteBlowerObject)parentObject);
        ByteBlowerProjectReader projectReader = reader.getProjectReader();
        return (ByteBlowerProject)projectReader.getObject();
    }

    protected ByteBlowerProject getProject() {
        return this.project;
    }

    protected ByteBlowerProjectReader getProjectReader() {
        return new ByteBlowerProjectReaderImpl(this.getProject());
    }

    protected ByteBlowerProjectController getProjectController() {
        return new ByteBlowerProjectController(this.getProject());
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (this.label == null) {
            System.err.println("NULL label for operation " + this.getClass().getSimpleName());
        }
        return this.label;
    }

    @Override
    public boolean canUndo() {
        boolean canUndo;
        boolean bl = canUndo = this.project == currentProject;
        return canUndo && super.canUndo();
    }

    @Override
    public boolean canRedo() {
        boolean canRedo;
        boolean bl = canRedo = this.project == currentProject;
        return canRedo && super.canRedo();
    }
}

