/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.operations.copydown;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.CopyDownInfo;
import com.excentis.products.byteblower.gui.history.operations.copydown.FeatureViewTranslator;
import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.IEObjectCopyDown;
import com.excentis.products.byteblower.gui.history.operations.copydown.IncrementTimeDialog;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.IpAddressReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.utils.Cloneable;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.PlatformUI;

public abstract class EByteBlowerObjectCopyDown<CopyDownObjectClass extends EObject>
implements IEObjectCopyDown<CopyDownObjectClass> {
    @Override
    public CopyDownInfo copyDown(CopyDownObjectClass selectedEObject, CopyDownObjectClass affectedEObject, CopyDownInfo copyDownInfo, FeatureViewTranslator translator, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        if (translator.canCopyDownGenerically()) {
            return this.copyDownGenerically(selectedEObject, affectedEObject, copyDownInfo, translator, operation, mode, takenNames);
        }
        return this.copyDownSpecial(selectedEObject, affectedEObject, copyDownInfo, translator, operation, mode, takenNames);
    }

    protected abstract CopyDownInfo copyDownSpecial(CopyDownObjectClass var1, CopyDownObjectClass var2, CopyDownInfo var3, FeatureViewTranslator var4, UndoableByteBlowerProjectOperation var5, ICopyDownOperation.ECopyDownMode var6, List<String> var7);

    public CopyDownInfo copyDownGenerically(CopyDownObjectClass selectedObject, CopyDownObjectClass affectedEObject, CopyDownInfo copyDownInfo, FeatureViewTranslator translator, UndoableByteBlowerProjectOperation operation, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        EClass affectedEClass;
        EList affectedFeatures;
        CommandWithReference commandWithReference = null;
        FeatureInfo featureInfo = translator.getFeatureInfo();
        int featureType = featureInfo.getFeatureType();
        EStructuralFeature feature = featureInfo.getFeature();
        if (copyDownInfo == null) {
            Object initialValue = selectedObject.eGet(feature);
            copyDownInfo = new CopyDownInfo(initialValue, null, false);
        }
        if ((affectedFeatures = (affectedEClass = affectedEObject.eClass()).getEAllStructuralFeatures()).contains((Object)feature)) {
            EByteBlowerObjectController affectedController = ControllerFactory.create((EByteBlowerObject)((EByteBlowerObject)affectedEObject));
            switch (featureType) {
                case 1: {
                    copyDownInfo = this.getNextObjectInContainer(copyDownInfo, mode);
                    break;
                }
                case 2: {
                    copyDownInfo = this.getNextName(copyDownInfo, mode, takenNames);
                    break;
                }
                case 3: {
                    copyDownInfo = this.getNextTime(copyDownInfo, mode);
                    break;
                }
                case 4: {
                    copyDownInfo = this.getNextIp(copyDownInfo, mode);
                    break;
                }
                case 5: {
                    copyDownInfo = this.getNextAttribute(copyDownInfo, mode);
                    break;
                }
                default: {
                    System.err.println("EByteBlowerObjectCopyDown::copyDown : Unsupported feature type");
                }
            }
            if (!copyDownInfo.isStopper() && !this.isStopper(copyDownInfo, translator) && (commandWithReference = affectedController.set(feature, copyDownInfo.getValue())) != null) {
                Command command = commandWithReference.getCommand();
                copyDownInfo.setValue(commandWithReference.getCommandReference());
                operation.appendCommand(command);
            }
        } else {
            System.err.println("Cannot copy feature `" + feature.getContainerClass().getSimpleName() + "#" + feature.getName() + "` to object `" + affectedEClass.getName() + "`");
        }
        return copyDownInfo;
    }

    private CopyDownInfo getNextTime(CopyDownInfo copyDownInfo, ICopyDownOperation.ECopyDownMode mode) {
        if (mode == ICopyDownOperation.ECopyDownMode.increment) {
            if (copyDownInfo.getAmount() == null) {
                Object amount = this.getTimeIncrementAmount(mode);
                if (amount != null) {
                    copyDownInfo.setAmount(amount);
                } else {
                    copyDownInfo.setStopper(true);
                }
            }
            if (copyDownInfo.getValue() instanceof HighResolutionCalendar && copyDownInfo.getAmount() instanceof Long) {
                HighResolutionCalendar cal = (HighResolutionCalendar)copyDownInfo.getValue();
                Long nanos = cal.getTimeInNanoseconds();
                Long amount = (Long)copyDownInfo.getAmount();
                copyDownInfo.setValue(new HighResolutionCalendar(Long.valueOf(nanos + amount)));
            } else {
                System.err.println("EByteBlowerObjectCopyDown::getNextTime increment error : the copiedItem class is not yet supported. " + copyDownInfo.toString());
            }
        } else if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
            System.err.println("EByteBlowerObjectCopyDown::getNextTime decrement error : not yet supported.");
        }
        return copyDownInfo;
    }

    private Object getTimeIncrementAmount(ICopyDownOperation.ECopyDownMode mode) {
        IncrementTimeDialog dialog = new IncrementTimeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mode, 1);
        if (dialog.open() == 0) {
            return dialog.getIncrementTime().getTimeInNanoseconds();
        }
        return null;
    }

    private CopyDownInfo getNextIp(CopyDownInfo copyDownInfo, ICopyDownOperation.ECopyDownMode mode) {
        Object value = copyDownInfo.getValue();
        if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
            throw new RuntimeException("Decrement is currently not supported.");
        }
        if (mode == ICopyDownOperation.ECopyDownMode.increment) {
            if (value instanceof BasicEList) {
                BasicEList list = (BasicEList)value;
                NetworkAddressBytes bytes = new NetworkAddressBytes();
                bytes.addAll((Collection)list);
                value = IpAddressController.createFromBytes((NetworkAddressBytes)bytes);
                IpAddress ip = (IpAddress)value;
                IpAddressReader reader = ReaderFactory.create((IpAddress)ip);
                IpAddress incr = (IpAddress)reader.getIncrementedAddress();
                copyDownInfo.setValue(incr.getBytes());
            } else if (value instanceof IpAddress) {
                IpAddress ip = (IpAddress)value;
                IpAddressReader reader = ReaderFactory.create((IpAddress)ip);
                copyDownInfo.setValue(reader.getIncrementedAddress());
            } else if (value instanceof String) {
                String ipString = (String)value;
                IpAddress ip = IpAddressController.createFromString((String)ipString);
                IpAddressReader reader = ReaderFactory.create((IpAddress)ip);
                IpAddress incrementedIp = (IpAddress)reader.getIncrementedAddress();
                reader = ReaderFactory.create((IpAddress)incrementedIp);
                String incrementedAddress = reader.getAddress();
                copyDownInfo.setValue(incrementedAddress);
            }
        } else if (mode == ICopyDownOperation.ECopyDownMode.normal) {
            if (value instanceof BasicEList) {
                BasicEList list = (BasicEList)value;
                NetworkAddressBytes bytes = new NetworkAddressBytes();
                bytes.addAll((Collection)list);
                copyDownInfo.setValue(bytes);
            } else if (value instanceof IpAddress) {
                IpAddress ip = (IpAddress)value;
                IpAddressController reader = ControllerFactory.create((IpAddress)ip);
                IpAddress copy = (IpAddress)reader.copy();
                copyDownInfo.setValue(copy);
            } else {
                boolean cfr_ignored_0 = value instanceof String;
            }
        }
        return copyDownInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CopyDownInfo getNextAttribute(CopyDownInfo copyDownInfo, ICopyDownOperation.ECopyDownMode mode) {
        Object value = null;
        if (mode == ICopyDownOperation.ECopyDownMode.normal) {
            value = copyDownInfo.getValue();
            if (value instanceof Cloneable) {
                Object newValue = ((Cloneable)value).clone();
                copyDownInfo.setValue(newValue);
                return copyDownInfo;
            } else if (value instanceof EObject) {
                EObject newValue = EcoreUtil.copy((EObject)((EObject)value));
                copyDownInfo.setValue(newValue);
                return copyDownInfo;
            } else {
                Object newValue = value;
                copyDownInfo.setValue(newValue);
            }
            return copyDownInfo;
        } else if (mode == ICopyDownOperation.ECopyDownMode.increment) {
            value = copyDownInfo.getValue();
            if (value instanceof String) {
                value = Integer.parseInt((String)value);
                Integer integer = (Integer)value;
                integer = integer + 1;
                copyDownInfo.setValue(integer.toString());
                return copyDownInfo;
            } else if (value instanceof Short) {
                Short shorty = (Short)value;
                shorty = (short)(shorty + 1);
                copyDownInfo.setValue(shorty);
                return copyDownInfo;
            } else {
                if (!(value instanceof Integer)) throw new RuntimeException("Increment is currently not supported.");
                Integer integer = (Integer)value;
                integer = integer + 1;
                copyDownInfo.setValue(integer);
            }
            return copyDownInfo;
        } else {
            if (mode != ICopyDownOperation.ECopyDownMode.decrement) return copyDownInfo;
            value = copyDownInfo.getValue();
            if (value instanceof String) {
                value = Integer.parseInt((String)value);
                Integer integer = (Integer)value;
                integer = integer - 1;
                copyDownInfo.setValue(integer.toString());
                return copyDownInfo;
            } else if (value instanceof Integer) {
                Integer integer = (Integer)value;
                integer = integer - 1;
                copyDownInfo.setValue(integer);
                copyDownInfo.setStopper(integer < 0);
                return copyDownInfo;
            } else {
                if (!(value instanceof Short)) throw new RuntimeException("Decrement is currently not supported.");
                Short shorty = (Short)value;
                shorty = (short)(shorty - 1);
                copyDownInfo.setValue(shorty);
                copyDownInfo.setStopper(shorty < 0);
            }
        }
        return copyDownInfo;
    }

    protected boolean isStopper(CopyDownInfo copyDownInfo, FeatureViewTranslator translator) {
        return false;
    }

    private CopyDownInfo getNextName(CopyDownInfo copyDownInfo, ICopyDownOperation.ECopyDownMode mode, List<String> takenNames) {
        Object newValue = copyDownInfo.getValue();
        if (mode == ICopyDownOperation.ECopyDownMode.increment) {
            if (newValue instanceof String) {
                String name = (String)newValue;
                copyDownInfo.setValue(OldNamingTools.getIncrementedName((String)name, takenNames));
            } else {
                System.err.println("EByteBlowerObjectCopyDown::getNextName increment error : the copiedItem class is not yet supported. " + newValue.toString());
            }
        } else if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
            System.err.println("EByteBlowerObjectCopyDown::getNextName decrement error : not yet supported.");
        }
        return copyDownInfo;
    }

    private CopyDownInfo getNextObjectInContainer(CopyDownInfo copyDownInfo, ICopyDownOperation.ECopyDownMode mode) {
        Object value = copyDownInfo.getValue();
        if (mode == ICopyDownOperation.ECopyDownMode.increment) {
            if (value instanceof EByteBlowerObject) {
                EByteBlowerObject eByteBlowerObject = (EByteBlowerObject)value;
                EByteBlowerObjectReader reader = ReaderFactory.create((EByteBlowerObject)eByteBlowerObject);
                EByteBlowerObject nextEObject = reader.getNextInContainer();
                copyDownInfo.setValue(nextEObject);
                copyDownInfo.setStopper(nextEObject == null);
            } else {
                System.err.println("EByteBlowerObjectCopyDown::copyDown increment error : the copiedItem class is not yet supported. " + (value != null ? value.toString() : null));
            }
        } else if (mode == ICopyDownOperation.ECopyDownMode.decrement) {
            if (value instanceof EByteBlowerObject) {
                EByteBlowerObject eByteBlowerObject = (EByteBlowerObject)value;
                EByteBlowerObjectReader reader = ReaderFactory.create((EByteBlowerObject)eByteBlowerObject);
                EByteBlowerObject nextEObject = reader.getPreviousInContainer();
                copyDownInfo.setValue(nextEObject);
                copyDownInfo.setStopper(nextEObject == null);
            } else {
                System.err.println("EByteBlowerObjectCopyDown::copyDown decrement error : the copiedItem class is not yet supported. " + (value != null ? value.toString() : null));
            }
        }
        return copyDownInfo;
    }

    @Override
    public Command createFinishCommand(FeatureViewTranslator translator, ICopyDownOperation.ECopyDownMode mode, CopyDownObjectClass selectedEObject) {
        return null;
    }
}

