/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.operations.copydown;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerProjectOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.CopyDownInfo;
import com.excentis.products.byteblower.gui.history.operations.copydown.FeatureViewTranslator;
import com.excentis.products.byteblower.gui.history.operations.copydown.ICopyDownOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.IEObjectCopyDown;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EObjectCopyDownOperation<CopyDownObjectClass extends EObject>
extends UndoableByteBlowerProjectOperation
implements ICopyDownOperation {
    private ColumnViewer columnViewer;
    private int column;
    private ICopyDownOperation.ECopyDownMode mode;
    private IEObjectCopyDown<CopyDownObjectClass> eObjectCopyDown;
    private BasicEList<CopyDownObjectClass> affected = new BasicEList();
    private BasicEList<CopyDownObjectClass> notaffected = new BasicEList();

    public EObjectCopyDownOperation(ByteBlowerProject byteBlowerProject, ColumnViewer columnViewer, int column, ICopyDownOperation.ECopyDownMode mode, IEObjectCopyDown<CopyDownObjectClass> eObjectCopyDown) {
        super(mode == ICopyDownOperation.ECopyDownMode.normal ? "Copy Down" : (mode == ICopyDownOperation.ECopyDownMode.increment ? "Copy Down Incrementing" : "Copy Down Decrementing"), (EByteBlowerObject)byteBlowerProject);
        this.columnViewer = columnViewer;
        this.column = column;
        this.mode = mode;
        this.eObjectCopyDown = eObjectCopyDown;
    }

    private void addTakenNames(ColumnViewer columnViewer, int column, List<?> existingObjects, List<String> takenNames) {
        IBaseLabelProvider baseLabelProvider = columnViewer.getLabelProvider();
        if (baseLabelProvider instanceof ITableItemLabelProvider) {
            ITableItemLabelProvider provider = (ITableItemLabelProvider)baseLabelProvider;
            for (Object existingObject : existingObjects) {
                takenNames.add(provider.getColumnText(existingObject, column));
            }
        } else if (baseLabelProvider instanceof ITableLabelProvider) {
            ITableLabelProvider provider = (ITableLabelProvider)baseLabelProvider;
            for (Object existingObject : existingObjects) {
                takenNames.add(provider.getColumnText(existingObject, column));
            }
        } else {
            Logger log = Logger.getGlobal();
            log.severe("Couldn't detect taken names: label provider is of type `" + baseLabelProvider.getClass().toString() + "'");
        }
    }

    private void addTakenName(ColumnViewer columnViewer, int column, Object existingObject, List<String> takenNames) {
        IBaseLabelProvider baseLabelProvider = columnViewer.getLabelProvider();
        if (baseLabelProvider instanceof ITableItemLabelProvider) {
            ITableItemLabelProvider provider = (ITableItemLabelProvider)baseLabelProvider;
            takenNames.add(provider.getColumnText(existingObject, column));
        } else if (baseLabelProvider instanceof ITableLabelProvider) {
            ITableLabelProvider provider = (ITableLabelProvider)baseLabelProvider;
            takenNames.add(provider.getColumnText(existingObject, column));
        } else {
            Logger log = Logger.getGlobal();
            log.severe("Couldn't detect taken names: label provider is of type `" + baseLabelProvider.getClass().toString() + "'");
        }
    }

    private List<Object> retrieveItemData() {
        int itemCount;
        if (this.columnViewer instanceof TableViewer) {
            Table table = ((TableViewer)this.columnViewer).getTable();
            itemCount = table.getItemCount();
        } else if (this.columnViewer instanceof TreeViewer) {
            Tree tree = ((TreeViewer)this.columnViewer).getTree();
            itemCount = tree.getItemCount();
        } else {
            Logger log = Logger.getGlobal();
            log.severe("Should never happen... unsupported viewer type");
            return null;
        }
        IContentProvider content = this.columnViewer.getContentProvider();
        if (content instanceof ILazyContentProvider) {
            ILazyContentProvider lazy = (ILazyContentProvider)content;
            int ctr = 0;
            while (ctr < itemCount) {
                Tree tree;
                TableItem item;
                if (this.columnViewer instanceof TableViewer) {
                    Table table = ((TableViewer)this.columnViewer).getTable();
                    item = table.getItem(ctr);
                    if (item.getData() == null) {
                        lazy.updateElement(ctr);
                    }
                } else if (this.columnViewer instanceof TreeViewer && (item = (tree = ((TreeViewer)this.columnViewer).getTree()).getItem(ctr)).getData() == null) {
                    lazy.updateElement(ctr);
                }
                ++ctr;
            }
        }
        ArrayList<Object> items = new ArrayList<Object>(itemCount);
        int ctr = 0;
        while (ctr < itemCount) {
            TableItem item;
            if (this.columnViewer instanceof TableViewer) {
                Table table = ((TableViewer)this.columnViewer).getTable();
                item = table.getItem(ctr);
                items.add(item.getData());
            } else if (this.columnViewer instanceof TreeViewer) {
                Tree tree = ((TreeViewer)this.columnViewer).getTree();
                item = tree.getItem(ctr);
                this.harvest((TreeItem)item, items);
            }
            ++ctr;
        }
        return items;
    }

    private void harvest(TreeItem item, List<Object> items) {
        items.add(item.getData());
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.harvest(child, items);
            ++n2;
        }
    }

    private void initialize() {
        StructuredSelection selection = (StructuredSelection)this.columnViewer.getSelection();
        Object selectedObject = selection.getFirstElement();
        EObject selectedEObject = null;
        if (selectedObject instanceof EObject) {
            Command finishWrapper;
            boolean needsTakenNames;
            List<Object> itemData = this.retrieveItemData();
            selectedEObject = (EObject)selectedObject;
            this.populateAffectedObjects(selectedEObject, (IStructuredSelection)selection, itemData);
            FeatureViewTranslator translator = new FeatureViewTranslator(selectedEObject, this.column);
            FeatureInfo featureInfo = translator.getFeatureInfo();
            ArrayList<String> takenNames = null;
            boolean bl = needsTakenNames = featureInfo.getFeatureType() == 2;
            if (needsTakenNames) {
                takenNames = new ArrayList<String>();
                this.addTakenNames(this.columnViewer, this.column, (List<?>)this.notaffected, (List<String>)takenNames);
            }
            CopyDownInfo copyDownInfo = null;
            for (EObject affectedEObject : this.affected) {
                copyDownInfo = this.eObjectCopyDown.copyDown(selectedEObject, affectedEObject, copyDownInfo, translator, this, this.mode, takenNames);
                if (copyDownInfo == null || copyDownInfo.isStopper()) break;
                if (!needsTakenNames) continue;
                this.addTakenName(this.columnViewer, this.column, copyDownInfo, takenNames);
            }
            if ((finishWrapper = this.eObjectCopyDown.createFinishCommand(translator, this.mode, selectedEObject)) != null) {
                this.appendCommand(finishWrapper);
            }
        }
    }

    private BasicEList<CopyDownObjectClass> fetchSiblings(EObject base) {
        BasicEList siblings;
        try {
            EObject container = base.eContainer();
            int featureID = base.eContainingFeature().getFeatureID();
            EStructuralFeature feature = container.eClass().getEStructuralFeature(featureID);
            siblings = new BasicEList((Collection)((EList)container.eGet(feature)));
        }
        catch (Exception e) {
            Logger log = Logger.getGlobal();
            log.severe("COPYDOWNEXCEPTION" + e.getMessage());
            siblings = new BasicEList();
        }
        return siblings;
    }

    private void populateAffectedObjects(CopyDownObjectClass selectedObject, IStructuredSelection selection, List<Object> tableValues) {
        Iterator<Object> tableElements;
        BasicEList<CopyDownObjectClass> siblings = this.fetchSiblings((EObject)selectedObject);
        boolean multiSelection = selection.size() > 1;
        HashMap<EObject, Boolean> siblingsInSelection = new HashMap<EObject, Boolean>();
        for (EObject s : siblings) {
            siblingsInSelection.put(s, false);
        }
        if (multiSelection) {
            tableElements = selection.iterator();
        } else {
            tableElements = tableValues.iterator();
            Iterator<Object> preRun = tableValues.iterator();
            while (preRun.hasNext()) {
                if (selectedObject.equals(preRun.next())) break;
                tableElements.next();
            }
        }
        if (tableElements.hasNext()) {
            tableElements.next();
        }
        while (tableElements.hasNext()) {
            Object tabElement = tableElements.next();
            if (!siblingsInSelection.containsKey(tabElement)) continue;
            EObject selected = (EObject)tabElement;
            this.affected.add((Object)selected);
            siblingsInSelection.put(selected, true);
        }
        for (Map.Entry sibling : siblingsInSelection.entrySet()) {
            if (((Boolean)sibling.getValue()).booleanValue()) continue;
            this.notaffected.add((Object)((EObject)sibling.getKey()));
        }
    }

    @Override
    public void run() {
        this.initialize();
        super.run();
    }
}

