/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.images;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ImageCache {
    private static final Map<String, Image> imageMap = new HashMap<String, Image>();

    public static ImageDescriptor getImageDescriptor(String path) {
        return ImageDescriptor.createFromFile(ImageCache.class, (String)path);
    }

    static Image getImage(String id) {
        Image image = imageMap.get(id);
        return image;
    }

    public static Image getImageFromString(String localPath) {
        Bundle bundle = Platform.getBundle((String)"com.excentis.products.byteblower.gui.views");
        URL fullPath = FileLocator.find((Bundle)bundle, (IPath)new Path(localPath), null);
        if (fullPath != null) {
            return ImageCache.getImage(fullPath);
        }
        return null;
    }

    public static Image getImage(URL url) {
        String id = url.getPath();
        Image image = imageMap.get(id);
        if (image == null) {
            ImageDescriptor descr = ImageDescriptor.createFromURL((URL)url);
            image = descr.createImage();
            imageMap.put(id, image);
        }
        return image;
    }

    static void save(String id, Image image) {
        imageMap.put(id, image);
    }
}

