/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.model.reader.impl.ByteReader;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ByteCellEditor
extends TextCellEditor {
    public ByteCellEditor(Composite parent) {
        super(parent);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                ByteCellEditor.this.autoCompleteCheck(t);
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                e.doit = ByteReader.isHexByteStringPart((String)result);
            }
        });
    }

    private void autoCompleteCheck(Text t) {
        String orig;
        String text = orig = t.getText();
        text = text.replaceAll("-", "").toUpperCase();
        int i = 2;
        while (i < text.length()) {
            text = String.valueOf(text.substring(0, i)) + "-" + text.substring(i, text.length());
            i += 3;
        }
        if (!text.equals(orig)) {
            int caretPos = t.getCaretPosition();
            t.setText(text);
            t.setSelection(caretPos += text.length() - orig.length(), caretPos);
        }
    }

    public Object doGetValue() {
        String valueString = (String)super.doGetValue();
        return ByteReader.getHexByte((String)valueString);
    }

    public void doSetValue(Object value) {
        if (!(value instanceof Byte)) {
            System.out.println("ByteCellEditor Error : Value is no Byte!");
            return;
        }
        String stringValue = ByteReader.toHexString((byte)((Byte)value));
        super.doSetValue((Object)stringValue);
    }
}

