/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public abstract class CompositeCellEditor
extends CellEditor {
    private Composite composite;
    private static final int defaultStyle = 4;
    protected int itemHeight;
    private static final int BORDER_SIZE = 3;

    public CompositeCellEditor() {
        this.setStyle(4);
    }

    public CompositeCellEditor(Composite parent) {
        this(parent, 4);
    }

    private CompositeCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        Table table = (Table)parent;
        this.itemHeight = table.getItemHeight() - 3;
        this.composite = new Composite(parent, 0);
        Layout layout = this.createLayout();
        this.composite.setLayout(layout);
        this.fillComposite(this.composite);
        this.addFocusListener();
        return this.composite;
    }

    private void addFocusListener() {
        FocusAdapter focusLost = new FocusAdapter(){
            int lastLostTime;
            int lastGainedTime;

            public void focusLost(FocusEvent e) {
                this.lastLostTime = e.time;
                this.checkGained();
            }

            public void focusGained(FocusEvent e) {
                this.lastGainedTime = e.time;
            }

            private void checkGained() {
                CompositeCellEditor.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            Thread.currentThread().interrupt();
                        }
                        if (lastGainedTime != lastLostTime) {
                            CompositeCellEditor.this.focusLost();
                        }
                    }
                });
            }
        };
        Control[] controls = this.composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control childControl = controls[i];
            childControl.addFocusListener((FocusListener)focusLost);
            ++i;
        }
    }

    protected abstract void fillComposite(Composite var1);

    protected abstract Layout createLayout();
}

