/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.ComboBoxCellEditor;
import java.math.BigInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class EditableComboBoxCellEditor
extends ComboBoxCellEditor {
    private BigInteger minInteger = null;
    private BigInteger maxInteger = null;
    private String value;

    public EditableComboBoxCellEditor(Composite parent, int style, String[] items, BigInteger minInt, BigInteger maxInt) {
        super(parent, style, items);
        this.init(minInt, maxInt);
    }

    private void init(BigInteger minInt, BigInteger maxInt) {
        this.minInteger = minInt;
        this.maxInteger = maxInt;
        this.getCombo().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                CCombo t = (CCombo)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                try {
                    BigInteger binteger = new BigInteger(result);
                    e.doit = e.doit && (EditableComboBoxCellEditor.this.minInteger == null || binteger.compareTo(EditableComboBoxCellEditor.this.minInteger) >= 0);
                    e.doit = e.doit && (EditableComboBoxCellEditor.this.maxInteger == null || binteger.compareTo(EditableComboBoxCellEditor.this.maxInteger) <= 0);
                }
                catch (Exception exception) {
                    boolean isSelection = EditableComboBoxCellEditor.this.getIndex(result) != -1;
                    boolean isEmpty = result.length() == 0;
                    e.doit = isEmpty || isSelection;
                }
            }
        });
        this.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String comboText = EditableComboBoxCellEditor.this.getCombo().getText();
                if (!comboText.isEmpty() && !EditableComboBoxCellEditor.this.value.equals(comboText)) {
                    EditableComboBoxCellEditor.this.setValue(comboText);
                }
            }
        });
    }

    @Override
    protected Object doGetValue() {
        return this.value;
    }

    @Override
    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof String));
        String stringValue = (String)value;
        try {
            BigInteger integerValue = new BigInteger(stringValue);
            this.value = integerValue.toString();
        }
        catch (NumberFormatException numberFormatException) {
            this.value = stringValue;
        }
        Point prev = this.getCombo().getSelection();
        this.getCombo().setText(this.value);
        this.getCombo().setSelection(prev);
    }

    private int getIndex(String stringValue) {
        String[] items = (String[])this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(stringValue)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

