/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.MacAddressValidator;
import com.excentis.products.byteblower.model.control.MacAddressController;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import com.excentis.products.byteblower.model.reader.MacAddressReader;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MacAddressCellEditor
extends TextCellEditor {
    public MacAddressCellEditor(Composite parent) {
        super(parent);
        this.setValidator(new MacAddressValidator());
        this.text.setTextLimit(17);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                MacAddressCellEditor.this.autoCompleteCheck(t);
                if (MacAddressController.isComplete((String)t.getText())) {
                    t.setForeground(null);
                } else {
                    t.setForeground(ByteBlowerColor.red);
                }
            }
        });
        this.text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text;
                e.text = text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if (!('0' <= chars[i] && chars[i] <= '9' || 'a' <= chars[i] && chars[i] <= 'f' || 'A' <= chars[i] && chars[i] <= 'F' || chars[i] == '-')) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
    }

    private void autoCompleteCheck(Text t) {
        String orig;
        String text = orig = t.getText();
        text = text.replaceAll("-", "").toUpperCase();
        int i = 2;
        while (i < text.length()) {
            text = String.valueOf(text.substring(0, i)) + "-" + text.substring(i, text.length());
            i += 3;
        }
        if (!text.equals(orig)) {
            int caretPos = t.getCaretPosition();
            t.setText(text);
            t.setSelection(caretPos += text.length() - orig.length(), caretPos);
        }
    }

    protected void editOccured(ModifyEvent e) {
        super.editOccured(e);
        if (this.isValueValid()) {
            this.text.setForeground(null);
        } else {
            this.text.setForeground(ByteBlowerColor.red);
        }
    }

    public Object doGetValue() {
        Object value = super.doGetValue();
        if (value instanceof String) {
            try {
                return MacAddressController.createBytesFromString((String)((String)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public void doSetValue(Object value) {
        MacAddressReader reader = (MacAddressReader)value;
        super.doSetValue((Object)reader.getAddress());
    }
}

