/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TimeCellEditor
extends TextCellEditor {
    private TimeCellEditor(Composite parent, VerifyListener myTextVerifyListener) {
        super(parent);
        this.text.addVerifyListener(myTextVerifyListener);
    }

    public TimeCellEditor(Composite parent) {
        this(parent, new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                boolean lenient;
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                HighResolutionCalendarParser.PARSE_RESULT parseFeedback = HighResolutionCalendarParser.parseToRelativeTime((String)result, null);
                e.doit = lenient = HighResolutionCalendarParser.PARSE_RESULT.SUCCESS == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.INCOMPLETE_UNIT == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.OUT_ORDER == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.BELOW_RESOLUTION == parseFeedback || HighResolutionCalendarParser.PARSE_RESULT.NO_VAL_FOR_UNIT == parseFeedback;
                if (HighResolutionCalendarParser.PARSE_RESULT.SUCCESS == parseFeedback) {
                    t.setForeground(null);
                } else {
                    t.setForeground(ExcentisColors.red);
                }
            }
        });
    }

    protected final void doSetValue(Object value) {
        if (value instanceof HighResolutionCalendar) {
            super.doSetValue((Object)this.getContent((HighResolutionCalendar)value));
        } else {
            System.err.println("TimeCellEditor doSetValue error");
        }
    }

    protected final Object doGetValue() {
        Object value = super.doGetValue();
        if (value instanceof String) {
            return this.parseTime((String)value);
        }
        return null;
    }

    private HighResolutionCalendar parseTime(String timeString) {
        HighResolutionCalendar value = new HighResolutionCalendar();
        if (HighResolutionCalendarParser.setRelativeTime((String)timeString, (HighResolutionCalendar)value)) {
            return value;
        }
        return null;
    }

    protected String getContent(HighResolutionCalendar value) {
        if (value != null) {
            return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)value, (boolean)true, (boolean)true, (boolean)false);
        }
        return null;
    }
}

