/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.preferences.ui.general;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.preferences.ui.general.CloudApiKeyCheck;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GeneralParametersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private static final String NO_API_KEY_SUGGESTION = "Enter an API key";
    private static final int MIN_FREE_TCP = 1025;
    private static final int MAX_FREE_TCP = 65535;
    private static final int MIN_UNDO_LIMIT = 1;
    private static final int MAX_UNDO_LIMIT = 9999;
    private static final boolean FEATURE_TOGGLE_BROWSER_SELECTION = false;
    private Spinner undoLimitSpinner;
    private Text txtOutput;
    private Button browseButton;
    private static final int MIN_RECENT_PROJECTS = 1;
    private static final int MAX_RECENT_PROJECTS = 999;
    private Spinner recentProjectsSpinner;
    protected IWorkbench workbench;
    private Button useEmbeddedBrowser;
    private Spinner tcpExportPort;
    private Text apiKey;

    private static void helpPrometheus() {
        Logger logger = Logger.getGlobal();
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://support.excentis.com/index.php?/Knowledgebase/Article/View/mutliple-byteblower-guis-on-the-same-machine"));
        }
        catch (PartInitException e) {
            logger.log(Level.WARNING, "Can not open Browser", e);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Wrong url for Prometheus help", e);
        }
    }

    public GeneralParametersPreferencePage() {
    }

    public GeneralParametersPreferencePage(String title) {
        super(title);
    }

    public GeneralParametersPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setLayout((Layout)new GridLayout());
        Group undoRedoGroup = new Group((Composite)folder, 0);
        undoRedoGroup.setLayoutData((Object)new GridData(768));
        undoRedoGroup.setLayout((Layout)new GridLayout(2, false));
        undoRedoGroup.setText("Undo/Redo:");
        Label label = new Label((Composite)undoRedoGroup, 0);
        label.setText("History Limit:");
        this.undoLimitSpinner = new Spinner((Composite)undoRedoGroup, 2048);
        this.undoLimitSpinner.setMinimum(0);
        this.undoLimitSpinner.setMaximum(10000);
        this.undoLimitSpinner.addModifyListener((ModifyListener)this);
        int limit = ByteBlowerPreferences.getUndoLimit();
        this.undoLimitSpinner.setSelection(limit);
        Group outputLocationGroup = new Group((Composite)folder, 0);
        outputLocationGroup.setLayoutData((Object)new GridData(768));
        outputLocationGroup.setLayout((Layout)new GridLayout(3, false));
        outputLocationGroup.setText("Archive:");
        label = new Label((Composite)outputLocationGroup, 0);
        label.setText("Location:");
        this.txtOutput = new Text((Composite)outputLocationGroup, 2048);
        this.txtOutput.setLayoutData((Object)new GridData(768));
        this.txtOutput.setEditable(false);
        this.txtOutput.setText(ByteBlowerPreferences.getArchiveLocation());
        this.browseButton = new Button((Composite)outputLocationGroup, 8);
        this.browseButton.setText("B&rowse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GeneralParametersPreferencePage.this.browseButtonPressed();
            }
        });
        label = new Label((Composite)outputLocationGroup, 0);
        GridData gridData = new GridData(2);
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        label.setText("All reports and project backups are stored here.");
        Group recentProjectsGroup = new Group((Composite)folder, 0);
        recentProjectsGroup.setLayoutData((Object)new GridData(768));
        recentProjectsGroup.setLayout((Layout)new GridLayout(2, false));
        recentProjectsGroup.setText("Recent Projects:");
        label = new Label((Composite)recentProjectsGroup, 0);
        label.setText("Maximum Amount:");
        this.recentProjectsSpinner = new Spinner((Composite)recentProjectsGroup, 2048);
        this.recentProjectsSpinner.setMinimum(1);
        this.recentProjectsSpinner.setMaximum(999);
        this.recentProjectsSpinner.addModifyListener((ModifyListener)this);
        int nofRecentProjectsLimit = ByteBlowerPreferences.getRecentProjectsLimit();
        this.recentProjectsSpinner.setSelection(nofRecentProjectsLimit);
        this.createBrowsingPreference((Composite)folder);
        return folder;
    }

    private void createBrowsingPreference(Composite folder) {
        Group browsingReports = new Group(folder, 0);
        browsingReports.setLayoutData((Object)new GridData(768));
        browsingReports.setLayout((Layout)new GridLayout(1, false));
        browsingReports.setText("Reporting options:");
        Composite exportTcpPortGroup = new Composite((Composite)browsingReports, 0);
        exportTcpPortGroup.setLayoutData((Object)new GridData(768));
        exportTcpPortGroup.setLayout((Layout)new GridLayout(2, false));
        Link label = new Link(exportTcpPortGroup, 0);
        label.setText("<a>Prometheus exporter </a> TCP port");
        this.tcpExportPort = new Spinner(exportTcpPortGroup, 64);
        this.tcpExportPort.setMaximum(65535);
        this.tcpExportPort.setMinimum(1025);
        this.tcpExportPort.setSelection(ByteBlowerPreferences.getOpenMetricsPort());
        label.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                GeneralParametersPreferencePage.helpPrometheus();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createApiKeyUI(Group browsingReports) {
        Composite apiKeyGroup = new Composite((Composite)browsingReports, 0);
        apiKeyGroup.setLayoutData((Object)new GridData(768));
        apiKeyGroup.setLayout((Layout)new GridLayout(2, false));
        Label apiKeyLabel = new Label(apiKeyGroup, 0);
        this.apiKey = new Text(apiKeyGroup, 2048);
        this.apiKey.setLayoutData((Object)new GridData(768));
        this.apiKey.setTextLimit(64);
        this.apiKey.addVerifyListener((VerifyListener)new ApiKeyValidationMessage("Excentis Cloud API key", apiKeyLabel, this.apiKey));
        this.apiKey.setMessage(NO_API_KEY_SUGGESTION);
        if (ByteBlowerPreferences.hasApiKey()) {
            this.apiKey.setText(ByteBlowerPreferences.getApiKey());
        }
    }

    private void browseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.browseButton.getShell());
        dialog.setMessage("Select the folder where you want reports and archives to be stored");
        String dirName = this.txtOutput.getText().trim();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.txtOutput.setText(selectedDirectory);
        }
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public void modifyText(ModifyEvent e) {
        String message = null;
        boolean valid = true;
        if (e.widget == this.undoLimitSpinner) {
            int selection = this.undoLimitSpinner.getSelection();
            if (selection < 1) {
                message = "The minimum History Limit is 1";
                valid = false;
            } else if (selection > 9999) {
                message = "The maximum History Limit is 9999";
                valid = false;
            }
        }
        this.setErrorMessage(message);
        this.setValid(valid);
    }

    public boolean performOk() {
        int undoLimit = this.undoLimitSpinner.getSelection();
        ByteBlowerPreferences.setUndoLimit((int)undoLimit);
        int maxRecentProjects = this.recentProjectsSpinner.getSelection();
        ByteBlowerPreferences.setRecentProjectsLimit((int)maxRecentProjects);
        String outputDir = this.txtOutput.getText();
        ByteBlowerPreferences.setExportDir((String)outputDir);
        String defaultReportOutput = this.txtOutput.getText().trim();
        if (!defaultReportOutput.equals("")) {
            ByteBlowerPreferences.setArchiveLocation((String)defaultReportOutput);
        }
        int tcpPortExport = this.tcpExportPort.getSelection();
        ByteBlowerPreferences.setOpenMetricsPort((int)tcpPortExport);
        String apiKeyVal = this.apiKey.getText();
        if (!NO_API_KEY_SUGGESTION.equals(apiKeyVal)) {
            ByteBlowerPreferences.setApiKey((String)apiKeyVal);
        }
        return true;
    }

    private static class ApiKeyValidationMessage
    implements VerifyListener {
        private static final String validApiTxt = ": \u2713 ";
        private static final String invalidApiTxt = ": \u2717 ";
        private static final String unvalidatedApiTxt = ":     ";
        private final Text apiKey;
        private final Label apiKeyLabel;
        private final String baseText;
        private final CloudApiKeyCheck validate;

        static {
            $SWITCH_TABLE$com$excentis$products$byteblower$gui$preferences$ui$general$CloudApiKeyCheck$ValidationResult = ApiKeyValidationMessage.$SWITCH_TABLE$com$excentis$products$byteblower$gui$preferences$ui$general$CloudApiKeyCheck$ValidationResult();
        }

        public ApiKeyValidationMessage(String baseText, Label infoLabel, Text userText) {
            this.apiKey = userText;
            this.apiKeyLabel = infoLabel;
            this.baseText = baseText;
            this.validate = new CloudApiKeyCheck();
            this.setText(unvalidatedApiTxt);
        }

        private String toMessage(CloudApiKeyCheck.ValidationResult result) {
            switch (result) {
                case UNUSABLE: {
                    return invalidApiTxt;
                }
                case VALID: {
                    return validApiTxt;
                }
                case UNCERTAIN: {
                    return unvalidatedApiTxt;
                }
            }
            return unvalidatedApiTxt;
        }

        private void setText(String validationMsg) {
            this.apiKeyLabel.setText(String.valueOf(this.baseText) + validationMsg);
        }

        private void run(final CloudApiKeyCheck.KeyResult result) {
            Display current = Display.getDefault();
            if (current != null && !current.isDisposed()) {
                current.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean noUI;
                        boolean bl = noUI = apiKeyLabel.isDisposed() || apiKey.isDisposed();
                        if (noUI) {
                            return;
                        }
                        String origText = apiKey.getText();
                        if (!result.key.equals(origText)) {
                            this.setText(ApiKeyValidationMessage.unvalidatedApiTxt);
                        } else {
                            this.setText(this.toMessage(result.result));
                        }
                    }
                });
            }
        }

        public void verifyText(VerifyEvent evt) {
            String currentText = this.apiKey.getText();
            int maxInputLength = this.apiKey.getTextLimit();
            String newTextUnlimited = String.valueOf(currentText.substring(0, evt.start)) + evt.text + currentText.substring(evt.end);
            String nextText = newTextUnlimited.substring(0, Math.min(newTextUnlimited.length(), maxInputLength));
            this.setText(unvalidatedApiTxt);
            this.validate.addCheck(nextText, this::run);
        }
    }
}

