/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.preferences;

import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class ByteBlowerPreferences {
    public static final String defaultCloud = "https://cloud.excentis.com/";
    static IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.excentis.products.byteblower.gui.preferences");
    private static final String warningLossLevelKey = "warningLossLevel";
    private static final String errorLossLevelKey = "errorLossLevel";
    private static final String numberOfDecimalsKey = "numberOfDecimals";
    private static final String numberOfLatencyDecimalsKey = "numberOfLatencyDecimals";
    public static final String archiveLocationKey = "archiveLocation";
    private static final String outputToPdfKey = "outputToPdf";
    private static final String outputToExcelKey = "outputToExcel";
    private static final String outputToDynamicHtmlKey = "outputToDynamicHtml";
    private static final String outputToHtmlKey = "outputToHtml";
    private static final String outputToDeprecatedHtmlKey = "outputToDeprecatedHtml";
    private static final String outputToCsvKey = "outputToCsv";
    private static final String outputToJsonKey = "outputToJson";
    private static final String latestShownServerVersionKey = "latestShownServerVersionForType";
    private static final String outputToDocxKey = "outputToDocx";
    private static final String outputProjectBackupKey = "outputProjectBackup";
    private static final String throughputUnitsKey = "throughputUnit";
    private static final String latencyUnitsKey = "latencyUnit";
    private static final String throughputTypeKey = "throughputType";
    private static final String identicalFramesWarningKey = "identicalFramesWarning";
    private static final String pauseAfterDhcpKey = "pauseAfterDhcp";
    private static final String enableScoutingFramesKey = "enableScoutingFrames";
    private static final String enableAutomaticTcpRestartKey = "enableAutomaticTcpRestart";
    private static final String ignoreInitializationErrorsKey = "ignoreInitializationErrors";
    private static final String autoRefreshAtStartupKey = "autoRefreshAtStartup";
    private static final String exportDirKey = "exportdir";
    private static final String nofServersKey = "nofServers";
    private static final String undoLimitKey = "undoLimit";
    private static final String nofRecentProjectsLimitKey = "recentProjectsLimit";
    private static final String portViewShowIpv4 = "portViewShowIpv4";
    private static final String portViewShowIpv6 = "portViewShowIpv6";
    private static final String multicastViewShowSourceSpecificMulticast = "multicastViewShowSourceSpecificMulticast";
    private static final String waitTimeAfterScenario = "waitTimeAfterScenario";
    private static final String dhcpTimeout = "dhcpTimeout";
    private static final String dhcpRetries = "dhcpRetries";
    private static final String latencyRangeStart = "latencyRangeStart";
    private static final String latencyRangeEnd = "latencyRangeEnd";
    private static final String syncedServersKey = "syncedServers";
    private static final String httpGraceKey = "httpGracePeriod";
    private static final String vlanSortingDirectionKey = "vlanSortingDirection";
    private static final String recentRunTitleKey = "recentRunTitle";
    private static final String messageShown64BitVersionAvailableKey = "64BitVersionAvailableMessageShown";
    private static final String defaultAuthorKey = "defaultAuthor";
    private static final String defaultProjectNameKey = "defaultProjectName";
    private static final String defaultResultsOverTimeEnabled = "embeddedResultsOverTime";
    private static final String defaultWarningNoRotEnabled = "warningNoRotEnabled";
    private static final String defaultScenarioHeartbeatIntervalKey = "scenarioHeartbeatInterval";
    private static final String showSolutionViewKey = "showSolutionView";
    private static final String showRootCausesOnlyKey = "showRootCausesOnly";
    private static final String archive = "Archive";
    private static final String OPENMETRICS_EXPORT_PORT_KEY = "openMetricsTCPPort";
    private static final String projectFileExtension = ".bbp";
    private static final String defaultWarningLossLevel = "0.01";
    private static final String defaultErrorLossLevel = "0.02";
    private static final int defaultNumberOfDecimals = 2;
    private static final int defaultNumberOfLatencyDecimals = 3;
    private static final String defaultWaitTimeAfterScenario = "5000000000";
    private static final String defaultDhcpTimeout = "1000000000";
    private static final String defaultDhcpRetries = "5";
    private static final String defaultLatencyRangeStart = "0";
    private static final String defaultLatencyRangeEnd = "100000000";
    private static final long defaultHttpGracePeriod = Long.MAX_VALUE;
    private static final boolean defaultVlanSortingDirection_OUTER_ON_TOP = Boolean.TRUE;
    private static final String defaultRecentRunTitle = "";
    private static final boolean defaultShowSolutionView = true;
    private static final boolean defaultShowRootCausesOnly = true;
    public static final String maximumDhcpRetries = "999999";
    public static final String maximumDhcpTimeout = "64000000000";
    public static final String minimumDhcpTimeout = "1000000";
    private static final int defaultUndoLimit = 100;
    private static final int defaultNofRecentProjectsLimit = 20;
    private static final String SERVER = "Server";
    private static final String NAME = "Name";
    private static final String ADDRESS = "Address";
    private static final String AVAHIID = "AvahiID";
    private static final int defaultOpenmetricsPort = 8123;
    private static final long defaultScenarioHeartbeatInterval = 5000000000L;
    private static final int defaultThroughputUnit = 2;
    private static final int defaultLatencyUnit = 14;
    private static final String apikeyKey = "excentisCloudApiKey";
    private static final String cloudBaseUrlKey = "excentCloudBaseUrlKey ";
    private static final int defaultThroughputType = 0;
    private static final Set<SimpleChangeListener> changeListeners = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private static final Map<String, Object> overriddenSettings = new HashMap<String, Object>();
    public static final int missingwidth = -1;

    static {
        prefs.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent arg0) {
                for (SimpleChangeListener listen : changeListeners) {
                    listen.preferenceChanged();
                }
            }
        });
    }

    public static void addListener(SimpleChangeListener interest) {
        changeListeners.add(interest);
    }

    public static String getProjectFileExtension() {
        return projectFileExtension;
    }

    public static String getWarningLossLevel() {
        return prefs.get(warningLossLevelKey, defaultWarningLossLevel);
    }

    public static String getErrorLossLevel() {
        return prefs.get(errorLossLevelKey, defaultErrorLossLevel);
    }

    public static int getNumberOfDecimals() {
        return prefs.getInt(numberOfDecimalsKey, 2);
    }

    public static int getNumberOfLatencyDecimals() {
        return prefs.getInt(numberOfLatencyDecimalsKey, 3);
    }

    public static boolean getOutputToHtml() {
        return prefs.getBoolean(outputToHtmlKey, false);
    }

    public static boolean getOutputToPdf() {
        return prefs.getBoolean(outputToPdfKey, false);
    }

    public static boolean getOutputToDocx() {
        return prefs.getBoolean(outputToDocxKey, false);
    }

    public static boolean getOutputToExcel() {
        return prefs.getBoolean(outputToExcelKey, false);
    }

    public static boolean getOutputToCsv() {
        return prefs.getBoolean(outputToCsvKey, false);
    }

    public static boolean getOutputToJson() {
        return prefs.getBoolean(outputToJsonKey, false);
    }

    public static boolean getOutputProjectBackup() {
        return prefs.getBoolean(outputProjectBackupKey, true);
    }

    public static int getThroughputUnit() {
        return prefs.getInt(throughputUnitsKey, 2);
    }

    public static int getThroughputType() {
        return prefs.getInt(throughputTypeKey, 0);
    }

    public static int getLatencyUnit() {
        return prefs.getInt(latencyUnitsKey, 14);
    }

    public static String getExportDir() {
        String exportDir = prefs.get(exportDirKey, ByteBlowerPreferences.getArchiveLocation());
        if (exportDir == defaultRecentRunTitle) {
            exportDir = ByteBlowerPreferences.getArchiveLocation();
            ByteBlowerPreferences.setExportDir(exportDir);
        }
        return exportDir;
    }

    public static String getAutoSaveFile() {
        StringBuilder name = new StringBuilder();
        name.append(ByteBlowerPreferences.getArchiveLocation());
        name.append(File.separatorChar);
        name.append("autosaved-project");
        name.append(ByteBlowerPreferences.getProjectFileExtension());
        return name.toString();
    }

    public static String getArchiveLocation() {
        File path;
        String archiveLocation = prefs.get(archiveLocationKey, ByteBlowerPreferences.getDefaultArchiveLocation());
        if (archiveLocation.equals(defaultRecentRunTitle)) {
            archiveLocation = ByteBlowerPreferences.getDefaultArchiveLocation();
        }
        if (!(path = new File(archiveLocation)).exists()) {
            archiveLocation = ByteBlowerPreferences.getDefaultArchiveLocation();
        }
        return archiveLocation;
    }

    private static String getDefaultArchiveLocation() {
        Path path = new Path(ByteBlowerPreferences.getRuntimeWorkspaceLocation());
        path = path.append(archive);
        return path.toOSString();
    }

    public static String getRuntimeWorkspaceLocation() {
        return Platform.getLocation().toOSString();
    }

    public static void setWarningLossLevel(String string) {
        prefs.put(warningLossLevelKey, string);
    }

    public static void setErrorLossLevel(String string) {
        prefs.put(errorLossLevelKey, string);
    }

    public static void setNumberOfDecimals(int integer) {
        prefs.putInt(numberOfDecimalsKey, integer);
    }

    public static void setNumberOfLatencyDecimals(int integer) {
        prefs.putInt(numberOfLatencyDecimalsKey, integer);
    }

    public static boolean setArchiveLocation(String defaultReportOutput) {
        boolean error = false;
        File path = new File(defaultReportOutput);
        boolean bl = error = !path.exists();
        if (!error) {
            prefs.put(archiveLocationKey, defaultReportOutput);
        }
        return error;
    }

    public static void setOutputToExcel(boolean selection) {
        prefs.putBoolean(outputToExcelKey, selection);
    }

    public static void setOutputToHtml(boolean selection) {
        prefs.putBoolean(outputToHtmlKey, selection);
    }

    public static void setOutputToCsv(boolean selection) {
        prefs.putBoolean(outputToCsvKey, selection);
    }

    public static void setOutputToDocx(boolean selection) {
        prefs.putBoolean(outputToDocxKey, selection);
    }

    public static void setOutputToPdf(boolean selection) {
        prefs.putBoolean(outputToPdfKey, selection);
    }

    public static void setOutputToJson(boolean selection) {
        prefs.putBoolean(outputToJsonKey, selection);
    }

    public static void setOutputProjectBackup(boolean selection) {
        prefs.putBoolean(outputProjectBackupKey, selection);
    }

    public static void setThroughputUnit(int throughput) {
        prefs.putInt(throughputUnitsKey, throughput);
    }

    public static void setLatencyUnit(int unit) {
        prefs.putInt(latencyUnitsKey, unit);
    }

    public static void setThroughputType(int throughput) {
        prefs.putInt(throughputTypeKey, throughput);
    }

    public static boolean getIdenticalFramesWarning() {
        return prefs.getBoolean(identicalFramesWarningKey, true);
    }

    public static boolean getPauseAfterDhcp() {
        return prefs.getBoolean(pauseAfterDhcpKey, true);
    }

    public static boolean getAutoRefreshAtStartup() {
        return prefs.getBoolean(autoRefreshAtStartupKey, true);
    }

    public static boolean getEnableScoutingFrames() {
        return prefs.getBoolean(enableScoutingFramesKey, true);
    }

    public static boolean getEnableAutomaticTcpRestart() {
        return prefs.getBoolean(enableAutomaticTcpRestartKey, true);
    }

    public static boolean getIgnoreInitializationErrors() {
        return prefs.getBoolean(ignoreInitializationErrorsKey, false);
    }

    public static void setIdenticalFramesWarning(boolean check) {
        prefs.putBoolean(identicalFramesWarningKey, check);
    }

    public static void setPauseAfterDhcp(boolean check) {
        prefs.putBoolean(pauseAfterDhcpKey, check);
    }

    public static void setAutoRefreshAtStartup(boolean check) {
        prefs.putBoolean(autoRefreshAtStartupKey, check);
    }

    public static void setEnableScoutingFrames(boolean check) {
        prefs.putBoolean(enableScoutingFramesKey, check);
    }

    public static void setIgnoreInitializationErrors(boolean check) {
        prefs.putBoolean(ignoreInitializationErrorsKey, check);
    }

    public static void setExportDir(String string) {
        prefs.put(exportDirKey, string);
    }

    public static void setDhcpTimeout(String string) {
        prefs.put(dhcpTimeout, string);
    }

    public static void setDhcpRetries(String string) {
        prefs.put(dhcpRetries, string);
    }

    public static int getNofServers() {
        return prefs.getInt(nofServersKey, 0);
    }

    public static String getServerName(int serverID) {
        return prefs.get(SERVER + serverID + NAME, null);
    }

    public static String getServerAddress(int serverID) {
        return prefs.get(SERVER + serverID + ADDRESS, null);
    }

    public static String getServerAvahiID(int serverID) {
        return prefs.get(SERVER + serverID + AVAHIID, null);
    }

    public static boolean getSyncServer() {
        return prefs.getBoolean(syncedServersKey, false);
    }

    public static void setSyncServer(boolean sync) {
        prefs.putBoolean(syncedServersKey, sync);
    }

    public static int getUndoLimit() {
        return prefs.getInt(undoLimitKey, 100);
    }

    public static void setUndoLimit(int undoLimit) {
        prefs.putInt(undoLimitKey, undoLimit);
    }

    public static int getRecentProjectsLimit() {
        return prefs.getInt(nofRecentProjectsLimitKey, 20);
    }

    public static void setRecentProjectsLimit(int limit) {
        prefs.putInt(nofRecentProjectsLimitKey, limit);
    }

    public static boolean getPortViewShowIpv4() {
        return prefs.getBoolean(portViewShowIpv4, true);
    }

    public static boolean getPortViewShowIpv6() {
        return prefs.getBoolean(portViewShowIpv6, true);
    }

    public static void setPortViewShowIpv4(boolean show) {
        prefs.putBoolean(portViewShowIpv4, show);
    }

    public static void setPortViewShowIpv6(boolean show) {
        prefs.putBoolean(portViewShowIpv6, show);
    }

    public static boolean getMulticastViewShowSourceSpecificMulticast() {
        return prefs.getBoolean(multicastViewShowSourceSpecificMulticast, true);
    }

    public static void setMulticastViewShowSourceSpecificMulticast(boolean show) {
        prefs.putBoolean(multicastViewShowSourceSpecificMulticast, show);
    }

    public static String getWaitTimeAfterScenario() {
        return prefs.get(waitTimeAfterScenario, defaultWaitTimeAfterScenario);
    }

    public static void setWaitTimeAfterScenario(String string) {
        prefs.put(waitTimeAfterScenario, string);
    }

    public static String getDhcpTimeout() {
        return prefs.get(dhcpTimeout, defaultDhcpTimeout);
    }

    public static String getDhcpRetries() {
        return prefs.get(dhcpRetries, defaultDhcpRetries);
    }

    public static String getLatencyRangeStart() {
        return prefs.get(latencyRangeStart, defaultLatencyRangeStart);
    }

    public static void setLatencyRangeStart(String string) {
        prefs.put(latencyRangeStart, string);
    }

    public static String getLatencyRangeEnd() {
        return prefs.get(latencyRangeEnd, defaultLatencyRangeEnd);
    }

    public static void setLatencyRangeEnd(String string) {
        prefs.put(latencyRangeEnd, string);
    }

    @Deprecated
    public static long getHttpGracePeriod() {
        return prefs.getLong(httpGraceKey, Long.MAX_VALUE);
    }

    @Deprecated
    private static void setHttpGracePeriod(long ns) {
        prefs.putLong(httpGraceKey, ns);
    }

    @Deprecated
    public static void setHttpGracePeriod(HighResolutionCalendar killTime) {
        ByteBlowerPreferences.setHttpGracePeriod(killTime.getTimeInNanoseconds());
    }

    public static IEclipsePreferences getPreferences() {
        return prefs;
    }

    public static boolean getVlanSortingDirection() {
        return prefs.getBoolean(vlanSortingDirectionKey, defaultVlanSortingDirection_OUTER_ON_TOP);
    }

    public static void setVlanSortingDirection(boolean outerOnTop) {
        prefs.putBoolean(vlanSortingDirectionKey, outerOnTop);
    }

    public static String getRecentRunTitle() {
        return prefs.get(recentRunTitleKey, defaultRecentRunTitle);
    }

    public static void setRecentRunTitle(String runTitle) {
        prefs.put(recentRunTitleKey, runTitle);
    }

    public static boolean getShowSolutionView() {
        return prefs.getBoolean(showSolutionViewKey, true);
    }

    public static void setShowSolutionView(boolean showSolutionView) {
        prefs.putBoolean(showSolutionViewKey, showSolutionView);
    }

    public static boolean getShowRootCausesOnly() {
        return prefs.getBoolean(showRootCausesOnlyKey, true);
    }

    public static void setShowRootCausesOnly(boolean show) {
        prefs.putBoolean(showRootCausesOnlyKey, show);
    }

    public static void storeColumnWidth(String columnIdentifier, int width) {
        prefs.putInt(columnIdentifier, width);
    }

    public static int getStoredColumnWidth(String columnIdentifier) {
        int width = prefs.getInt(columnIdentifier, -1);
        return width;
    }

    public static void setEnableAutomaticTcpRestart(boolean check) {
        prefs.putBoolean(enableAutomaticTcpRestartKey, check);
    }

    public static boolean getUseHighcharts() {
        return true;
    }

    public static String getPopuppedVersion(String type) {
        return prefs.get(latestShownServerVersionKey + type, null);
    }

    public static void setPopuppedVersion(String type, String version) {
        prefs.put(latestShownServerVersionKey + type, version);
    }

    public static boolean get64BitVersionAvailableMessageShown() {
        return prefs.getBoolean(messageShown64BitVersionAvailableKey, false);
    }

    public static void set64BitVersionAvailableMessageShown() {
        prefs.putBoolean(messageShown64BitVersionAvailableKey, true);
    }

    public static boolean setDefaultResultsOverTimeEnabled(boolean isEnabled) {
        prefs.putBoolean(defaultResultsOverTimeEnabled, isEnabled);
        return isEnabled;
    }

    public static boolean getDefaultResultsOverTimeEnabled() {
        return prefs.getBoolean(defaultResultsOverTimeEnabled, true);
    }

    public static String getDefaultAuthor() {
        return prefs.get(defaultAuthorKey, System.getProperty("user.name"));
    }

    public static void setDefaultAuthor(String defaultAuthor) {
        prefs.put(defaultAuthorKey, defaultAuthor);
    }

    public static boolean setWarningNoRotEnabled(boolean isEnabled) {
        prefs.putBoolean(defaultWarningNoRotEnabled, isEnabled);
        return isEnabled;
    }

    public static boolean getWarningNoRotEnabled() {
        return prefs.getBoolean(defaultWarningNoRotEnabled, true);
    }

    public static int getOpenMetricsPort() {
        return prefs.getInt(OPENMETRICS_EXPORT_PORT_KEY, 8123);
    }

    public static int setOpenMetricsPort(int newPort) {
        prefs.putInt(OPENMETRICS_EXPORT_PORT_KEY, newPort);
        return newPort;
    }

    public static String getDefaultProjectName() {
        return prefs.get(defaultProjectNameKey, "ByteBlower_Project");
    }

    public static void setDefaultProjectName(String defaultProjectName) {
        prefs.put(defaultProjectNameKey, defaultProjectName);
    }

    public static long getDefaultScenarioHeartbeatInterval() {
        return prefs.getLong(defaultScenarioHeartbeatIntervalKey, 5000000000L);
    }

    public static void setDefaultScenarioHeartbeatInterval(long scenarioHeartbeatInterval) {
        prefs.putLong(defaultScenarioHeartbeatIntervalKey, scenarioHeartbeatInterval);
    }

    public static boolean isReportOutputToDeprecatedHtml() {
        return prefs.getBoolean(outputToDeprecatedHtmlKey, false);
    }

    public static void setOutputToDeprecatedHtml(boolean generateDeprecatedHtml) {
        prefs.putBoolean(outputToDeprecatedHtmlKey, generateDeprecatedHtml);
    }

    public static boolean getOutputToDynamicHtml() {
        return prefs.getBoolean(outputToDynamicHtmlKey, true);
    }

    public static boolean setOutputToDynamicHtml(boolean generateDynamicHtml) {
        prefs.putBoolean(outputToDynamicHtmlKey, generateDynamicHtml);
        return generateDynamicHtml;
    }

    public static boolean hasApiKey() {
        return ByteBlowerPreferences.getApiKey() != null && !ByteBlowerPreferences.getApiKey().isBlank();
    }

    public static String getApiKey() {
        String originalKey = prefs.get(apikeyKey, defaultRecentRunTitle);
        return String.valueOf(overriddenSettings.getOrDefault(apikeyKey, originalKey));
    }

    public static String setApiKey(String key) {
        prefs.put(apikeyKey, key);
        return key;
    }

    public static String overrideApiKeyTemporarily(String key) {
        overriddenSettings.put(apikeyKey, key);
        return key;
    }

    public static String getExcentisCloudUrl() {
        return prefs.get(cloudBaseUrlKey, defaultCloud);
    }

    public static enum PreferredBrowser {
        EMBEDDED,
        DEFAULT_EXTERN;

    }

    public static interface SimpleChangeListener {
        public void preferenceChanged();
    }
}

