/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.preferences.recent;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.util.IOpenCloseLocationListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;

public class RecentProjects {
    public static final String nofRecentProjectsKey = "NofRecentProjects";
    private static final String recentProjectPrefixKey = "RecentProject_";

    static {
        ProjectSwitchNotifier.getInstance().addOpenCloseListener((IOpenCloseLocationListener)new ProjectOpener());
    }

    public static void add(String filename) {
        int maxNofRecentProjects;
        if (filename == null || filename.isEmpty()) {
            return;
        }
        boolean alreadyAdded = false;
        int nofRecentProjects = ByteBlowerPreferences.getPreferences().getInt(nofRecentProjectsKey, 0);
        if (nofRecentProjects > (maxNofRecentProjects = ByteBlowerPreferences.getRecentProjectsLimit())) {
            nofRecentProjects = maxNofRecentProjects;
        }
        String[] recentProjects = RecentProjects.getRecentProjects();
        nofRecentProjects = Math.min(recentProjects.length, nofRecentProjects);
        int position = 1;
        ByteBlowerPreferences.getPreferences().put(recentProjectPrefixKey + position++, filename);
        int i = 0;
        while (i < nofRecentProjects) {
            String recentProject = recentProjects[i];
            if (recentProject.equals(filename)) {
                alreadyAdded = true;
            } else {
                ByteBlowerPreferences.getPreferences().put(recentProjectPrefixKey + position++, recentProject);
            }
            ++i;
        }
        if (!alreadyAdded) {
            ByteBlowerPreferences.getPreferences().putInt(nofRecentProjectsKey, ++nofRecentProjects);
        }
    }

    public static String[] getRecentProjects() {
        String[] returnStrings = null;
        RecentProjects.removeInvalidProjects();
        int nofRecentProjects = ByteBlowerPreferences.getPreferences().getInt(nofRecentProjectsKey, 0);
        int maxNofRecentProjects = ByteBlowerPreferences.getRecentProjectsLimit();
        if (nofRecentProjects > maxNofRecentProjects) {
            nofRecentProjects = maxNofRecentProjects;
        }
        returnStrings = new String[nofRecentProjects];
        int i = 1;
        while (i <= nofRecentProjects) {
            String recentProject;
            returnStrings[i - 1] = recentProject = ByteBlowerPreferences.getPreferences().get(recentProjectPrefixKey + i, null);
            ++i;
        }
        return returnStrings;
    }

    private static boolean isValidPath(String path) {
        try {
            File testRecentFile = new File(path);
            return testRecentFile.exists();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static void removeInvalidProjects() {
        int nofRecentProjects = ByteBlowerPreferences.getPreferences().getInt(nofRecentProjectsKey, 0);
        ArrayList<String> invalid = new ArrayList<String>();
        int i = 1;
        while (i <= nofRecentProjects) {
            String recentProject = ByteBlowerPreferences.getPreferences().get(recentProjectPrefixKey + i, null);
            if (recentProject != null && !RecentProjects.isValidPath(recentProject)) {
                invalid.add(recentProject);
            }
            ++i;
        }
        for (String invalidProject : invalid) {
            RecentProjects.remove(invalidProject);
        }
    }

    private static void remove(String removeProject) {
        int nofRecentProjects = ByteBlowerPreferences.getPreferences().getInt(nofRecentProjectsKey, 0);
        boolean found = false;
        int i = 1;
        while (i <= nofRecentProjects) {
            String recentProject = ByteBlowerPreferences.getPreferences().get(recentProjectPrefixKey + i, null);
            if (recentProject != null) {
                if (found) {
                    ByteBlowerPreferences.getPreferences().put(recentProjectPrefixKey + (i - 1), recentProject);
                } else if (recentProject.equals(removeProject)) {
                    found = true;
                }
            }
            ++i;
        }
        if (found) {
            ByteBlowerPreferences.getPreferences().putInt(nofRecentProjectsKey, nofRecentProjects - 1);
        }
    }

    private static class ProjectOpener
    implements IOpenCloseLocationListener {
        private ProjectOpener() {
        }

        public void projectOpenedOrClosed(ByteBlowerProject project, URI location) {
            if (location != null && location.isFile()) {
                RecentProjects.add(location.toFileString());
            }
        }
    }
}

