/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.refresher;

import com.excentis.products.byteblower.gui.history.operations.server.UndoableByteBlowerConfigurationOperation;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.PhysicalConfigurationController;
import com.excentis.products.byteblower.server.model.PhysicalConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ServerRepositoryFetch
extends Job {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final int TIMEOUT = 2000;
    private static final String BDDL_ADDRESS = "http://bbdl.excentis.com/server/update2.0/latest-versions.php";
    private final PhysicalConfiguration configuration;

    public ServerRepositoryFetch(PhysicalConfiguration physicalConfiguration) {
        super("Fetch server");
        this.setPriority(50);
        this.setSystem(true);
        this.configuration = physicalConfiguration;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            URL url = new URL(BDDL_ADDRESS);
            HttpURLConnection httpfetch = (HttpURLConnection)url.openConnection();
            httpfetch.setRequestMethod("GET");
            httpfetch.setConnectTimeout(2000);
            httpfetch.setReadTimeout(2000);
            InputStream data = httpfetch.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlReleases = db.parse(data);
            NodeList byteblowers = xmlReleases.getElementsByTagName("server");
            PhysicalConfigurationController control = ControllerFactory.create((PhysicalConfiguration)this.configuration);
            UndoableByteBlowerConfigurationOperation operation = new UndoableByteBlowerConfigurationOperation("Refresh Server release list");
            operation.appendCommand((Command)control.clearReleases());
            this.insertVersions(byteblowers, control, operation);
            operation.run();
            httpfetch.disconnect();
        }
        catch (SocketTimeoutException ioExep) {
            LOGGER.log(Level.WARNING, "The ByteBlower repository is not reachable", ioExep);
        }
        catch (IOException | ParserConfigurationException | SAXException ioExep) {
            LOGGER.log(Level.WARNING, "Couldn't read from server repo", ioExep);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unkown error while accessing the server repo", e);
        }
        return Status.OK_STATUS;
    }

    private void insertVersions(NodeList byteblowers, PhysicalConfigurationController control, UndoableByteBlowerConfigurationOperation operation) {
        int countBBTypes = byteblowers.getLength();
        int ctr = 0;
        while (ctr < countBBTypes) {
            NamedNodeMap attributes = byteblowers.item(ctr).getAttributes();
            if (attributes != null) {
                String serverSerie = attributes.getNamedItem("series").getNodeValue();
                String versionString = attributes.getNamedItem("version").getNodeValue();
                if (this.validVersionString(versionString)) {
                    operation.appendCommand(control.addRelease(serverSerie, versionString));
                }
            }
            ++ctr;
        }
    }

    private boolean validVersionString(String versionString) {
        try {
            Version.parseVersion((String)versionString);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

