/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.actiondispatcher;

import com.excentis.products.byteblower.gui.history.actiondispatcher.AbstractByteBlowerProjectAction;
import com.excentis.products.byteblower.gui.history.actions.ByteBlowerAction;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.history.actions.IEnablementChangedListener;
import com.excentis.products.byteblower.gui.history.actions.IFocusWidgetChangeListener;

abstract class ByteBlowerDispatchAction
extends AbstractByteBlowerProjectAction
implements IFocusWidgetChangeListener,
IEnablementChangedListener {
    protected IByteBlowerFocusDispatcher focusDispatcher;

    protected ByteBlowerDispatchAction(String actionName, IByteBlowerFocusDispatcher byteblowerFocusDispatcher) {
        super(actionName);
        this.focusDispatcher = byteblowerFocusDispatcher;
        this.addFocusWidgetChangeListener(this);
        this.setEnabled(false);
    }

    private void addFocusWidgetChangeListener(IFocusWidgetChangeListener listener) {
        this.focusDispatcher.addFocusWidgetChangeListener(listener);
    }

    protected IByteBlowerComposite getCurrentFocusWidget() {
        return this.focusDispatcher.getCurrentFocusComposite();
    }

    protected IByteBlowerViewerComposite getCurrentFocusViewerComposite() {
        IByteBlowerComposite focusComposite = this.focusDispatcher.getCurrentFocusComposite();
        if (focusComposite instanceof IByteBlowerViewerComposite) {
            return (IByteBlowerViewerComposite)focusComposite;
        }
        return null;
    }

    public abstract void update();

    public void run() {
        IByteBlowerComposite focusWidget = this.getCurrentFocusWidget();
        if (focusWidget == null) {
            System.err.println("ByteBlowerDispatchAction::run() : focusWidget is null...");
        } else {
            ByteBlowerAction runAction = this.getFocusAction(focusWidget);
            if (runAction != null) {
                runAction.run();
            }
        }
    }

    protected ByteBlowerAction getFocusAction(IByteBlowerComposite currentFocusWidget) {
        if (currentFocusWidget instanceof IByteBlowerViewerComposite) {
            IByteBlowerViewerComposite currentViewerComposite = (IByteBlowerViewerComposite)currentFocusWidget;
            return this.getViewerFocusAction(currentViewerComposite);
        }
        return null;
    }

    protected abstract ByteBlowerAction getViewerFocusAction(IByteBlowerViewerComposite var1);

    public void focusWidgetChanged(IByteBlowerComposite oldFocusComposite, IByteBlowerComposite newFocusComposite) {
        ByteBlowerAction newFocusAction;
        ByteBlowerAction oldFocusAction;
        if (oldFocusComposite != null && (oldFocusAction = this.getFocusAction(oldFocusComposite)) != null) {
            oldFocusAction.removeEnablementListener((IEnablementChangedListener)this);
        }
        boolean enabled = false;
        if (newFocusComposite != null && (newFocusAction = this.getFocusAction(newFocusComposite)) != null) {
            newFocusAction.addEnablementListener((IEnablementChangedListener)this);
            enabled = newFocusAction.isEnabled();
        }
        this.setEnabled(enabled);
    }

    public void enablementChanged(boolean enabled) {
        this.setEnabled(enabled);
    }
}

