/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server;

import com.excentis.products.byteblower.gui.swt.composites.server.DockerComposite;
import com.excentis.products.byteblower.gui.swt.composites.server.IDockListener;
import com.excentis.products.byteblower.gui.swt.composites.server.IDocker;
import com.excentis.products.byteblower.gui.swt.composites.server.IUndockListener;
import com.excentis.products.byteblower.gui.swt.composites.server.actions.DockAction;
import com.excentis.products.byteblower.gui.swt.composites.server.actions.UndockAction;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class Docker
implements IDocker {
    private DockAction dockAction = new DockAction();
    private UndockAction undockAction = new UndockAction();
    private boolean isLinked;
    private DockerComposite dockerComposite;

    @Override
    public void setSelectedByteBlowerGuiPorts(EList<ByteBlowerGuiPortReader> selectedPorts) {
        this.dockAction.setSelectedByteBlowerGuiPorts(selectedPorts);
        if (this.isLinked()) {
            this.link();
        }
        this.dockerComposite.updateWidgets();
    }

    private boolean isLinked() {
        return this.isLinked;
    }

    @Override
    public void setLinked(boolean linked) {
        this.isLinked = linked;
        if (linked) {
            this.link();
        }
    }

    @Override
    public void setSelectedDockables(EList<PhysicalDockable> dockables) {
        this.dockAction.setSelectedDockables(dockables);
        this.dockerComposite.updateWidgets();
    }

    @Override
    public void setSelectedDockedPorts(List<DockedByteBlowerPortReader> dockedPortReaders) {
        this.undockAction.setSelectedDockedPorts(dockedPortReaders);
        this.dockerComposite.updateWidgets();
    }

    @Override
    public void dock() {
        this.dockAction.run();
    }

    @Override
    public void undock() {
        this.undockAction.run();
    }

    @Override
    public boolean canDock() {
        return this.dockAction.isEnabled();
    }

    @Override
    public boolean canUndock() {
        return this.undockAction.isEnabled();
    }

    @Override
    public void addDockListener(IDockListener dockListener) {
        this.dockAction.addDockListener(dockListener);
    }

    @Override
    public void addUndockListener(IUndockListener undockListener) {
        this.undockAction.addUndockListener(undockListener);
    }

    @Override
    public void link() {
        this.dockAction.link();
    }

    @Override
    public void setDockerComposite(DockerComposite dockerComposite) {
        this.dockerComposite = dockerComposite;
    }

    @Override
    public void notifyUndockListeners() {
        this.undockAction.notifyUndockListeners();
    }
}

