/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server.dialogs;

import com.excentis.products.byteblower.gui.history.operations.server.UndoableByteBlowerConfigurationOperation;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.swt.composites.server.dialogs.DummyServer;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.AbstractServerController;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PhysicalServerPropertiesDialog
extends TitleAreaDialog
implements ModifyListener {
    private String titleText;
    private Text txtName;
    private Text txtAddress;
    private Image dlgTitleImage = null;
    private AbstractServer server;
    private Button btnOk;

    public PhysicalServerPropertiesDialog(Shell parentShell, AbstractServer server) {
        super(parentShell);
        this.titleText = "Edit ByteBlower Server";
        this.server = server;
    }

    public AbstractServer getServer() {
        return this.server;
    }

    public PhysicalServerPropertiesDialog(Shell parentShell) {
        super(parentShell);
        this.titleText = "New ByteBlower Server";
        this.server = new DummyServer();
        this.server.setLocalName("ByteBlower Server");
        this.server.setAddress("0.0.0.0");
        this.server.setServerLinkStatus(ServerLinkStatus.UNKNOWN);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Configuration");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.titleText);
        ImageDescriptor imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"dialogs/SelectPorts.gif");
        this.dlgTitleImage = imagedescr.createImage();
        this.setTitleImage(this.dlgTitleImage);
        this.updateWidgets();
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblAddress = new Label(composite, 0);
        lblAddress.setText("Address:");
        this.txtAddress = new Text(composite, 2048);
        this.txtAddress.setLayoutData((Object)new GridData(768));
        this.txtAddress.setText(this.server.getAddress());
        this.txtAddress.selectAll();
        this.txtAddress.addModifyListener((ModifyListener)this);
        Label lblName = new Label(composite, 0);
        lblName.setText("Name:");
        this.txtName = new Text(composite, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.setText(this.server.getLocalName());
        this.txtName.addModifyListener((ModifyListener)this);
        return parentComposite;
    }

    private String getServerName() {
        return this.txtName.getText().trim();
    }

    private String getServerAddress() {
        return this.txtAddress.getText().trim();
    }

    protected void okPressed() {
        String newAddress;
        String oldAddress;
        UndoableByteBlowerConfigurationOperation operation = new UndoableByteBlowerConfigurationOperation("Edit Server");
        AbstractServerController controller = ControllerFactory.create((AbstractServer)this.server);
        String oldName = controller.getLocalName();
        String newName = this.getServerName();
        boolean needRefresh = false;
        if (!oldName.equals(newName)) {
            needRefresh = true;
            operation.appendCommand(controller.createSetLocalNameCommand(newName));
        }
        if (!(oldAddress = controller.getServerAddress()).equals(newAddress = this.getServerAddress())) {
            needRefresh = true;
            operation.appendCommand(controller.createSetAddressCommand(newAddress));
            operation.appendCommand(controller.setLinkStatusUnknown());
            operation.appendCommand(controller.undock());
        }
        if (needRefresh) {
            operation.appendCommand(controller.refreshPorts());
        }
        operation.run();
        this.close();
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.txtAddress || e.getSource() == this.txtName) {
            this.updateWidgets();
        }
    }

    private void updateWidgets() {
        String errorMessage = null;
        boolean enableOk = true;
        if (this.getServerAddress().length() == 0) {
            errorMessage = "Specify the ByteBlower Server address";
            enableOk = false;
        } else if (this.addressAlreadyUsed()) {
            errorMessage = "A server with this address already exists";
            enableOk = false;
        } else if (this.getServerName().length() == 0) {
            errorMessage = "Specify the ByteBlower Server name";
            enableOk = false;
        }
        this.btnOk.setEnabled(enableOk);
        this.setErrorMessage(errorMessage);
    }

    private boolean addressAlreadyUsed() {
        String address = this.getServerAddress();
        PhysicalConfigurationReader reader = PhysicalConfigurationManager.getInstance().getPhysicalConfigurationReader();
        if (this.server instanceof DummyServer) {
            return false;
        }
        EList existingServers = reader.getAbstractServers(address);
        return !existingServers.isEmpty() && !existingServers.contains((Object)this.server);
    }
}

