/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.contentprovider;

import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public abstract class LazyContentProvider
extends AdapterFactoryContentProvider
implements ILazyContentProvider {
    protected Object[] content;
    protected IByteBlowerViewer byteblowerViewer;
    private Minimizer minimizer;

    public LazyContentProvider(AdapterFactory adapterFactory, IByteBlowerViewer byteblowerViewer) {
        super(adapterFactory);
        this.byteblowerViewer = byteblowerViewer;
        this.viewer = byteblowerViewer.getStructuredViewer();
        byteblowerViewer.setUseHashlookup(true);
    }

    private Minimizer getMinimizer() {
        if (this.minimizer == null) {
            this.minimizer = new Minimizer();
        }
        return this.minimizer;
    }

    public Object[] getElements(Object object) {
        BasicEList<EObject> elements = this.getLazyElements(object);
        if (this.isFiltered()) {
            elements = this.filterElements(object, elements);
        }
        if (this.isSorted()) {
            ByteBlowerComparator sorter = this.byteblowerViewer.getViewerComparator();
            elements = this.sortElements(sorter, object, (EList<EObject>)elements);
        }
        return elements.toArray();
    }

    protected abstract BasicEList<EObject> getLazyElements(Object var1);

    protected boolean isSorted() {
        ByteBlowerComparator sorter = this.byteblowerViewer.getViewerComparator();
        return sorter != null && sorter.isEnabled();
    }

    protected BasicEList<EObject> sortElements(ByteBlowerComparator sorter, Object object, EList<EObject> elements) {
        ArrayList<EObject> array = new ArrayList<EObject>((Collection<EObject>)elements);
        Collections.sort(array, sorter);
        UniqueEList sortedList = new UniqueEList();
        for (EObject obj : array) {
            sortedList.add((Object)obj);
        }
        return sortedList;
    }

    protected void testLog(String string) {
    }

    protected boolean isFiltered() {
        ByteBlowerFilter filter = this.byteblowerViewer.getViewerFilter();
        return filter != null && filter.isEnabled();
    }

    protected BasicEList<EObject> filterElements(Object object, BasicEList<EObject> elements) {
        this.testLog("LazyContentProvider::filterElements " + object);
        BasicEList filteredList = new BasicEList(elements);
        ByteBlowerFilter filter = this.byteblowerViewer.getViewerFilter();
        if (filter != null && filter.isEnabled()) {
            for (Object element : elements) {
                if (filter.select((Viewer)this.getViewer(), object, element)) continue;
                filteredList.remove(element);
            }
        }
        return filteredList;
    }

    private StructuredViewer getViewer() {
        return (StructuredViewer)this.viewer;
    }

    public void dispose() {
    }

    private Object getInput() {
        StructuredViewer viewer = this.getViewer();
        return viewer.getInput();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.testLog("LazyContentProvider::inputChanged " + oldInput + " -> " + newInput);
        this.viewer = viewer;
        this.updateInput(newInput);
    }

    private void updateInput(Object input) {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof ColumnViewer) {
            this.updateContent(input);
        }
    }

    protected void updateContent(Object input) {
        int currentItemCount;
        this.testLog("LazyContentProvider::updateContent");
        if (this.viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)this.viewer;
            Table table = tableViewer.getTable();
            currentItemCount = table.getItemCount();
        } else if (this.viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)this.viewer;
            Tree tree = treeViewer.getTree();
            currentItemCount = tree.getItemCount();
        } else {
            this.testLog("LazyContentProvider::updateContent - invalid viewer !");
            return;
        }
        int newItemCount = 0;
        if (input == null) {
            this.testLog("LazyContentProvider : input is NULL !");
        } else if (input instanceof EObject) {
            this.content = this.getElements(input);
            newItemCount = this.content.length;
        } else {
            this.content = null;
        }
        if (newItemCount != currentItemCount) {
            this.testLog("LazyContentProvider : setItemCount : " + newItemCount);
            if (this.viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)this.viewer;
                tableViewer.setItemCount(newItemCount);
            } else if (this.viewer instanceof TreeViewer) {
                TreeViewer cfr_ignored_0 = (TreeViewer)this.viewer;
            }
        }
        this.viewer.refresh();
        if (currentItemCount == 0 && newItemCount > 0) {
            this.testLog("LazyContentProvider : selecting the first item");
            Object firstObject = this.content[0];
            this.viewer.setSelection((ISelection)new StructuredSelection(firstObject));
        }
    }

    public void updateElement(int index) {
        if (this.content == null) {
            return;
        }
        int size = this.content.length;
        if (index >= size) {
            return;
        }
        Object object = this.content[index];
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            Table table = tableViewer.getTable();
            if (table.isDisposed()) {
                return;
            }
            int itemCount = table.getItemCount();
            if (index < itemCount) {
                this.testLog("LazyContentProvider::updateElement  - tableviewer replace object");
                tableViewer.replace(object, index);
            }
        } else if (viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            Tree tree = treeViewer.getTree();
            if (tree.isDisposed()) {
                return;
            }
            int itemCount = tree.getItemCount();
            if (index < itemCount) {
                this.testLog("LazyContentProvider::updateElement  - treeviewer replace object");
                Object[] paths = new TreePath[]{};
                TreePath empty = new TreePath(paths);
                treeViewer.replace((Object)empty, index, object);
            }
        } else {
            this.testLog("LazyContentProvider::updateElement NOT !");
        }
    }

    private void asyncExec(Runnable runnable) {
        Control control = this.viewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(runnable);
        }
    }

    public void doFullRefresh() {
        this.getMinimizer().doFullRefresh();
    }

    protected void updateRowIndex(int index) {
        this.getMinimizer().updateRowIndex(index);
    }

    static /* synthetic */ Viewer access$0(LazyContentProvider lazyContentProvider) {
        return lazyContentProvider.viewer;
    }

    private class Minimizer
    implements Runnable {
        private static final int UPDATE_ALL = -1;
        boolean isRunning = false;
        boolean waitLonger = true;
        CopyOnWriteArrayList<Integer> rowUpdateIndexes = new CopyOnWriteArrayList();

        private Minimizer() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public synchronized void setWaitLonger() {
            this.waitLonger = true;
        }

        public synchronized void updateRowIndex(Integer index) {
            if (this.rowUpdateIndexes.contains(index)) {
                return;
            }
            this.rowUpdateIndexes.add(index);
            this.doRun();
        }

        public void doFullRefresh() {
            this.rowUpdateIndexes.clear();
            this.rowUpdateIndexes.add(-1);
            this.doRun();
        }

        private void doRun() {
            this.setWaitLonger();
            if (this.isRunning) {
                LazyContentProvider.this.testLog("LazyContentProvider Minimizer IS ALREADY RUNNING ! ");
            } else {
                this.isRunning = true;
                LazyContentProvider.this.asyncExec(this);
            }
        }
    }
}

